/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.table;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.table.bo.SwapUpdateTableInfoReqBO;
import com.yqsmartcity.data.swap.api.table.service.SwapUpdateTableInfoService;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.po.TableColInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateTableInfoServiceImpl
implements SwapUpdateTableInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateTableInfoServiceImpl.class);
    @Autowired
    private TableColInfoDao tableColInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;

    @Transactional(rollbackFor={Exception.class})
    public void updateTableInfo(SwapUpdateTableInfoReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TableColInfoPO tableColInfoPO = this.tableColInfoDao.getModelById(reqBO.getUnid());
        if (null == tableColInfoPO) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728");
        }
        TableColInfoPO updateTableColInfoPO = new TableColInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)updateTableColInfoPO);
        updateTableColInfoPO.setUpdateTime(new Date());
        int result = this.tableColInfoDao.updateById(updateTableColInfoPO);
        if (result < 1) {
            throw new ZTBusinessException("\u8868\u5b57\u6bb5\u4fe1\u606f\u7f16\u8f91\u5931\u8d25");
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("M");
        swapInsertOperLogReqBO.setOperContent("\u7f16\u8f91:" + tableColInfoPO.getTableName() + "\u8868" + tableColInfoPO.getColumnName() + "\u5217\u63cf\u8ff0");
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapUpdateTableInfoReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010unid\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getColumnComment())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5217\u63cf\u8ff0\u3010columnComment\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperMode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u6a21\u5757\u3010operMpde\u3011\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }
}

