/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.bo.SwapInsertPublishBO;
import com.yqsmartcity.data.swap.api.bo.SwapInsertPublishRspBO;
import com.yqsmartcity.data.swap.api.dataX.service.SwapGetDataXJsonConfService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileListReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateDWXmlFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateEngineInfoTxtFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateFolderDiTxtFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.SwapGetDataWorksJsonConfService;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OoziePublishReqBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowNodeBO;
import com.yqsmartcity.data.swap.api.oozie.service.GetOozieWorkFlowFileService;
import com.yqsmartcity.data.swap.api.oozie.service.PublishToOozieService;
import com.yqsmartcity.data.swap.api.taskpublish.service.SwapInsertPublishService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareSubscribeReqBO;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareSubscribeRspBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.ExternalColumnBO;
import com.yqsmartcity.data.swap.interfaces.service.task.DataShareSubscribeService;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DataShareSubscribeServiceImpl
implements DataShareSubscribeService {
    private static final Logger log = LoggerFactory.getLogger(DataShareSubscribeServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(DataShareSubscribeServiceImpl.class);
    @Value(value="${datax.bin.home}")
    private String dataxBinHome;
    @Value(value="${technology.type}")
    private String technologyType;
    @Value(value="${dataworks.xml.type}")
    private String dataworksXmlType;
    @Value(value="${oozie.hdfs.path}")
    private String oozieHdfsPath;
    @Autowired
    private SwapInsertPublishService swapInsertPublishService;
    @Autowired
    private SwapGetDataXJsonConfService swapGetDataXJsonConfService;
    @Autowired
    private GetOozieWorkFlowFileService getOozieWorkFlowFileService;
    @Autowired
    private PublishToOozieService publishToOozieService;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private CreateFolderDiTxtFileService createFolderDiTxtFileService;
    @Autowired
    private CreateDWXmlFileService createDWXmlFileService;
    @Autowired
    private CreateEngineInfoTxtFileService createEngineInfoTxtFileService;
    @Autowired
    private SwapGetDataWorksJsonConfService swapGetDataWorksJsonConfService;
    private String folderDiPathName = "folderDi";
    private String folderMaxComputePathName = "folderMaxCompute";

    @Transactional(rollbackFor={Exception.class})
    public DataShareSubscribeRspBO shareData(DataShareSubscribeReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TaskInfoPO taskInfoPOQry = new TaskInfoPO();
        taskInfoPOQry.setTaskId(reqBO.getTaskId());
        taskInfoPOQry.setRelationDesc(reqBO.getOperSource());
        taskInfoPOQry.setStatus("1");
        if (this.taskInfoDao.getCheckByBetweenDate(taskInfoPOQry) > 0) {
            throw new ZTBusinessException("\u4efb\u52a1ID\u3010taskId\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        ArrayList<CreateImportFileRspBO> createImportFileRspBOList = new ArrayList<CreateImportFileRspBO>();
        if (this.technologyType.equals("opensource")) {
            this.getOozieContent(reqBO, createImportFileRspBOList);
        } else if (this.technologyType.equals("dataworks")) {
            this.getDataWorksContent(reqBO, createImportFileRspBOList);
        }
        TaskInfoPO taskInfoPO = new TaskInfoPO();
        taskInfoPO.setTaskId(reqBO.getTaskId());
        taskInfoPO.setTaskName(reqBO.getTaskName());
        taskInfoPO.setTaskBigType("02");
        taskInfoPO.setTaskSubType("1");
        taskInfoPO.setSwapFreq(reqBO.getSwapFreq());
        taskInfoPO.setConfigState("1");
        taskInfoPO.setEffDate(DataShareSubscribeServiceImpl.strToDate(reqBO.getEffDate(), "yyyy-MM-dd HH:mm:ss"));
        taskInfoPO.setExpDate(DataShareSubscribeServiceImpl.strToDate(reqBO.getExpDate(), "yyyy-MM-dd HH:mm:ss"));
        taskInfoPO.setStatus("1");
        taskInfoPO.setCreateTime(new Date());
        taskInfoPO.setUpdateTime(taskInfoPO.getCreateTime());
        taskInfoPO.setOperId(String.valueOf(reqBO.getOperId()));
        taskInfoPO.setOperName(reqBO.getOperName());
        taskInfoPO.setRelationDesc(reqBO.getOperSource());
        int taskInfoResult = this.taskInfoDao.insert(taskInfoPO);
        TableInfoPO tableInfoPO = new TableInfoPO();
        String strTable = DataShareSubscribeServiceImpl.getRandom(7);
        tableInfoPO.setDatabaseTableId(reqBO.getSourceDataSourceInfo().getDbDatabaseCode() + strTable);
        tableInfoPO.setTaskId(taskInfoPO.getTaskId());
        tableInfoPO.setDatabaseCode(reqBO.getSourceDataSourceInfo().getDbDatabaseCode());
        tableInfoPO.setSourceTable(reqBO.getSourceDbTableName());
        tableInfoPO.setTargetDatabaseCode(reqBO.getTargetDataSourceInfo().getDbDatabaseCode());
        tableInfoPO.setDatabaseTable(reqBO.getTargetDbTableName());
        tableInfoPO.setConfigState("0");
        tableInfoPO.setCreateTime(new Date());
        tableInfoPO.setUpdateTime(new Date());
        tableInfoPO.setStatus("1");
        tableInfoPO.setCreateTime(new Date());
        tableInfoPO.setUpdateTime(taskInfoPO.getCreateTime());
        tableInfoPO.setOperId(String.valueOf(reqBO.getOperId()));
        tableInfoPO.setOperName(reqBO.getOperName());
        int tableInfoResult = this.tableInfoDao.insert(tableInfoPO);
        if (tableInfoResult < 1) {
            throw new ZTBusinessException("\u8868\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
        DatabaseInfoPO sourceDatabaseInfoPO = new DatabaseInfoPO();
        sourceDatabaseInfoPO.setDatabaseCode(reqBO.getSourceDataSourceInfo().getDbDatabaseCode());
        if (this.databaseInfoDao.getCheckBy(sourceDatabaseInfoPO) == 0) {
            sourceDatabaseInfoPO.setDeptCode(reqBO.getSourceDataSourceInfo().getDbDeptCode());
            sourceDatabaseInfoPO.setDeptName(reqBO.getSourceDataSourceInfo().getDbDeptName());
            sourceDatabaseInfoPO.setSysCode(reqBO.getSourceDataSourceInfo().getDbSysCode());
            sourceDatabaseInfoPO.setSysName(reqBO.getSourceDataSourceInfo().getDbSysName());
            sourceDatabaseInfoPO.setDatabaseCode(reqBO.getSourceDataSourceInfo().getDbDatabaseCode());
            sourceDatabaseInfoPO.setDatabaseName(reqBO.getSourceDataSourceInfo().getDbDatabaseName());
            sourceDatabaseInfoPO.setDatabaseType(reqBO.getSourceDataSourceInfo().getDbType());
            sourceDatabaseInfoPO.setIpAddr(reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            sourceDatabaseInfoPO.setUserName(reqBO.getSourceDataSourceInfo().getDbUserName());
            sourceDatabaseInfoPO.setUserPass(reqBO.getSourceDataSourceInfo().getDbPasswd());
            sourceDatabaseInfoPO.setStatus("0");
            sourceDatabaseInfoPO.setCreateTime(new Date());
            sourceDatabaseInfoPO.setUpdateTime(taskInfoPO.getCreateTime());
            sourceDatabaseInfoPO.setOperId(String.valueOf(reqBO.getOperId()));
            sourceDatabaseInfoPO.setOperName(reqBO.getOperName());
            sourceDatabaseInfoPO.setDatabaseSource("2");
            this.databaseInfoDao.insert(sourceDatabaseInfoPO);
        }
        DatabaseInfoPO targetDatabaseInfoPO = new DatabaseInfoPO();
        targetDatabaseInfoPO.setDatabaseCode(reqBO.getTargetDataSourceInfo().getDbDatabaseCode());
        if (this.databaseInfoDao.getCheckBy(targetDatabaseInfoPO) == 0) {
            targetDatabaseInfoPO.setDeptCode(reqBO.getTargetDataSourceInfo().getDbDeptCode());
            targetDatabaseInfoPO.setDeptName(reqBO.getTargetDataSourceInfo().getDbDeptName());
            targetDatabaseInfoPO.setSysCode(reqBO.getTargetDataSourceInfo().getDbSysCode());
            targetDatabaseInfoPO.setSysName(reqBO.getTargetDataSourceInfo().getDbSysName());
            targetDatabaseInfoPO.setDatabaseCode(reqBO.getTargetDataSourceInfo().getDbDatabaseCode());
            targetDatabaseInfoPO.setDatabaseName(reqBO.getTargetDataSourceInfo().getDbDatabaseName());
            targetDatabaseInfoPO.setDatabaseType(reqBO.getTargetDataSourceInfo().getDbType());
            targetDatabaseInfoPO.setIpAddr(reqBO.getTargetDataSourceInfo().getDbJDBCUrl());
            targetDatabaseInfoPO.setUserName(reqBO.getTargetDataSourceInfo().getDbUserName());
            targetDatabaseInfoPO.setUserPass(reqBO.getTargetDataSourceInfo().getDbPasswd());
            targetDatabaseInfoPO.setStatus("1");
            targetDatabaseInfoPO.setCreateTime(new Date());
            targetDatabaseInfoPO.setUpdateTime(taskInfoPO.getCreateTime());
            targetDatabaseInfoPO.setOperId(String.valueOf(reqBO.getOperId()));
            targetDatabaseInfoPO.setOperName(reqBO.getOperName());
            targetDatabaseInfoPO.setDatabaseSource("2");
            this.databaseInfoDao.insert(targetDatabaseInfoPO);
        }
        SwapInsertPublishBO swapInsertPublishBO = new SwapInsertPublishBO();
        swapInsertPublishBO.setProjectSource(reqBO.getOperSource());
        swapInsertPublishBO.setUserId(String.valueOf(reqBO.getOperId()));
        swapInsertPublishBO.setUserName(reqBO.getOperName());
        swapInsertPublishBO.setCreateImportFileRspBOList(createImportFileRspBOList);
        List publishRsp = this.swapInsertPublishService.insertPublish(swapInsertPublishBO);
        if (this.technologyType.equals("opensource")) {
            OoziePublishReqBO ooziePublishReqBO = new OoziePublishReqBO();
            ooziePublishReqBO.setUnidList(publishRsp.stream().map(SwapInsertPublishRspBO::getPublishId).collect(Collectors.toList()));
            this.publishToOozieService.publishOozie(ooziePublishReqBO);
        }
        return new DataShareSubscribeRspBO();
    }

    private void getOozieContent(DataShareSubscribeReqBO reqBO, List<CreateImportFileRspBO> createImportFileRspBOList) {
        ArrayList<CreateImportFileBO> reateImportFileBO = new ArrayList<CreateImportFileBO>();
        CreateImportFileBO folderDiFileBO = new CreateImportFileBO();
        folderDiFileBO.setFileName(reqBO.getTaskId() + "_sync.json");
        folderDiFileBO.setFileType("json");
        folderDiFileBO.setWorkFlowName(reqBO.getTaskId());
        folderDiFileBO.setFileContent(this.swapGetDataXJsonConfService.getDataXJson(reqBO));
        reateImportFileBO.add(folderDiFileBO);
        CreateImportFileBO folderDiFileShellBO = new CreateImportFileBO();
        folderDiFileShellBO.setFileName(reqBO.getTaskId() + "_sync.sh");
        folderDiFileShellBO.setFileType("sh");
        folderDiFileShellBO.setWorkFlowName(reqBO.getTaskId());
        StringBuffer fileContent = new StringBuffer();
        fileContent.append("#!/bin/sh\n#ecoding=utf-8\n\nbizdate=${1}\nbeforebizdate=${2}\n\n");
        fileContent.append("#\u6267\u884cDataX\u811a\u672c\npython " + this.dataxBinHome + "/datax.py  -p\"-Dwhere='1=1' -Ddt=${bizdate}\" " + folderDiFileBO.getFileName());
        folderDiFileShellBO.setFileContent(fileContent);
        reateImportFileBO.add(folderDiFileShellBO);
        OozieWorkFlowBO oozieWorkFlowBO = new OozieWorkFlowBO();
        ArrayList<OozieWorkFlowNodeBO> nodeList = new ArrayList<OozieWorkFlowNodeBO>();
        OozieWorkFlowNodeBO oozieWorkFlowNodeBO = new OozieWorkFlowNodeBO();
        oozieWorkFlowNodeBO.setNodeType("datax_shell");
        oozieWorkFlowNodeBO.setNodeName(reqBO.getTaskId() + "_sync");
        oozieWorkFlowNodeBO.setScriptFileName(reqBO.getTaskId() + "_sync.sh");
        oozieWorkFlowNodeBO.setNextNodeName("end");
        nodeList.add(oozieWorkFlowNodeBO);
        oozieWorkFlowBO.setWorkFlowName(reqBO.getTaskId());
        oozieWorkFlowBO.setWorkFlowType(reqBO.getOperSource());
        oozieWorkFlowBO.setRunCycle(reqBO.getSwapFreq());
        oozieWorkFlowBO.setWorkStartTime(reqBO.getEffDate());
        oozieWorkFlowBO.setWorkEndTime(reqBO.getExpDate());
        oozieWorkFlowBO.setNodeList(nodeList);
        reateImportFileBO.addAll(this.getOozieWorkFlowFileService.getOozieFile(oozieWorkFlowBO));
        reateImportFileBO.forEach(e -> e.setFilePath(this.oozieHdfsPath + "/" + reqBO.getOperSource() + "-workflow/" + folderDiFileBO.getWorkFlowName()));
        CreateImportFileRspBO createImportFileRspBO = new CreateImportFileRspBO();
        createImportFileRspBO.setReateImportFileBO(reateImportFileBO);
        createImportFileRspBO.setTableName(reqBO.getTaskId());
        createImportFileRspBO.setBizType("sync");
        createImportFileRspBO.setTaskId(reqBO.getTaskId());
        createImportFileRspBOList.add(createImportFileRspBO);
    }

    private void getDataWorksContent(DataShareSubscribeReqBO reqBO, List<CreateImportFileRspBO> createImportFileRspBOList) {
        if ("private_cloud".equalsIgnoreCase(this.dataworksXmlType)) {
            this.folderDiPathName = "\u6570\u636e\u96c6\u6210";
            this.folderMaxComputePathName = "\u6570\u636e\u5f00\u53d1";
        }
        CreateImportFileListReqBO createImportFileBO = new CreateImportFileListReqBO();
        ArrayList<CreateImportFileReqBO> createImportFileReqBOList = new ArrayList<CreateImportFileReqBO>();
        CreateImportFileReqBO createImportFileReqBO = new CreateImportFileReqBO();
        createImportFileReqBO.setTaskId(reqBO.getTaskId());
        createImportFileReqBO.setDeptNo("TP002");
        createImportFileReqBO.setDeptName("\u6570\u636e\u5171\u4eab");
        createImportFileReqBO.setTableName(reqBO.getTaskId());
        ArrayList columnBoList = new ArrayList();
        reqBO.getSourceDbColumnBo().forEach(e -> {
            ColumnBO columnBo = new ColumnBO();
            BeanUtils.copyProperties((Object)e, (Object)columnBo);
            columnBoList.add(columnBo);
        });
        createImportFileReqBO.setColumnBo(columnBoList);
        createImportFileReqBO.setSourceTableName(reqBO.getSourceDbTableName());
        createImportFileReqBO.setEffDate(reqBO.getEffDate());
        createImportFileReqBO.setExpDate(reqBO.getExpDate());
        createImportFileReqBO.setSwapFreq(reqBO.getSwapFreq());
        createImportFileReqBOList.add(createImportFileReqBO);
        createImportFileBO.setListCreateImportFileReqBO(createImportFileReqBOList);
        createImportFileBO.setBizType("sync,sum_sync");
        ArrayList<CreateImportFileBO> reateImportFileBO = new ArrayList<CreateImportFileBO>();
        CreateImportFileBO xmlFileBO = new CreateImportFileBO();
        xmlFileBO.setFileName(reqBO.getTaskId() + "." + "xml");
        xmlFileBO.setFilePath("");
        xmlFileBO.setFileType("xml");
        xmlFileBO.setFileContent(this.createDWXmlFileService.createXml(createImportFileBO));
        reateImportFileBO.add(xmlFileBO);
        CreateImportFileBO engineInfoFileBO = new CreateImportFileBO();
        engineInfoFileBO.setFileName("engineInfo.txt");
        engineInfoFileBO.setFilePath("");
        engineInfoFileBO.setFileType("txt");
        engineInfoFileBO.setFileContent(this.createEngineInfoTxtFileService.createEngineInfoTxt(createImportFileBO));
        reateImportFileBO.add(engineInfoFileBO);
        CreateImportFileBO versionFileBO = new CreateImportFileBO();
        versionFileBO.setFileName("version.txt");
        versionFileBO.setFilePath("");
        versionFileBO.setFileType("txt");
        versionFileBO.setFileContent(new StringBuffer("V3"));
        reateImportFileBO.add(versionFileBO);
        CreateImportFileBO folderDiFileBO = new CreateImportFileBO();
        folderDiFileBO.setFileName(reqBO.getTaskId() + "_sync.txt");
        folderDiFileBO.setFilePath("file_content\\bizroot\\" + createImportFileReqBO.getDeptName() + "\\" + this.folderDiPathName);
        folderDiFileBO.setFileType("txt");
        folderDiFileBO.setFileContent(this.swapGetDataWorksJsonConfService.getDataWorksJson(reqBO));
        reateImportFileBO.add(folderDiFileBO);
        CreateImportFileBO odpsSqlFileBO = new CreateImportFileBO();
        odpsSqlFileBO.setFileName(reqBO.getTaskId() + "_sum_sync.txt");
        odpsSqlFileBO.setFilePath("file_content\\bizroot\\" + createImportFileReqBO.getDeptName() + "\\" + this.folderDiPathName);
        odpsSqlFileBO.setFileType("txt");
        DataShareSubscribeReqBO resultBO = new DataShareSubscribeReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)resultBO);
        resultBO.setSourceDbQuerySql("select '${bdp.system.bizdate}','tabe','112','$taskid','${execdate}','\u6210\u529f' from " + reqBO.getSourceDbTableName() + " limit 1");
        resultBO.setTargetDatabaseCode("dataswap");
        resultBO.setTargetDbTableName("swap_data_detail");
        resultBO.setTargetDbColumnBO((List)new ArrayList<ExternalColumnBO>(){
            {
                this.add(new ExternalColumnBO(){
                    {
                        this.setColumnName("count_date");
                    }
                });
                this.add(new ExternalColumnBO(){
                    {
                        this.setColumnName("database_table");
                    }
                });
                this.add(new ExternalColumnBO(){
                    {
                        this.setColumnName("task_id");
                    }
                });
                this.add(new ExternalColumnBO(){
                    {
                        this.setColumnName("example_id");
                    }
                });
                this.add(new ExternalColumnBO(){
                    {
                        this.setColumnName("exec_date");
                    }
                });
                this.add(new ExternalColumnBO(){
                    {
                        this.setColumnName("exec_result");
                    }
                });
            }
        });
        odpsSqlFileBO.setFileContent(this.swapGetDataWorksJsonConfService.getDataWorksJson(resultBO));
        reateImportFileBO.add(odpsSqlFileBO);
        CreateImportFileRspBO createImportFileRspBO = new CreateImportFileRspBO();
        createImportFileRspBO.setReateImportFileBO(reateImportFileBO);
        createImportFileRspBO.setTableName(reqBO.getTaskId());
        createImportFileRspBO.setTaskId(reqBO.getTaskId());
        createImportFileRspBO.setBizType("sync");
        createImportFileRspBOList.add(createImportFileRspBO);
    }

    private void validateParam(DataShareSubscribeReqBO reqBO) {
        Date date = new Date();
        if (StringUtils.isEmpty((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1ID\u3010taskId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTaskName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1\u540d\u79f0\u3010taskName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSwapFreq())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u540c\u6b65\u9891\u7387\u3010swapFreq\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getEffDate() == null || "".equalsIgnoreCase(reqBO.getEffDate())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1\u751f\u6548\u65f6\u95f4\u3010effDate\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getExpDate() == null || "".equalsIgnoreCase(reqBO.getExpDate())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1\u5931\u6548\u65f6\u95f4\u3010expDate\u3011\u4e3a\u7a7a");
        }
        if (DataShareSubscribeServiceImpl.strToDate(reqBO.getExpDate(), "yyyy-MM-dd HH:mm:ss").getTime() - DataShareSubscribeServiceImpl.strToDate(reqBO.getEffDate(), "yyyy-MM-dd HH:mm:ss").getTime() < 0L) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1\u5931\u6548\u65f6\u95f4\u3010expDate\u3011\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4");
        }
        if (null == reqBO.getSourceDataSourceInfo()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u6e90\u4fe1\u606f\u3010sourceDataSourceInfo\u3011\u4e3a\u7a7a");
        }
        if (null == reqBO.getTargetDataSourceInfo()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u6e90\u4fe1\u606f\u3010sourceDataSourceInfo\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u6e90ID\u3010dbDatabaseCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbDeptCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u90e8\u95e8ID\u3010dbDeptCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbDeptName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u90e8\u95e8\u540d\u79f0\u3010dbDeptName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u7c7b\u578b\u3010dbType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbJDBCUrl())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u7684JDBC\u5730\u5740\u3010dbJDBCUrl\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbUserName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u7684\u7528\u6237\u540d\u3010dbUserName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDataSourceInfo().getDbPasswd())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u7684\u5bc6\u7801\u3010dbPasswd\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDbTableName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u7684\u8868\u540d\u3010sourceDbTableName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceDbQuerySql())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getSourceDbColumnBo())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4fe1\u606f\u3010sourceDbColumnBo\u3011\u4e3a\u7a7a");
            }
            for (ExternalColumnBO columnBO : reqBO.getSourceDbColumnBo()) {
                if (StringUtils.isEmpty((String)columnBO.getColumnName())) {
                    throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u8868\u5b57\u6bb5\u540d\u79f0\u3010ColumnName\u3011\u4e3a\u7a7a");
                }
                if (!"HIVE".equals(reqBO.getSourceDataSourceInfo().getDbType()) || !StringUtils.isEmpty((String)columnBO.getDataType())) continue;
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u8868\u6570\u636e\u7c7b\u578b\u3010DataType\u3011\u4e3a\u7a7a");
            }
        }
        if (!StringUtils.isEmpty((String)reqBO.getSourceDbSplitPk())) {
            // empty if block
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u6e90ID\u3010dbDatabaseCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbDeptCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u90e8\u95e8ID\u3010dbDeptCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbDeptName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u90e8\u95e8\u540d\u79f0\u3010dbDeptName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7c7b\u578b\u3010dbType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbJDBCUrl())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7684JDBC\u5730\u5740\u3010dbJDBCUrl\u3011\u4e3a\u7a7a");
        }
        if ("MASKINGPOLICY".equals(reqBO.getSourceDataSourceInfo().getUserPasswdGetSource())) {
            if (null == reqBO.getSourceDataSourceInfo().getSourceCode()) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6765\u6e90\u7f16\u7801\u3010sourceCode\u3011\u4e3a\u7a7a");
            }
        } else {
            if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbUserName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7684\u7528\u6237\u540d\u3010dbUserName\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)reqBO.getTargetDataSourceInfo().getDbPasswd())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7684\u5bc6\u7801\u3010dbPasswd\u3011\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDbTableName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7684\u8868\u540d\u3010targetDbTableName\u3011\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTargetDbColumnBO())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4fe1\u606f\u3010targetDbColumnBO\u3011\u4e3a\u7a7a");
        }
        for (ExternalColumnBO columnBO : reqBO.getTargetDbColumnBO()) {
            if (StringUtils.isEmpty((String)columnBO.getColumnName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u8868\u5b57\u6bb5\u540d\u79f0\u3010ColumnName\u3011\u4e3a\u7a7a");
            }
            if (!"HIVE".equals(reqBO.getTargetDataSourceInfo().getDbType()) || !StringUtils.isEmpty((String)columnBO.getDataType())) continue;
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u8868\u6570\u636e\u7c7b\u578b\u3010DataType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperSource())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u6765\u6e90\u3010operSource\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperId())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u4eba\u5458ID\u3010operId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u5458\u59d3\u540d\u3010operName\u3011\u4e3a\u7a7a");
        }
    }

    private void getInsertSwapResultJson(DataShareSubscribeReqBO reqBO) {
        String result = "{\n\t\"type\":\"job\",\n\t\"version\":\"2.0\",\n\t\"steps\":[\n\t\t{\n\t\t\t\"stepType\":\"mysql\",\n\t\t\t\"parameter\":{\n\t\t\t\t\"envType\":1,\n\t\t\t\t\"datasource\":\"dataswap\",\n\t\t\t\t\"column\":[],\n\t\t\t\t\"connection\":[\n\t\t\t\t\t{\n\t\t\t\t\t\t\"querySql\":[\n\t\t\t\t\t\t\t\"select '${bdp.system.bizdate}','" + reqBO.getSourceDbTableName() + "','" + reqBO.getTaskId() + "','$taskid','${execdate}','\u6210\u529f' from " + reqBO.getSourceDbTableName() + " limit 1\"\n\t\t\t\t\t\t],\n\t\t\t\t\t\t\"datasource\":\"dataswap\"\n\t\t\t\t\t\t\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"encoding\":\"UTF-8\"\n\t\t\t},\n\t\t\t\"name\":\"Reader\",\n\t\t\t\"category\":\"reader\"\n\t\t},\n\t\t{\n\t\t\t\"stepType\":\"mysql\",\n\t\t\t\"parameter\":{\n\t\t\t\t\"postSql\":[],\n\t\t\t\t\"datasource\":\"cs_dataswap\",\n\t\t\t\t\"column\":[\n\t\t\t\t\t\"count_date\",\n                    \"database_table\",\n                    \"task_id\",\n                    \"example_id\",\n                    \"exec_date\",\n                    \"exec_result\"\n\t\t\t\t],\n\t\t\t\t\"writeMode\":\"insert\",\n\t\t\t\t\"batchSize\":1024,\n\t\t\t\t\"encoding\":\"UTF-8\",\n\t\t\t\t\"table\":\"swap_data_detail\",\n\t\t\t\t\"preSql\":[]\n\t\t\t},\n\t\t\t\"name\":\"Writer\",\n\t\t\t\"category\":\"writer\"\n\t\t}\n\t],\n\t\"setting\":{\n\t\t\"errorLimit\":{\n\t\t\t\"record\":\"0\"\n\t\t},\n\t\t\"speed\":{\n\t\t\t\"throttle\":false,\n\t\t\t\"concurrent\":1\n\t\t}\n\t},\n\t\"order\":{\n\t\t\"hops\":[\n\t\t\t{\n\t\t\t\t\"from\":\"Reader\",\n\t\t\t\t\"to\":\"Writer\"\n\t\t\t}\n\t\t]\n\t}\n}";
    }

    public static Date strToDate(String strDate, String pattern) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static String getRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }
}

