/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.bo.SwapInsertTaskInfoReqBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.SwapLinkdbReqBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableInfoListBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapInsertTableColInfoService;
import com.yqsmartcity.data.swap.api.service.SwapInsertTaskInfoService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TableResourceInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TableResourceInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapInsertTaskInfoServiceImpl
implements SwapInsertTaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapInsertTaskInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapInsertTaskInfoServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private TableResourceInfoDao tableResourceInfoDao;
    @Autowired
    private SwapInsertTableColInfoService swapInsertTableColInfoService;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    @Transactional(rollbackFor={Exception.class})
    public void insertTaskInfo(SwapInsertTaskInfoReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        if (null != reqBO.getResourceId()) {
            TableResourceInfoPO tableResourceInfoPO1 = new TableResourceInfoPO();
            tableResourceInfoPO1.setResourceId(reqBO.getResourceId());
            tableResourceInfoPO1.setStatus("1");
            TableResourceInfoPO tableResourceInfoPO2 = this.tableResourceInfoDao.getModelBy(tableResourceInfoPO1);
            if (tableResourceInfoPO2 != null) {
                throw new ZTBusinessException("\u8be5\u8868\u5df2\u7ecf\u5efa\u7acb\u4e86\u4ea4\u6362\u4efb\u52a1\uff01");
            }
        }
        TaskInfoPO taskInfoPO2 = new TaskInfoPO();
        taskInfoPO2.setTaskName(reqBO.getTaskName());
        taskInfoPO2.setStatus("1");
        TaskInfoPO taskInfoPO1 = this.taskInfoDao.getModelBy(taskInfoPO2);
        if (null != taskInfoPO1) {
            throw new ZTBusinessException("\u8be5\u4efb\u52a1\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5efa\u7acb\uff01");
        }
        TaskInfoPO taskInfoPO = new TaskInfoPO();
        DatabaseInfoPO qryDatabaseInfoPO = new DatabaseInfoPO();
        qryDatabaseInfoPO.setDatabaseCode(reqBO.getDatabaseCode());
        DatabaseInfoPO databaseInfoPO = this.databaseInfoDao.getModelBy(qryDatabaseInfoPO);
        if (null == databaseInfoPO || StringUtils.isEmpty((String)databaseInfoPO.getDeptCode())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u90e8\u95e8\u7f16\u7801!");
        }
        String str = SwapInsertTaskInfoServiceImpl.getRandom(7);
        taskInfoPO.setTaskId(databaseInfoPO.getDeptCode() + "_" + str);
        taskInfoPO.setTaskName(reqBO.getTaskName());
        taskInfoPO.setTaskDesc(reqBO.getTaskDesc());
        taskInfoPO.setTaskBigType(reqBO.getTaskBigType());
        taskInfoPO.setTaskSubType(reqBO.getTaskSubType());
        taskInfoPO.setSwapCycle(reqBO.getSwapCycle());
        taskInfoPO.setNeedDesc(reqBO.getNeedDesc());
        taskInfoPO.setConfigState(reqBO.getConfigState());
        taskInfoPO.setCreateTime(new Date());
        taskInfoPO.setUpdateTime(new Date());
        taskInfoPO.setStatus("1");
        if (null != reqBO.getUserId()) {
            taskInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        taskInfoPO.setOperName(reqBO.getName());
        int taskInfoResult = this.taskInfoDao.insert(taskInfoPO);
        if (taskInfoResult < 1) {
            throw new ZTBusinessException("\u4ea4\u6362\u4efb\u52a1\u65b0\u589e\u5931\u8d25");
        }
        TableInfoPO tableInfoPO = new TableInfoPO();
        String strTable = SwapInsertTaskInfoServiceImpl.getRandom(7);
        tableInfoPO.setDatabaseTableId(reqBO.getDatabaseCode() + strTable);
        tableInfoPO.setTaskId(taskInfoPO.getTaskId());
        tableInfoPO.setDatabaseCode(reqBO.getDatabaseCode());
        tableInfoPO.setSourceTable(reqBO.getSourceTable());
        tableInfoPO.setDatabaseTable(reqBO.getDatabaseTable());
        tableInfoPO.setConfigState(reqBO.getConfigState());
        tableInfoPO.setCreateTime(new Date());
        tableInfoPO.setUpdateTime(new Date());
        tableInfoPO.setStatus("1");
        tableInfoPO.setSwapMode(reqBO.getSwapMode());
        tableInfoPO.setQueryWhere(reqBO.getQueryWhere());
        tableInfoPO.setPartionMode(reqBO.getPartionMode());
        tableInfoPO.setPartionWhere(reqBO.getPartionWhere());
        tableInfoPO.setLifeCycle(this.getSysPara(reqBO.getLifeCycle(), "TABLE_LIFE_CYCLE_TYPE"));
        tableInfoPO.setTargetDatabaseCode(reqBO.getTargetDatabaseCode());
        int tableInfoResult = this.tableInfoDao.insert(tableInfoPO);
        if (tableInfoResult < 1) {
            throw new ZTBusinessException("\u8868\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
        if (null != reqBO.getResourceId()) {
            TableResourceInfoPO tableResourceInfoPO = new TableResourceInfoPO();
            tableResourceInfoPO.setDatabaseTableId(tableInfoPO.getDatabaseTableId());
            tableResourceInfoPO.setResourceId(reqBO.getResourceId());
            tableResourceInfoPO.setCreateTime(new Date());
            tableResourceInfoPO.setUpdateTime(new Date());
            tableResourceInfoPO.setStatus("1");
            tableResourceInfoPO.setConfigState(reqBO.getConfigState());
            int result = this.tableResourceInfoDao.insert(tableResourceInfoPO);
            if (result < 1) {
                throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
        SwapLinkdbReqBO reqLinkBO = new SwapLinkdbReqBO();
        ArrayList<String> tableName = new ArrayList<String>();
        tableName.add(reqBO.getDatabaseTable());
        reqLinkBO.setDatabaseTable(tableName);
        reqLinkBO.setQryTableFlag("col");
        TableInfoListBO tableInfoListBO = this.swapInsertTableColInfoService.insertTableColInfo(reqLinkBO);
        if (tableInfoListBO == null || tableInfoListBO.getTableName().size() == 0) {
            throw new ZTBusinessException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5\u6570\u636e\u6e90\u7684\u914d\u7f6e");
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("A");
        swapInsertOperLogReqBO.setOperContent("\u65b0\u589e:" + reqBO.getTaskName() + "\u4ea4\u6362\u4efb\u52a1");
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapInsertTaskInfoReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getTaskName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1\u540d\u79f0\u3010TaskName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u6e90\u3010DatabaseCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u8868\u3010sourceTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u8868\u3010databaseTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSwapCycle())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8c03\u5ea6\u5468\u671f\u3010swapCycle\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getConfigState())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u914d\u7f6e\u72b6\u6001\u3010configState\u3011\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }

    public static String getRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

