/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.TaskPublishFileBO;
import com.yqsmartcity.data.swap.api.taskpublish.bo.QryPublishFileReqBO;
import com.yqsmartcity.data.swap.api.taskpublish.service.SwapQryPublishFileService;
import com.yqsmartcity.data.swap.dao.TaskPublishFileMapper;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.po.TaskPublishPO;
import com.yqsmartcity.data.swap.service.busi.impl.dataworks.FileZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SwapQryPublishFileServiceImpl
implements SwapQryPublishFileService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryPublishFileServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapQryPublishFileServiceImpl.class);
    @Autowired
    private TaskPublishFileMapper taskPublishFileMapper;
    @Autowired
    private TaskPublishMapper taskPublishMapper;

    public ScriptDownloadRspBO qryPublishFile(QryPublishFileReqBO reqBO) throws ZTBusinessException {
        logger.info("---------------------call publishOozie");
        this.validateParam(reqBO);
        ScriptDownloadRspBO scriptDownloadRspBO = new ScriptDownloadRspBO();
        ArrayList<CreateImportFileRspBO> createImportFileRspBOList = new ArrayList<CreateImportFileRspBO>();
        for (String taskId : reqBO.getTaskIdList()) {
            List<TaskPublishFileBO> taskPublishFileBOList = this.taskPublishFileMapper.getFileLIstByTaskId(taskId);
            CreateImportFileRspBO createImportFileRspBO = new CreateImportFileRspBO();
            createImportFileRspBO.setTableName(taskId);
            createImportFileRspBO.setZipName(taskId);
            ArrayList reateImportFileBO = new ArrayList();
            taskPublishFileBOList.forEach(e -> {
                CreateImportFileBO createImportFileBO = new CreateImportFileBO();
                BeanUtils.copyProperties((Object)e, (Object)createImportFileBO);
                createImportFileBO.setFileContent(new StringBuffer(e.getFileContent()));
                reateImportFileBO.add(createImportFileBO);
            });
            createImportFileRspBO.setReateImportFileBO(reateImportFileBO);
            createImportFileRspBOList.add(createImportFileRspBO);
            TaskPublishPO taskPublishPO = new TaskPublishPO();
            taskPublishPO.setUnid(taskPublishFileBOList.get(0).getUnid());
            taskPublishPO.setStatus("2");
            if (null != reqBO.getUserId()) {
                taskPublishPO.setPublishOperId(String.valueOf(reqBO.getUserId()));
            }
            taskPublishPO.setPublishOperName(reqBO.getName());
            this.taskPublishMapper.updateByPrimaryKeySelective(taskPublishPO);
        }
        scriptDownloadRspBO.setCreateImportFileRspBOList(createImportFileRspBOList);
        return scriptDownloadRspBO;
    }

    private static String zipFile(String filePath) throws ZTBusinessException {
        File zipFile = new File(filePath + ".zip");
        try {
            FileOutputStream fos1 = new FileOutputStream(zipFile);
            FileZipUtil.toZip(new File(filePath), fos1, false);
        }
        catch (FileNotFoundException e) {
            throw new ZTBusinessException(e.getLocalizedMessage());
        }
        return zipFile.getName();
    }

    private void validateParam(QryPublishFileReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTaskIdList())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u540d\u5217\u8868\u3010taskIdList\u3011\u4e3a\u7a7a");
        }
    }
}

