/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.bo.SwapQryTaskListReqBO;
import com.yqsmartcity.data.swap.api.bo.SwapQryTaskListRspBO;
import com.yqsmartcity.data.swap.api.bo.TaskInfoBO;
import com.yqsmartcity.data.swap.api.service.SwapQryTaskListService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapQryTaskListServiceImpl
implements SwapQryTaskListService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryTaskListServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;

    @Transactional(rollbackFor={Exception.class})
    public SwapQryTaskListRspBO qryTaskList(SwapQryTaskListReqBO reqBO) throws ZTBusinessException {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SwapQryTaskListRspBO rspBO = new SwapQryTaskListRspBO();
        reqBO.setTaskName(SwapQryTaskListServiceImpl.queryString(reqBO.getTaskName()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)reqBO.getUpdateTime())) {
            String[] updateTimeList = reqBO.getUpdateTime().split("~");
            String updateTimeStart = updateTimeList[0].trim();
            String updateTimeEnd = updateTimeList[1].trim();
            try {
                Date updateStart = sdf.parse(updateTimeStart);
                Date updateEnd = sdf.parse(updateTimeEnd);
                reqBO.setUpdateStart(updateStart);
                reqBO.setUpdateEnd(updateEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        reqBO.setStatus("1");
        List<TaskInfoBO> taskInfoBOList = this.tableInfoDao.getTaskListPage((Page<TaskInfoBO>)page, reqBO);
        rspBO.setRows(taskInfoBOList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public static String queryString(String temp) {
        if (temp == null || temp == "") {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(temp.trim());
        StringBuilder tempBuilder = new StringBuilder();
        tempBuilder.append(temp.trim());
        int j = 0;
        for (int i = 0; i < b.length(); ++i) {
            char x = b.charAt(i);
            if (x != '%' && x != '_') continue;
            tempBuilder.insert(i + j, '\\');
            ++j;
        }
        return tempBuilder.toString();
    }
}

