/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.bo.SwapUpdateTaskInfoReqBO;
import com.yqsmartcity.data.swap.api.bo.TaskInfoBO;
import com.yqsmartcity.data.swap.api.service.SwapUpdateTaskInfoService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoLogDao;
import com.yqsmartcity.data.swap.dao.TableResourceInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoLogDao;
import com.yqsmartcity.data.swap.po.TableInfoLogPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TableResourceInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoLogPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateTaskInfoServiceImpl
implements SwapUpdateTaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateTaskInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapUpdateTaskInfoServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TableInfoLogDao tableInfoLogDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TaskInfoLogDao taskInfoLogDao;
    @Autowired
    private TableResourceInfoDao tableResourceInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskInfoService(SwapUpdateTaskInfoReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TaskInfoBO taskInfoBO = this.tableInfoDao.getTaskInfo(reqBO.getUnid());
        if (null == taskInfoBO) {
            throw new ZTBusinessException("\u672a\u67e5\u5230\u8be5\u6761\u4ea4\u6362\u4efb\u52a1\u6570\u636e");
        }
        TaskInfoPO taskInfoPO = this.taskInfoDao.getModelById(taskInfoBO.getUnid());
        TaskInfoLogPO taskInfoLogPO = new TaskInfoLogPO();
        BeanUtils.copyProperties((Object)taskInfoPO, (Object)taskInfoLogPO);
        taskInfoLogPO.setOperDate(new Date());
        taskInfoLogPO.setUnid(null);
        this.taskInfoLogDao.insert(taskInfoLogPO);
        TaskInfoPO updateTaskInfoPO = new TaskInfoPO();
        updateTaskInfoPO.setUnid(reqBO.getUnid());
        updateTaskInfoPO.setTaskId(taskInfoPO.getTaskId());
        updateTaskInfoPO.setTaskName(reqBO.getTaskName());
        updateTaskInfoPO.setTaskDesc(reqBO.getTaskDesc());
        updateTaskInfoPO.setSwapCycle(reqBO.getSwapCycle());
        updateTaskInfoPO.setNeedDesc(reqBO.getNeedDesc());
        updateTaskInfoPO.setConfigState(reqBO.getConfigState());
        updateTaskInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            updateTaskInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        updateTaskInfoPO.setOperName(reqBO.getName());
        int resultUpdateTaskInfo = this.taskInfoDao.updateById(updateTaskInfoPO);
        if (resultUpdateTaskInfo < 1) {
            throw new ZTBusinessException("\u7f16\u8f91\u4ea4\u6362\u4efb\u52a1\u5931\u8d25");
        }
        TableInfoPO tableInfoPO = this.tableInfoDao.getModelById(taskInfoBO.getUnidTable());
        TableInfoLogPO tableInfoLogPO = new TableInfoLogPO();
        BeanUtils.copyProperties((Object)tableInfoPO, (Object)tableInfoLogPO);
        tableInfoLogPO.setOperDate(new Date());
        tableInfoLogPO.setUnid(null);
        this.tableInfoLogDao.insert(tableInfoLogPO);
        TableInfoPO updateTableInfoPO = new TableInfoPO();
        updateTableInfoPO.setUnid(tableInfoPO.getUnid());
        updateTableInfoPO.setDatabaseCode(reqBO.getDatabaseCode());
        updateTableInfoPO.setSourceTable(reqBO.getSourceTable());
        updateTableInfoPO.setDatabaseTable(reqBO.getDatabaseTable());
        updateTableInfoPO.setConfigState(reqBO.getConfigState());
        updateTableInfoPO.setSwapMode(reqBO.getSwapMode());
        updateTableInfoPO.setQueryWhere(reqBO.getQueryWhere());
        updateTableInfoPO.setPartionMode(reqBO.getPartionMode());
        updateTableInfoPO.setPartionWhere(reqBO.getPartionWhere());
        updateTableInfoPO.setLifeCycle(this.getSysPara(reqBO.getLifeCycle(), "TABLE_LIFE_CYCLE_TYPE"));
        updateTableInfoPO.setUpdateTime(new Date());
        int reslt = this.tableInfoDao.updateById(updateTableInfoPO);
        if (reslt < 1) {
            throw new ZTBusinessException("\u7f16\u8f91\u5931\u8d25");
        }
        TableResourceInfoPO queryPO = new TableResourceInfoPO();
        queryPO.setDatabaseTableId(tableInfoPO.getDatabaseTableId());
        queryPO.setStatus("1");
        TableResourceInfoPO tableResourceInfoPO = this.tableResourceInfoDao.getModelBy(queryPO);
        if (null != tableResourceInfoPO) {
            if (reqBO.getResourceId() != null && !tableResourceInfoPO.getResourceId().equals(reqBO.getResourceId())) {
                tableResourceInfoPO.setResourceId(reqBO.getResourceId());
            }
            tableResourceInfoPO.setConfigState(reqBO.getConfigState());
            tableResourceInfoPO.setUpdateTime(new Date());
            int resourceUpdate = this.tableResourceInfoDao.updateById(tableResourceInfoPO);
            if (resourceUpdate < 1) {
                throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25!");
            }
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("M");
        swapInsertOperLogReqBO.setOperContent("\u7f16\u8f91:" + reqBO.getTaskName() + "\u4ea4\u6362\u4efb\u52a1");
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapUpdateTaskInfoReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010unid\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTaskName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1\u540d\u79f0\u3010TaskName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u6e90\u3010DatabaseCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u8868\u3010sourceTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u8868\u3010databaseTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSwapCycle())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8c03\u5ea6\u5468\u671f\u3010swapCycle\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getConfigState())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u914d\u7f6e\u72b6\u6001\u3010configState\u3011\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

