/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.bo.SwapUpdateTaskStatusReqBO;
import com.yqsmartcity.data.swap.api.service.SwapUpdateTaskStatusService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TableResourceInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TableResourceInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateTaskStatusServiceImpl
implements SwapUpdateTaskStatusService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateTaskStatusServiceImpl.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TableResourceInfoDao tableResourceInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskStatus(SwapUpdateTaskStatusReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TaskInfoPO taskInfoPO = this.taskInfoDao.getModelById(reqBO.getUnid());
        if (null == taskInfoPO) {
            throw new ZTBusinessException("\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if ("0".equals(taskInfoPO.getStatus())) {
            throw new ZTBusinessException("\u8be5\u6761\u6570\u636e\u5f53\u524d\u72b6\u6001\u5df2\u7ecf\u662f\u5931\u6548\u72b6\u6001\uff01");
        }
        if ("1".equals(taskInfoPO.getConfigState())) {
            throw new ZTBusinessException("\u8be5\u6761\u6570\u636e\u662f\u5df2\u914d\u7f6e\u72b6\u6001\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        TableInfoPO tableInfoPO2 = new TableInfoPO();
        tableInfoPO2.setTaskId(taskInfoPO.getTaskId());
        TableInfoPO tableInfoPO3 = this.tableInfoDao.getModelBy(tableInfoPO2);
        if (null == tableInfoPO3) {
            throw new ZTBusinessException("\u8be5\u6761\u6570\u636e\u8868\u4e0d\u5b58\u5728\uff01");
        }
        TaskInfoPO updateTaskInfoPO = new TaskInfoPO();
        updateTaskInfoPO.setUnid(reqBO.getUnid());
        updateTaskInfoPO.setStatus("0");
        updateTaskInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            updateTaskInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        updateTaskInfoPO.setOperName(reqBO.getName());
        int updateResult = this.taskInfoDao.updateById(updateTaskInfoPO);
        if (updateResult < 1) {
            throw new ZTBusinessException("\u8c03\u7528\u5931\u8d25!");
        }
        TableInfoPO tableInfoPO = new TableInfoPO();
        tableInfoPO.setTaskId(taskInfoPO.getTaskId());
        TableInfoPO tableInfoPO1 = this.tableInfoDao.getModelBy(tableInfoPO);
        tableInfoPO1.setStatus("0");
        int result = this.tableInfoDao.updateById(tableInfoPO1);
        if (result < 1) {
            throw new ZTBusinessException("\u8c03\u7528\u5931\u8d25!");
        }
        TableResourceInfoPO qryTableResourceInfoPO = new TableResourceInfoPO();
        qryTableResourceInfoPO.setDatabaseTableId(tableInfoPO3.getDatabaseTableId());
        qryTableResourceInfoPO.setStatus("1");
        TableResourceInfoPO tableResourceInfoPO = this.tableResourceInfoDao.getModelBy(qryTableResourceInfoPO);
        if (tableResourceInfoPO != null) {
            tableResourceInfoPO.setStatus("0");
            tableResourceInfoPO.setUpdateTime(new Date());
            int relationResult = this.tableResourceInfoDao.updateById(tableResourceInfoPO);
            if (relationResult < 1) {
                throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25!");
            }
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("D");
        swapInsertOperLogReqBO.setOperContent("\u5220\u9664:" + taskInfoPO.getTaskName() + "\u4ea4\u6362\u4efb\u52a1");
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapUpdateTaskStatusReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u4ea4\u6362\u4efb\u52a1\u4fe1\u606f\u505c\u7528\u670d\u52a1\u5165\u53c2\u53c2\u6570[Unid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }
}

