/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.taskpublish;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.taskpublish.bo.FileInfoBO;
import com.yqsmartcity.data.swap.api.taskpublish.bo.SwapQryTaskPublishListReqBO;
import com.yqsmartcity.data.swap.api.taskpublish.bo.SwapQryTaskPublishListRspBO;
import com.yqsmartcity.data.swap.api.taskpublish.bo.TaskPublishBO;
import com.yqsmartcity.data.swap.api.taskpublish.service.SwapQryTaskPublishListService;
import com.yqsmartcity.data.swap.dao.TaskPublishFileMapper;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.po.TaskPublishFilePO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwapQryTaskPublishListServiceImpl
implements SwapQryTaskPublishListService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryTaskPublishListServiceImpl.class);
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskPublishFileMapper taskPublishFileMapper;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    public SwapQryTaskPublishListRspBO qryTaskPublishList(SwapQryTaskPublishListReqBO reqBO) throws ZTBusinessException {
        List<TaskPublishBO> taskPublishBOList;
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        SwapQryTaskPublishListRspBO rspBO = new SwapQryTaskPublishListRspBO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)reqBO.getCreateTime())) {
            String[] createTimeList = reqBO.getCreateTime().split("~");
            String createTimeStart = createTimeList[0].trim();
            String createTimeEnd = createTimeList[1].trim();
            try {
                Date createStart = sdf.parse(createTimeStart);
                Date createEnd = sdf.parse(createTimeEnd);
                reqBO.setCreateTimeStart(createStart);
                reqBO.setCreateTimeEnd(createEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((String)reqBO.getPublishTime())) {
            String[] publishTimeList = reqBO.getPublishTime().split("~");
            String publishTimeStart = publishTimeList[0].trim();
            String publishTimeEnd = publishTimeList[1].trim();
            try {
                Date publishStart = sdf.parse(publishTimeStart);
                Date publishEnd = sdf.parse(publishTimeEnd);
                reqBO.setPublishTimeStart(publishStart);
                reqBO.setPublishTimeEnd(publishEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((taskPublishBOList = this.taskPublishMapper.getTaskPublishListPage(reqBO, page)) != null && taskPublishBOList.size() > 0) {
            for (TaskPublishBO value : taskPublishBOList) {
                TaskPublishFilePO taskPublishFilePO = new TaskPublishFilePO();
                taskPublishFilePO.setPublishId(value.getUnid().toString());
                List<FileInfoBO> fileInfoBOList = this.taskPublishFileMapper.getFileLIst(taskPublishFilePO);
                value.setFileInfoBOList(fileInfoBOList);
                if (!StringUtils.isEmpty((String)value.getStatus())) {
                    value.setNodeTypeDesc(this.getSysPara(value.getStatus(), "TASK_PUBLISH_STATUS"));
                }
                if (!StringUtils.isEmpty((String)value.getNodeType())) {
                    value.setNodeTypeDesc(this.getSysPara(value.getNodeType(), "FLOW_NODE_TYPE"));
                }
                if (StringUtils.isEmpty((String)value.getModifyType())) continue;
                value.setModifyTypeDesc(this.getSysPara(value.getModifyType(), "FLOW_MODIFY_TYPE"));
            }
        }
        rspBO.setRows(taskPublishBOList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

