/*
 * Decompiled with CFR 0.152.
 */
package com.pflm.modules.job.utils;

import com.google.gson.Gson;
import com.pflm.modules.job.entity.ScheduleJobEntity;
import com.pflm.modules.job.entity.ScheduleJobLogEntity;
import com.pflm.modules.job.service.ScheduleJobLogService;
import com.pflm.modules.job.utils.ScheduleRunnable;
import com.pflm.modules.job.utils.SpringContextUtils;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ScheduleJob
extends QuartzJobBean {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ExecutorService service = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        String jsonJob = context.getMergedJobDataMap().getString("JOB_PARAM_KEY");
        ScheduleJobEntity scheduleJob = (ScheduleJobEntity)new Gson().fromJson(jsonJob, ScheduleJobEntity.class);
        ScheduleJobLogService scheduleJobLogService = (ScheduleJobLogService)SpringContextUtils.getBean("scheduleJobLogService");
        ScheduleJobLogEntity log = new ScheduleJobLogEntity();
        log.setJobId(scheduleJob.getJobId());
        log.setBeanName(scheduleJob.getBeanName());
        log.setMethodName(scheduleJob.getMethodName());
        log.setParams(scheduleJob.getParams());
        log.setCreateTime(new Date());
        long startTime = System.currentTimeMillis();
        try {
            this.logger.info("\u4efb\u52a1\u51c6\u5907\u6267\u884c\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getJobId());
            ScheduleRunnable task = new ScheduleRunnable(scheduleJob.getBeanName(), scheduleJob.getMethodName(), scheduleJob.getParams());
            Future<?> future = this.service.submit(task);
            future.get();
            long times = System.currentTimeMillis() - startTime;
            log.setTimes((int)times);
            log.setStatus(0);
            this.logger.info("\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getJobId() + "  \u603b\u5171\u8017\u65f6\uff1a" + times + "\u6beb\u79d2");
        }
        catch (Exception e) {
            this.logger.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getJobId(), (Throwable)e);
            long times = System.currentTimeMillis() - startTime;
            log.setTimes((int)times);
            log.setStatus(1);
            log.setError(StringUtils.substring((String)e.toString(), (int)0, (int)2000));
        }
        finally {
            scheduleJobLogService.save(log);
        }
    }
}

