/*
 * Decompiled with CFR 0.152.
 */
package com.pflm.modules.job.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pflm.common.constant.Constant;
import com.pflm.modules.job.dao.ScheduleJobMapper;
import com.pflm.modules.job.entity.ScheduleJobEntity;
import com.pflm.modules.job.service.ScheduleJobService;
import com.pflm.modules.job.utils.ScheduleUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scheduleJobService")
public class ScheduleJobServiceImpl
extends ServiceImpl<ScheduleJobMapper, ScheduleJobEntity>
implements ScheduleJobService {
    @Autowired
    private ScheduleJobMapper scheduleJobMapper;
    @Autowired
    private Scheduler scheduler;

    @PostConstruct
    public void init() {
        this.scheduleJobMapper.selectList(null);
        List scheduleJobList = this.scheduleJobMapper.selectList(null);
        for (ScheduleJobEntity scheduleJob : scheduleJobList) {
            CronTrigger cronTrigger = ScheduleUtils.getCronTrigger(this.scheduler, scheduleJob.getJobId());
            if (cronTrigger == null) {
                ScheduleUtils.createScheduleJob(this.scheduler, scheduleJob);
                continue;
            }
            ScheduleUtils.updateScheduleJob(this.scheduler, scheduleJob);
        }
    }

    @Override
    public List<ScheduleJobEntity> queryList(Map<String, Object> map) {
        return this.scheduleJobMapper.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return this.scheduleJobMapper.queryTotal(map);
    }

    @Override
    @Transactional
    public boolean saveScheduleJob(ScheduleJobEntity scheduleJob) {
        boolean successFlag;
        ScheduleJobEntity scheduleJobEntity = this.scheduleJobMapper.queryByParams(scheduleJob.getParams());
        if (scheduleJobEntity == null) {
            successFlag = this.save(scheduleJob);
            if (successFlag) {
                CronTrigger cronTrigger = ScheduleUtils.getCronTrigger(this.scheduler, scheduleJob.getJobId());
                if (cronTrigger == null) {
                    ScheduleUtils.createScheduleJob(this.scheduler, scheduleJob);
                } else {
                    ScheduleUtils.updateScheduleJob(this.scheduler, scheduleJob);
                }
            }
        } else {
            scheduleJob.setJobId(scheduleJobEntity.getJobId());
            successFlag = this.updateById(scheduleJob);
            if (successFlag) {
                CronTrigger cronTrigger = ScheduleUtils.getCronTrigger(this.scheduler, scheduleJob.getJobId());
                if (cronTrigger == null) {
                    ScheduleUtils.createScheduleJob(this.scheduler, scheduleJob);
                } else {
                    ScheduleUtils.updateScheduleJob(this.scheduler, scheduleJob);
                }
            }
        }
        return successFlag;
    }

    @Override
    public void run(Long jobId) {
        ScheduleUtils.run(this.scheduler, (ScheduleJobEntity)this.scheduleJobMapper.selectById(jobId));
    }

    @Override
    public void pause(Long jobId) {
        ScheduleUtils.pauseJob(this.scheduler, jobId);
        this.scheduleJobMapper.updateStatus(Constant.ScheduleStatus.PAUSE.getValue(), jobId);
    }

    @Override
    public void resume(Long jobId) {
        ScheduleUtils.resumeJob(this.scheduler, jobId);
        this.scheduleJobMapper.updateStatus(Constant.ScheduleStatus.NORMAL.getValue(), jobId);
    }
}

