/*
 * Decompiled with CFR 0.152.
 */
package com.pflm.modules.job.utils;

import com.google.gson.Gson;
import com.pflm.common.constant.Constant;
import com.pflm.common.exception.MyException;
import com.pflm.modules.job.entity.ScheduleJobEntity;
import com.pflm.modules.job.utils.ScheduleJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ScheduleUtils {
    private static final String JOB_NAME = "TASK_";

    private static TriggerKey getTriggerKey(Long jobId) {
        return TriggerKey.triggerKey((String)(JOB_NAME + jobId));
    }

    private static JobKey getJobKey(Long jobId) {
        return JobKey.jobKey((String)(JOB_NAME + jobId));
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, Long jobId) {
        try {
            return (CronTrigger)scheduler.getTrigger(ScheduleUtils.getTriggerKey(jobId));
        }
        catch (SchedulerException e) {
            throw new MyException("getCronTrigger\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5qrtz\u5f00\u5934\u7684\u8868\uff0c\u662f\u5426\u6709\u810f\u6570\u636e", e);
        }
    }

    public static void createScheduleJob(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(ScheduleJob.class).withIdentity(ScheduleUtils.getJobKey(scheduleJob.getJobId())).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getTriggerKey(scheduleJob.getJobId())).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            jobDetail.getJobDataMap().put("JOB_PARAM_KEY", new Gson().toJson((Object)scheduleJob));
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (scheduleJob.getStatus().intValue() == Constant.ScheduleStatus.PAUSE.getValue()) {
                ScheduleUtils.pauseJob(scheduler, scheduleJob.getJobId());
            }
        }
        catch (SchedulerException e) {
            throw new MyException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public static void updateScheduleJob(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey(scheduleJob.getJobId());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = ScheduleUtils.getCronTrigger(scheduler, scheduleJob.getJobId());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            trigger.getJobDataMap().put("JOB_PARAM_KEY", new Gson().toJson((Object)scheduleJob));
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            if (scheduleJob.getStatus().intValue() == Constant.ScheduleStatus.PAUSE.getValue()) {
                ScheduleUtils.pauseJob(scheduler, scheduleJob.getJobId());
            }
        }
        catch (SchedulerException e) {
            throw new MyException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public static void run(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_PARAM_KEY", new Gson().toJson((Object)scheduleJob));
            scheduler.triggerJob(ScheduleUtils.getJobKey(scheduleJob.getJobId()), dataMap);
        }
        catch (SchedulerException e) {
            throw new MyException("\u7acb\u5373\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public static void pauseJob(Scheduler scheduler, Long jobId) {
        try {
            scheduler.pauseJob(ScheduleUtils.getJobKey(jobId));
        }
        catch (SchedulerException e) {
            throw new MyException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public static void resumeJob(Scheduler scheduler, Long jobId) {
        try {
            scheduler.resumeJob(ScheduleUtils.getJobKey(jobId));
        }
        catch (SchedulerException e) {
            throw new MyException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    public static void deleteScheduleJob(Scheduler scheduler, Long jobId) {
        try {
            scheduler.deleteJob(ScheduleUtils.getJobKey(jobId));
        }
        catch (SchedulerException e) {
            throw new MyException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
    }
}

