/*
 * Decompiled with CFR 0.152.
 */
package com.pflm.modules.job.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.pflm.common.utils.PageUtils;
import com.pflm.common.utils.Query;
import com.pflm.common.utils.Res;
import com.pflm.modules.job.entity.ScheduleJobEntity;
import com.pflm.modules.job.service.ScheduleJobService;
import java.util.List;
import java.util.Map;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schedule"})
public class ScheduleJobController {
    @Autowired
    private ScheduleJobService scheduleJobService;
    @Autowired
    private Scheduler scheduler;

    @RequestMapping(value={"/index"})
    public String localhost(ModelMap model) {
        return "schedule/index";
    }

    @RequestMapping(value={"/list"})
    @BusiResponseBody
    public Res list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<ScheduleJobEntity> jobList = this.scheduleJobService.queryList(query);
        int total = this.scheduleJobService.queryTotal(query);
        PageUtils pageUtil = new PageUtils(jobList, total, query.getLimit(), query.getPage());
        System.err.println(jobList.size());
        System.err.println(pageUtil.toString());
        return Res.ok().put("page", (Object)pageUtil);
    }

    @RequestMapping(value={"/info/{jobId}"})
    @BusiResponseBody
    public Res info(@PathVariable(value="jobId") Long jobId) {
        ScheduleJobEntity schedule = (ScheduleJobEntity)this.scheduleJobService.getById(jobId);
        return Res.ok().put("schedule", (Object)schedule);
    }

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    public Res save(@RequestBody ScheduleJobEntity scheduleJob) {
        this.scheduleJobService.saveScheduleJob(scheduleJob);
        return Res.ok();
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Res update(@RequestBody ScheduleJobEntity scheduleJob) {
        this.scheduleJobService.updateById(scheduleJob);
        return Res.ok();
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    public Res delete(Long jobId) {
        this.scheduleJobService.removeById(jobId);
        return Res.ok();
    }

    @RequestMapping(value={"/run"})
    @BusiResponseBody
    public Res run(Long jobId) {
        this.scheduleJobService.run(jobId);
        return Res.ok();
    }

    @RequestMapping(value={"/pause"})
    @BusiResponseBody
    public Res pause(Long jobId) {
        this.scheduleJobService.pause(jobId);
        return Res.ok();
    }

    @RequestMapping(value={"/resume"})
    @BusiResponseBody
    public Res resume(Long jobId) {
        this.scheduleJobService.resume(jobId);
        return Res.ok();
    }
}

