/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.CommdSpecBo;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.DaYaoSelfPropDefValidateAtomService;
import com.tydic.commodity.busibase.atom.bo.PropDefValidateReqBO;
import com.tydic.commodity.busibase.atom.bo.PropDefValidateRspBO;
import com.tydic.commodity.busibase.comb.api.UccCodegenerationCombService;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombRspBO;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccRelPropGrpPropPo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DaYaoSelfPropDefValidateAtomServiceImpl
implements DaYaoSelfPropDefValidateAtomService {
    private static final Logger log = LoggerFactory.getLogger(DaYaoSelfPropDefValidateAtomServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccCodegenerationCombService uccCodegenerationCombService;

    @Override
    public PropDefValidateRspBO selfMaterialPropdefValidate(PropDefValidateReqBO reqBO) {
        List<UccCommodityPropGrpPo> uccCommodityPropGrpPos = this.uccCommodityPropGrpMapper.queryGroupByCommodityTypeId(reqBO.getCommodityTypeId());
        if (!CollectionUtils.isEmpty(uccCommodityPropGrpPos)) {
            UccCommodityPropGrpPo grpPo;
            boolean commodityGrpFlag = false;
            boolean commoditySaleGrpFlag = false;
            boolean commodityFuGrpFlag = false;
            for (UccCommodityPropGrpPo o : uccCommodityPropGrpPos) {
                if (UccConstants.CommodityGrpType.COMMODITY_GRP.equals(o.getCommodityPropGrpType())) {
                    commodityGrpFlag = true;
                    this.validateGrp(UccConstants.CommodityGrpType.COMMODITY_GRP, reqBO, o);
                }
                if (!UccConstants.CommodityGrpType.COMMODITY_FU_GRP.equals(o.getCommodityPropGrpType())) continue;
                commodityFuGrpFlag = true;
                this.validateGrp(UccConstants.CommodityGrpType.COMMODITY_FU_GRP, reqBO, o);
            }
            if (!commodityGrpFlag) {
                grpPo = new UccCommodityPropGrpPo();
                grpPo.setCommodityTypeId(reqBO.getCommodityTypeId());
                grpPo.setCommodityPropGrpId(Sequence.getInstance().nextId());
                grpPo.setCommodityPropGrpCode(this.getCode());
                grpPo.setCommodityPropGrpType(UccConstants.CommodityGrpType.COMMODITY_GRP);
                grpPo.setCommodityPropGrpName("\u5546\u54c1\u4e3b\u5c5e\u6027\u7ec4");
                grpPo.setCreateOperId(reqBO.getUserId().toString());
                grpPo.setCreateTime(new Date());
                this.createGrp(grpPo);
                this.validateGrp(UccConstants.CommodityGrpType.COMMODITY_GRP, reqBO, grpPo);
            }
            if (!commodityFuGrpFlag) {
                grpPo = new UccCommodityPropGrpPo();
                grpPo.setCommodityTypeId(reqBO.getCommodityTypeId());
                grpPo.setCommodityPropGrpId(Sequence.getInstance().nextId());
                grpPo.setCommodityPropGrpCode(this.getCode());
                grpPo.setCommodityPropGrpType(UccConstants.CommodityGrpType.COMMODITY_FU_GRP);
                grpPo.setCommodityPropGrpName("\u5546\u54c1\u9644\u5c5e\u5c5e\u6027\u7ec4");
                grpPo.setCreateOperId(reqBO.getUserId().toString());
                grpPo.setCreateTime(new Date());
                this.createGrp(grpPo);
                this.validateGrp(UccConstants.CommodityGrpType.COMMODITY_FU_GRP, reqBO, grpPo);
            }
        } else {
            UccCommodityPropGrpPo grpPo1 = new UccCommodityPropGrpPo();
            grpPo1.setCommodityTypeId(reqBO.getCommodityTypeId());
            grpPo1.setCommodityPropGrpId(Sequence.getInstance().nextId());
            grpPo1.setCommodityPropGrpCode(this.getCode());
            grpPo1.setCommodityPropGrpType(UccConstants.CommodityGrpType.COMMODITY_GRP);
            grpPo1.setCommodityPropGrpName("\u5546\u54c1\u4e3b\u5c5e\u6027\u7ec4");
            grpPo1.setCreateOperId(reqBO.getUserId().toString());
            grpPo1.setCreateTime(new Date());
            this.createGrp(grpPo1);
            this.validateGrp(UccConstants.CommodityGrpType.COMMODITY_GRP, reqBO, grpPo1);
            grpPo1.setCommodityPropGrpId(Sequence.getInstance().nextId());
            grpPo1.setCommodityPropGrpCode(this.getCode());
            grpPo1.setCommodityPropGrpType(UccConstants.CommodityGrpType.COMMODITY_FU_GRP);
            grpPo1.setCommodityPropGrpName("\u5546\u54c1\u9644\u5c5e\u5c5e\u6027\u7ec4");
            this.createGrp(grpPo1);
            this.validateGrp(UccConstants.CommodityGrpType.COMMODITY_FU_GRP, reqBO, grpPo1);
        }
        PropDefValidateRspBO rspBO = new PropDefValidateRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    private void createGrp(UccCommodityPropGrpPo grpPo) {
        try {
            this.uccCommodityPropGrpMapper.addGroup(grpPo);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5c5e\u6027\u7ec4\u5931\u8d25\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5c5e\u6027\u7ec4\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String getCode() {
        UccCodegenerationCombReqBO codegenerationCombReqBO = new UccCodegenerationCombReqBO();
        codegenerationCombReqBO.setCodeType("09");
        codegenerationCombReqBO.setCount(1);
        log.debug("\u5546\u54c1\u7ec4\u7f16\u7801\u751f\u6210\u5165\u53c2\uff1a" + (Object)((Object)codegenerationCombReqBO));
        UccCodegenerationCombRspBO uccCodegenerationCombRspBO = this.uccCodegenerationCombService.dealUccCodegeneration(codegenerationCombReqBO);
        log.debug("\u5546\u54c1\u7ec4\u7f16\u7801\u751f\u6210\u51fa\u53c2\uff1a" + (Object)((Object)uccCodegenerationCombRspBO));
        if (!"0000".equals(uccCodegenerationCombRspBO.getRespCode()) || CollectionUtils.isEmpty(uccCodegenerationCombRspBO.getCodeList())) {
            throw new BusinessException("8888", "\u5546\u54c1\u7ec4\u7f16\u7801\u751f\u6210\u5931\u8d25\uff1a" + uccCodegenerationCombRspBO.getRespDesc());
        }
        return uccCodegenerationCombRspBO.getCodeList().get(0);
    }

    void validateGrp(Integer commodityGrpType, PropDefValidateReqBO reqBO, UccCommodityPropGrpPo o) {
        List<CommdSpecBo> collect = reqBO.getSpuSpec().stream().filter(e -> commodityGrpType.equals(e.getCommodityPropGrpType())).collect(Collectors.toList());
        collect.forEach(e -> {
            List<UccRelPropGrpPropPo> uccRelPropGrpPropPos = this.uccRelPropGrpPropMapper.selectByDefIdAndGrpId(o.getCommodityPropGrpId(), e.getCommodityPropDefId());
            if (CollectionUtils.isEmpty(uccRelPropGrpPropPos)) {
                UccRelPropGrpPropPo insertPO = new UccRelPropGrpPropPo();
                insertPO.setCommodityPropGrpId(o.getCommodityPropGrpId());
                insertPO.setRelId(Sequence.getInstance().nextId());
                insertPO.setCommodityPropDefId(e.getCommodityPropDefId());
                insertPO.setCreateOperId(reqBO.getUserId().toString());
                insertPO.setCreateTime(new Date());
                insertPO.setShowOrder(0);
                this.addRelPropGrpProp(insertPO);
            }
        });
    }

    private void addRelPropGrpProp(UccRelPropGrpPropPo insertPO) {
        try {
            this.uccRelPropGrpPropMapper.addRelPropGrpProp(insertPO);
        }
        catch (Exception ee) {
            log.error("\u81ea\u8425\u7269\u8d44\u5546\u54c1\u5c5e\u6027\u5173\u8054\u5c5e\u6027\u7ec4\u5931\u8d25!" + ee.getMessage());
            throw new BusinessException("8888", "\u81ea\u8425\u7269\u8d44\u5546\u54c1\u5c5e\u6027\u5173\u8054\u5c5e\u6027\u7ec4\u5931\u8d25!" + ee.getMessage());
        }
    }
}

