/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.busi.api.SearchEsManageExecuteSqlService;
import com.tydic.commodity.busibase.busi.api.SearchEsManageService;
import com.tydic.commodity.busibase.busi.bo.SearchCommodityManageBo;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageReqBo;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageRspBo;
import com.tydic.commodity.busibase.comb.api.SearchCommodityManageService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchSpuManageBO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchCommodityManageServiceImpl
implements SearchCommodityManageService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityManageServiceImpl.class);
    @Autowired
    private SearchEsManageService searchEsManageService;
    @Autowired
    private SearchEsManageExecuteSqlService searchEsManageExecuteSqlService;
    private static Integer esSeaarchSize = 10000;

    @Override
    public SearchCommodityManageRspBo searchCommodity(SearchEsManageReqBo reqBo) {
        SearchCommodityManageRspBo rspBo = new SearchCommodityManageRspBo();
        SearchEsManageRspBo searchEsManageRspBo = this.searchEsManageService.buildEsQuerySql(reqBo);
        searchEsManageRspBo.setIsFieldSku(reqBo.getIsFieldSku());
        searchEsManageRspBo.setIsFieldSpu(reqBo.getIsFieldSpu());
        SearchEsRspBo searchEsRspBo = this.searchEsManageExecuteSqlService.excuteSql(searchEsManageRspBo);
        if (searchEsRspBo == null) {
            log.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            rspBo.setPageNo(1);
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            return rspBo;
        }
        List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
        List<SearchCommodityManageBo> result = this.convertRspBo(commodityRspBos);
        rspBo.setPageNo(reqBo.getPageNo());
        List spuManageBOS = JSONObject.parseArray((String)JSONObject.toJSONString(result), SearchSpuManageBO.class);
        rspBo.setResult(spuManageBOS);
        int size = reqBo.getPageSize();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        totalPage = searchEsRspBo.getTotal() / size;
        add = searchEsRspBo.getTotal() % size == 0 ? 0 : 1;
        total = searchEsRspBo.getTotal();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setTotal(totalPage + add);
        rspBo.setRecordsTotal(total);
        return rspBo;
    }

    private List<SearchCommodityManageBo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchCommodityManageBo> searchBarEsRspInfos = new ArrayList<SearchCommodityManageBo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchCommodityManageBo searchCommodityManageBo = new SearchCommodityManageBo();
                searchCommodityManageBo.setCommodityId(commodityRspBo.getCommodity_id());
                searchCommodityManageBo.setSkuId(commodityRspBo.getSku_id());
                searchCommodityManageBo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchCommodityManageBo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchCommodityManageBo.setAgreementPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getAgreement_price())));
                searchCommodityManageBo.setMartketPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMarket_price())));
                searchCommodityManageBo.setSalePrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getSale_price())));
                searchCommodityManageBo.setSkuName(commodityRspBo.getSku_name());
                searchCommodityManageBo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchCommodityManageBo.setShopName(commodityRspBo.getShop_name());
                searchCommodityManageBo.setSupplierId(commodityRspBo.getSupplier_id());
                searchCommodityManageBo.setSupplierName(commodityRspBo.getSupplier_name());
                searchCommodityManageBo.setSkuSource(commodityRspBo.getSku_source());
                searchCommodityManageBo.setCommodityName(commodityRspBo.getCommodity_name());
                searchCommodityManageBo.setComPicUrl(commodityRspBo.getCommd_pic_url());
                searchCommodityManageBo.setVendorName(commodityRspBo.getVendor_name());
                searchCommodityManageBo.setAgreementId(commodityRspBo.getAgreement_id());
                searchCommodityManageBo.setChannelIds(commodityRspBo.getChannel_id());
                searchCommodityManageBo.setChannelNames(commodityRspBo.getChannel_Name());
                searchCommodityManageBo.setMeasure(commodityRspBo.getMeasure_name());
                searchCommodityManageBo.setVendorId(commodityRspBo.getVendor_id());
                searchCommodityManageBo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchCommodityManageBo.setBrandId(commodityRspBo.getBrand_id());
                searchCommodityManageBo.setBrandName(commodityRspBo.getBrand_name());
                searchCommodityManageBo.setDiscountRate(commodityRspBo.getDiscounts());
                searchCommodityManageBo.setMaterialCatalogId(commodityRspBo.getL4mg_category_id());
                searchCommodityManageBo.setMaterialCatalogName(commodityRspBo.getL4mg_category_name());
                searchCommodityManageBo.setCommodityTypeId(commodityRspBo.getType_id());
                searchCommodityManageBo.setCommodityTypeName(commodityRspBo.getType_name());
                searchCommodityManageBo.setSpec(commodityRspBo.getSpec());
                searchCommodityManageBo.setModel(commodityRspBo.getModel());
                searchCommodityManageBo.setMaterialCode(commodityRspBo.getMaterial_code());
                searchCommodityManageBo.setSkuStatus(commodityRspBo.getSku_status());
                searchCommodityManageBo.setCommodityCode(commodityRspBo.getCommodity_code());
                searchCommodityManageBo.setSkuCode(commodityRspBo.getSku_code());
                searchCommodityManageBo.setExtSpuId(commodityRspBo.getExt_spu_id());
                searchCommodityManageBo.setCatalogId(commodityRspBo.getL4mg_category_id());
                searchCommodityManageBo.setFreeLocation(commodityRspBo.getFree_location());
                try {
                    searchCommodityManageBo.setUpTime(new Date(commodityRspBo.getOn_shelve_time()));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                searchBarEsRspInfos.add(searchCommodityManageBo);
            }
        }
        return searchBarEsRspInfos;
    }
}

