/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccBatchQryCatlogAbilityService;
import com.tydic.commodity.common.ability.bo.UccBatchQryCatlogReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchQryCatlogRspBO;
import com.tydic.commodity.common.ability.bo.UccCatalogListBO;
import com.tydic.commodity.common.ability.bo.UccCommdRCatsBO;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.po.CommdRCatPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBatchQryCatlogAbilityService"})
public class UccBatchQryCatlogAbilityServiceImpl
implements UccBatchQryCatlogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchQryCatlogAbilityServiceImpl.class);
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;

    @PostMapping(value={"batchQryCatalog"})
    public UccBatchQryCatlogRspBO batchQryCatalog(@RequestBody UccBatchQryCatlogReqBO reqBO) {
        UccBatchQryCatlogRspBO rspBO = new UccBatchQryCatlogRspBO();
        ArrayList<UccCommdRCatsBO> uccCommdRCatsBOS = new ArrayList<UccCommdRCatsBO>();
        rspBO.setResult(uccCommdRCatsBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u5546\u54c1ID\u96c6\u5408");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u5e97\u94faID");
        }
        try {
            List commdRCatPOS = this.uccCatalogDealMapper.batchQryCommdRCat(reqBO.getCommodityIds(), reqBO.getSupplierShopId());
            if (CollectionUtils.isEmpty((Collection)commdRCatPOS)) {
                return rspBO;
            }
            Map<Long, List<CommdRCatPO>> groupByCommd = commdRCatPOS.stream().collect(Collectors.groupingBy(CommdRCatPO::getCommodityId));
            for (Map.Entry<Long, List<CommdRCatPO>> each : groupByCommd.entrySet()) {
                UccCommdRCatsBO uccCommdRCatsBO = new UccCommdRCatsBO();
                uccCommdRCatsBO.setCommodityId(each.getKey());
                List<CommdRCatPO> commdRCatPOS1 = each.getValue();
                ArrayList<UccCatalogListBO> uccCatalogListBOS = new ArrayList<UccCatalogListBO>();
                for (CommdRCatPO commdRCatPO : commdRCatPOS1) {
                    UccCatalogListBO uccCatalogListBO = new UccCatalogListBO();
                    uccCatalogListBO.setCatalogId(commdRCatPO.getCatalogId());
                    uccCatalogListBO.setCatalogLevel(commdRCatPO.getCatalogLevel());
                    uccCatalogListBO.setCatalogName(commdRCatPO.getCatalogName());
                    uccCatalogListBO.setIconUrl(commdRCatPO.getIconUrl());
                    uccCatalogListBOS.add(uccCatalogListBO);
                }
                uccCommdRCatsBO.setCatalogInfos(uccCatalogListBOS);
                uccCommdRCatsBOS.add(uccCommdRCatsBO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        return rspBO;
    }
}

