/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.FuzzyFieldsEnum;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.SearchCommodityManageAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityReqBo;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityRspBo;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService"})
public class UccSkuPoolSkuListQryAbilityServiceImpl
implements UccSkuPoolSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolSkuListQryAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityManageAbilityService searchCommodityManageAbilityService;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"qrySkuPoolskuList"})
    public UccSkuPoolSkuListQryAbilityRspBo qrySkuPoolskuList(@RequestBody UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespDesc(e.getMessage());
            rspBo.setRespCode("8888");
            return rspBo;
        }
        switch (reqBo.getSearchType()) {
            case 0: {
                rspBo = this.getNRelSkuList(reqBo);
                break;
            }
            case 1: {
                rspBo = this.getRelSkuList(reqBo);
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuPoolSkuListQryAbilityRspBo getRelSkuList(UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo;
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        ArrayList uccSkuPoolRelDataQryListAbilityBos = new ArrayList();
        Page page = new Page(-1, reqBo.getPageSize());
        UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
        cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
        cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relBySku);
        List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
        List<Long> relSkuIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos) && reqBo.getSkuId() == null) {
            relSkuIds = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
        }
        if (reqBo.getSkuId() != null) {
            relSkuIds.add(reqBo.getSkuId());
        }
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        searchCommodityManageAbilityReqBo.setPoolIds((List)Lists.newArrayList((Object[])new Long[]{reqBo.getPoolId()}));
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBo.getSkuCode());
        searchCommodityManageAbilityReqBo.setCommodityName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setSkuList(relSkuIds);
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getSkuName());
        searchCommodityManageAbilityReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchCommodityManageAbilityReqBo.setVendorId(reqBo.getVendorId());
        searchCommodityManageAbilityReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchCommodityManageAbilityReqBo.setBrandId(reqBo.getBrandId());
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("commodityName");
        fuzzyFields.add("commodityCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(fuzzyFields);
        if (reqBo.getType() == 1) {
            searchCommodityManageAbilityReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        if ("0000".equals((searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo)).getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
                searchCommodityManageAbilityRspBo.getResult().forEach(each -> {
                    UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                    if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                        uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                    }
                    uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                    uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                });
            }
            rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
            rspBo.setPageNo(searchCommodityManageAbilityRspBo.getPageNo());
        }
        rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        return rspBo;
    }

    private UccSkuPoolSkuListQryAbilityRspBo getNRelSkuList(UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo;
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        ArrayList uccSkuPoolRelDataQryListAbilityBos = new ArrayList();
        Page page = new Page(-1, reqBo.getPageSize());
        UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
        cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
        Map<Object, Object> collect = new HashMap();
        ArrayList relDatas = new ArrayList();
        List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
        if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos)) {
            collect = cnncRelPoolCommodityPos.stream().collect(Collectors.groupingBy(e -> e.getPoolRelated()));
            for (Integer n : collect.keySet()) {
                List uccRelPoolCommodityPos = (List)collect.get(n);
                if (CollectionUtils.isEmpty((Collection)uccRelPoolCommodityPos)) continue;
                List source = uccRelPoolCommodityPos.stream().map(e -> e.getSource()).collect(Collectors.toList());
                if (n != null && n == 1) {
                    source = this.uccRelPoolCommodityMapper.queryCommodityIdsByTypes(source);
                }
                if (n != null && n == 6) {
                    source = this.uccRelPoolCommodityMapper.queryCommodityIdsBySups(source);
                }
                relDatas.addAll(source);
            }
        }
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        searchCommodityManageAbilityReqBo.setIgnorSpuList(relDatas);
        if (reqBo.getSkuId() != null) {
            searchCommodityManageAbilityReqBo.setSkuList((List)Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        }
        searchCommodityManageAbilityReqBo.setCommodityName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBo.getSkuCode());
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getSkuName());
        searchCommodityManageAbilityReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchCommodityManageAbilityReqBo.setVendorId(reqBo.getVendorId());
        searchCommodityManageAbilityReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchCommodityManageAbilityReqBo.setBrandId(reqBo.getBrandId());
        searchCommodityManageAbilityReqBo.setSupplierShopId(reqBo.getSupplierShopId());
        searchCommodityManageAbilityReqBo.setFreeLocation(reqBo.getFreeLocation());
        searchCommodityManageAbilityReqBo.setSkuForm(reqBo.getSkuForm());
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        List list = FuzzyFieldsEnum.getAllField();
        list.add("commodityName");
        list.add("commodityCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(list);
        if (reqBo.getType() == 1) {
            searchCommodityManageAbilityReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        if ("0000".equals((searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo)).getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
                searchCommodityManageAbilityRspBo.getResult().forEach(each -> {
                    UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                    if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                        uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                    }
                    uccSkuPoolRelDataQryListAbilityBo.setSupplierShopName(each.getShopName());
                    uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                    uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                });
            }
            rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
            rspBo.setPageNo(searchCommodityManageAbilityRspBo.getPageNo());
        }
        if (!CollectionUtils.isEmpty(uccSkuPoolRelDataQryListAbilityBos)) {
            for (UccSkuPoolRelDataQryListAbilityBo bo : uccSkuPoolRelDataQryListAbilityBos) {
                if (bo.getCommodityId() == null) continue;
                UccSkuPo skuPo = new UccSkuPo();
                skuPo.setCommodityId(bo.getCommodityId());
                List skuPos = this.uccSkuMapper.qerySku(skuPo);
                Set<Object> collect1 = new HashSet();
                if (!CollectionUtils.isEmpty((Collection)skuPos)) {
                    collect1 = skuPos.stream().map(e -> e.getSkuForm()).collect(Collectors.toSet());
                }
                if (CollectionUtils.isEmpty(collect1)) continue;
                List skuForms = collect1.stream().sorted(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        if (o1 > o2) {
                            return 1;
                        }
                        return -1;
                    }
                }).collect(Collectors.toList());
                StringBuilder commodityFrom = new StringBuilder();
                for (int i = 0; i < skuForms.size(); ++i) {
                    Integer skufrom = (Integer)skuForms.get(i);
                    if (skufrom == 3) {
                        commodityFrom.append("\u671f\u8d27\u8ba2\u8d2d/");
                    }
                    if (skufrom == 2) {
                        commodityFrom.append("\u73b0\u8d27\u8ba2\u8d2d/");
                    }
                    if (skufrom == 1) {
                        commodityFrom.append("\u6837\u5361/");
                    }
                    if (skufrom != 0) continue;
                    commodityFrom.append("\u5927\u8d27/");
                }
                System.out.println(commodityFrom);
                String substring = commodityFrom.substring(0, commodityFrom.length() - 1);
                bo.setCommodityFrom(substring);
            }
        }
        rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        return rspBo;
    }
}

