/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.atom.api.UccGetSortSeqAtomService;
import com.tydic.commodity.common.atom.bo.UccGetSortSeqAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccGetSortSeqAtomRspBO;
import com.tydic.commodity.dao.UccChannelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccGetSortSeqAtomServiceImpl
implements UccGetSortSeqAtomService {
    @Autowired
    private UccChannelMapper uccChannelMapper;

    @Override
    public UccGetSortSeqAtomRspBO getSeq(UccGetSortSeqAtomReqBO reqBO) {
        Integer viewOrderNew;
        UccGetSortSeqAtomRspBO rspBO = new UccGetSortSeqAtomRspBO();
        if (reqBO.getObjType() == 1) {
            Integer viewOrderMax;
            try {
                viewOrderMax = this.uccChannelMapper.getMaxViewOrder();
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
            }
            int result = 0;
            if (reqBO.getSeqId() == null || reqBO.getSeqId() >= viewOrderMax) {
                viewOrderNew = viewOrderMax + (int)Math.pow(10.0, String.valueOf(viewOrderMax).length() - 1);
            } else {
                Integer viewOrderMin;
                try {
                    viewOrderMin = this.uccChannelMapper.getMinViewOrder(reqBO.getSeqId());
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
                }
                viewOrderNew = this.getSeqId(reqBO.getSeqId(), viewOrderMin);
                if (viewOrderNew.equals(viewOrderMin)) {
                    try {
                        result = this.uccChannelMapper.updateAllViewOrder();
                    }
                    catch (Exception e) {
                        throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
                    }
                    viewOrderNew = this.getSeqId(reqBO.getSeqId() * 10, viewOrderMin * 10);
                }
            }
        } else {
            viewOrderNew = -1;
        }
        rspBO.setSeqId(viewOrderNew);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Integer getSeqId(Integer viewOrderPre, Integer viewOrderAft) {
        Integer add = (viewOrderAft - viewOrderPre) / 2;
        if (add < 1) {
            add = 1;
        }
        return viewOrderPre + add;
    }
}

