/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.common.atom.api.UccGoodsfreezetocompleteAtomService;
import com.tydic.commodity.common.atom.bo.UccGoodsfreezetocompleteAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccGoodsfreezetocompleteAtomRspBO;
import com.tydic.commodity.dao.UccBeforeStatusRecordEditMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccBeforeStatusRecordEditPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccGoodsfreezetocompleteAtomServiceImpl
implements UccGoodsfreezetocompleteAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccGoodsfreezetocompleteAtomServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccBeforeStatusRecordEditMapper uccBeforeStatusRecordEditMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;

    @Override
    public UccGoodsfreezetocompleteAtomRspBO dealgoodsfreezetocomplete(UccGoodsfreezetocompleteAtomReqBO reqBO) {
        UccGoodsfreezetocompleteAtomRspBO rspBO = new UccGoodsfreezetocompleteAtomRspBO();
        if (CollectionUtils.isEmpty(reqBO.getCommodityIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List skuPoList = this.uccSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierShopId());
        if (CollectionUtils.isEmpty((Collection)skuPoList)) {
            throw new BusinessException(RspConstantEnums.SKU_NOT_EXIST.code(), RspConstantEnums.SKU_NOT_EXIST.message());
        }
        List skus = skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        if (reqBO.getNexSkutStatus() != null) {
            List ids;
            Map<Integer, List<UccBeforeStatusRecordEditPO>> spuMap;
            List spuRecord = this.uccBeforeStatusRecordEditMapper.batchQueryRecord(reqBO.getCommodityIds(), reqBO.getSupplierShopId(), Integer.valueOf(1));
            List skuRecord = this.uccBeforeStatusRecordEditMapper.batchQueryRecord(skus, reqBO.getSupplierShopId(), Integer.valueOf(2));
            if (!CollectionUtils.isEmpty((Collection)spuRecord)) {
                spuMap = spuRecord.stream().collect(Collectors.groupingBy(UccBeforeStatusRecordEditPO::getStatus));
                for (Integer status : spuMap.keySet()) {
                    ids = spuMap.get(status).stream().map(UccBeforeStatusRecordEditPO::getId).collect(Collectors.toList());
                    try {
                        this.uccCommodityMapper.batchUpdateCommodityStatus(ids, status, reqBO.getSupplierShopId());
                    }
                    catch (Exception e) {
                        throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)skuRecord)) {
                spuMap = spuRecord.stream().collect(Collectors.groupingBy(UccBeforeStatusRecordEditPO::getStatus));
                for (Integer status : spuMap.keySet()) {
                    ids = spuMap.get(status).stream().map(UccBeforeStatusRecordEditPO::getId).collect(Collectors.toList());
                    try {
                        this.uccSkuMapper.batchUpdateSkuStatusByIds(ids, status, reqBO.getSupplierShopId());
                    }
                    catch (Exception e) {
                        throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                    }
                }
            }
        } else {
            UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
            ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
            UccSkuUpdateStatusBO bo = null;
            for (Long each : skus) {
                bo = new UccSkuUpdateStatusBO();
                bo.setSkuId(each);
                bo.setSkuStatus(reqBO.getNexSkutStatus());
                skuUpdateStatusBOS.add(bo);
            }
            uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
            uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
            try {
                statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        try {
            this.uccBeforeStatusRecordEditMapper.batchdelete(reqBO.getCommodityIds(), reqBO.getSupplierShopId(), Integer.valueOf(1));
            this.uccBeforeStatusRecordEditMapper.batchdelete(skus, reqBO.getSupplierShopId(), Integer.valueOf(1));
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

