/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.bo.UccTemplateListBo;
import com.tydic.commodity.common.busi.api.DaYaoUccDropTemplateBusiService;
import com.tydic.commodity.common.busi.bo.DaYaoUccDropTemplateBusiReqBO;
import com.tydic.commodity.common.busi.bo.DaYaoUccDropTemplateBusiRspBO;
import com.tydic.commodity.dao.UccCommodityTemplateMapper;
import com.tydic.commodity.po.UccCommodityTemplatePO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DaYaoUccDropTemplateBusiServiceImpl
implements DaYaoUccDropTemplateBusiService {
    private static final Logger log = LoggerFactory.getLogger(DaYaoUccDropTemplateBusiServiceImpl.class);
    @Autowired
    private UccCommodityTemplateMapper uccCommodityTemplateMapper;

    @Override
    public DaYaoUccDropTemplateBusiRspBO qryDropListTemplate(DaYaoUccDropTemplateBusiReqBO reqBO) {
        DaYaoUccDropTemplateBusiRspBO rspBO = new DaYaoUccDropTemplateBusiRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        if (ObjectUtils.isEmpty((Object)reqBO.getTemType())) {
            List detailList = this.uccCommodityTemplateMapper.getDropListByCommodityType(reqBO.getCommodityTypeId().toString(), UccConstants.UccCommodityTempType.DETAIL);
            List quantityList = this.uccCommodityTemplateMapper.getDropListByCommodityType(reqBO.getCommodityTypeId().toString(), UccConstants.UccCommodityTempType.QUANTITY);
            List sourceList = this.uccCommodityTemplateMapper.getDropListByCommodityType(reqBO.getCommodityTypeId().toString(), UccConstants.UccCommodityTempType.SOURCE);
            List feedbackList = this.uccCommodityTemplateMapper.getDropListByCommodityType(reqBO.getCommodityTypeId().toString(), UccConstants.UccCommodityTempType.FEEDBACK);
            rspBO.setCommodityTemList(this.transfer(detailList));
            rspBO.setQuantityTemList(this.transfer(quantityList));
            rspBO.setSourceTemList(this.transfer(sourceList));
            rspBO.setFeedbackTemList(this.transfer(feedbackList));
            return rspBO;
        }
        List dropListByCommodityType = this.uccCommodityTemplateMapper.getDropListByCommodityType(reqBO.getCommodityTypeId().toString(), reqBO.getTemType());
        if (!CollectionUtils.isEmpty((Collection)dropListByCommodityType)) {
            List<UccTemplateListBo> collect = this.transfer(dropListByCommodityType);
            if (UccConstants.UccCommodityTempType.DETAIL.equals(reqBO.getTemType())) {
                rspBO.setCommodityTemList(collect);
            }
            if (UccConstants.UccCommodityTempType.QUANTITY.equals(reqBO.getTemType())) {
                rspBO.setQuantityTemList(collect);
            }
            if (UccConstants.UccCommodityTempType.SOURCE.equals(reqBO.getTemType())) {
                rspBO.setSourceTemList(collect);
            }
            if (UccConstants.UccCommodityTempType.FEEDBACK.equals(reqBO.getTemType())) {
                rspBO.setFeedbackTemList(collect);
            }
        }
        return rspBO;
    }

    private List<UccTemplateListBo> transfer(List<UccCommodityTemplatePO> list) {
        if (!CollectionUtils.isEmpty(list)) {
            return list.stream().map(e -> (UccTemplateListBo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccTemplateListBo.class)).collect(Collectors.toList());
        }
        return null;
    }
}

