/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.atom.api.UccSignBatchAdjustLogAtomService;
import com.tydic.commodity.common.atom.bo.UccSignBatchAdjustLogAtomServiceReqBO;
import com.tydic.commodity.common.atom.bo.UccSignBatchAdjustLogAtomServiceRspBO;
import com.tydic.commodity.common.busi.api.UccBatchAdjustBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchAdjustBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchAdjustBusiRspBO;
import com.tydic.commodity.dao.ErpSkuPriceChangeMapper;
import com.tydic.commodity.dao.UccSkuAdjustPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.ErpSkuPriceChangePO;
import com.tydic.commodity.po.UccSkuAdjustPricePO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchAdjustBusiServiceImpl
implements UccBatchAdjustBusiService {
    @Autowired
    private UccSkuAdjustPriceMapper uccSkuAdjustPriceMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSignBatchAdjustLogAtomService uccSignBatchAdjustLogAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ErpSkuPriceChangeMapper erpSkuPriceChangeMapper;

    @Override
    public UccBatchAdjustBusiRspBO batchAdjust(UccBatchAdjustBusiReqBO reqBO) {
        Boolean isFirstAdjust = reqBO.getIsFirst();
        Long skuId = null;
        UccBatchAdjustBusiRspBO rspBO = new UccBatchAdjustBusiRspBO();
        ArrayList<UccSkuAdjustPricePO> uccSkuAdjustPricePOList = new ArrayList<UccSkuAdjustPricePO>();
        for (String skuCode : reqBO.getSkuCodeList()) {
            Long quota;
            UccSkuPricePo uccSkuPricePo;
            if (isFirstAdjust.booleanValue()) {
                Long quota2;
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuCode(skuCode);
                List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
                if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                    throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u65e0\u6b64skuId:" + skuCode + "\u7684\u5355\u54c1\u4fe1\u606f");
                }
                if (uccSkuPoList.size() > 1) {
                    throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u6761\u6b64skuId:" + skuCode + "\u7684\u5355\u54c1\u4fe1\u606f");
                }
                uccSkuPo = (UccSkuPo)uccSkuPoList.get(0);
                skuId = uccSkuPo.getSkuId();
                uccSkuPricePo = new UccSkuPricePo();
                uccSkuPricePo.setSkuId(skuId);
                uccSkuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
                if (uccSkuPricePo == null) {
                    throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u65e0\u6b64skuId:" + skuId + "\u7684\u5355\u54c1\u4ef7\u683c\u4fe1\u606f");
                }
                UccSkuAdjustPricePO insertUccSkuAdjustPricePO = new UccSkuAdjustPricePO();
                insertUccSkuAdjustPricePO.setSkuId(skuId);
                insertUccSkuAdjustPricePO.setCommodityId(uccSkuPo.getCommodityId());
                insertUccSkuAdjustPricePO.setSupplierShopId(uccSkuPo.getSupplierShopId());
                insertUccSkuAdjustPricePO.setBeforePride(uccSkuPricePo.getAgreementPrice());
                if (UccConstants.UccAdjustOperType.QUOTA.equals(reqBO.getAdjustOperType())) {
                    insertUccSkuAdjustPricePO.setAdjustQuota(reqBO.getAdjustQuota());
                    insertUccSkuAdjustPricePO.setAfterPrice(Long.valueOf(insertUccSkuAdjustPricePO.getAfterPrice() + reqBO.getAdjustQuota()));
                    BigDecimal ratio = BigDecimal.valueOf(reqBO.getAdjustQuota()).subtract(BigDecimal.valueOf(insertUccSkuAdjustPricePO.getBeforePride()));
                    insertUccSkuAdjustPricePO.setAdjustRatio(ratio);
                } else if (UccConstants.UccAdjustOperType.RATIO.equals(reqBO.getAdjustOperType())) {
                    insertUccSkuAdjustPricePO.setAdjustRatio(reqBO.getAdjustRatio());
                    insertUccSkuAdjustPricePO.setAfterPrice(Long.valueOf(insertUccSkuAdjustPricePO.getAfterPrice() + BigDecimal.valueOf(insertUccSkuAdjustPricePO.getAfterPrice()).multiply(reqBO.getAdjustRatio()).longValue()));
                    quota2 = insertUccSkuAdjustPricePO.getAfterPrice() - insertUccSkuAdjustPricePO.getBeforePride();
                    insertUccSkuAdjustPricePO.setAdjustQuota(quota2);
                } else {
                    insertUccSkuAdjustPricePO.setAfterPrice(reqBO.getModifyPrice());
                    quota2 = insertUccSkuAdjustPricePO.getAfterPrice() - insertUccSkuAdjustPricePO.getBeforePride();
                    insertUccSkuAdjustPricePO.setAdjustQuota(quota2);
                    BigDecimal ratio = BigDecimal.valueOf(quota2).subtract(BigDecimal.valueOf(insertUccSkuAdjustPricePO.getBeforePride()));
                    insertUccSkuAdjustPricePO.setAdjustRatio(ratio);
                }
                insertUccSkuAdjustPricePO.setAdjustType(UccConstants.UccAdjustType.MALL_ADJUST);
                insertUccSkuAdjustPricePO.setAdjustTime(new Date());
                insertUccSkuAdjustPricePO.setOperName(reqBO.getName());
                int i = this.uccSkuAdjustPriceMapper.insert(insertUccSkuAdjustPricePO);
                if (i != 1) {
                    throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u63d2\u5165\u6b64skuId:" + skuId + "\u7684\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f\u5931\u8d25");
                }
                if (UccConstants.CommoditySourceEnum.SELF.getKey().equals(uccSkuPo.getSkuSource())) {
                    ErpSkuPriceChangePO erpSkuPriceChangePO = new ErpSkuPriceChangePO();
                    erpSkuPriceChangePO.setSkuId(skuId);
                    erpSkuPriceChangePO.setErpSkuCode(uccSkuPo.getExtSkuId());
                    erpSkuPriceChangePO.setErpSkuShape(uccSkuPo.getSkuForm().toString());
                    erpSkuPriceChangePO.setProductLevel(uccSkuPo.getProductLevel());
                    erpSkuPriceChangePO.setErpQuota(reqBO.getAdjustQuota());
                    erpSkuPriceChangePO.setMarketPrice(uccSkuPricePo.getAgreementPrice());
                    erpSkuPriceChangePO.setChangeTime(new Date());
                    int j = this.erpSkuPriceChangeMapper.insert(erpSkuPriceChangePO);
                    if (j != 1) {
                        throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u63d2\u5165\u6b64skuId:" + skuId + "\u7684erp\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f\u5931\u8d25");
                    }
                }
                uccSkuAdjustPricePOList.add(insertUccSkuAdjustPricePO);
                continue;
            }
            UccSkuAdjustPricePO modelPO = new UccSkuAdjustPricePO();
            modelPO.setSkuCode(skuCode);
            UccSkuAdjustPricePO uccSkuAdjustPricePO = this.uccSkuAdjustPriceMapper.getModelBy(modelPO);
            if (uccSkuAdjustPricePO == null) {
                throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u65e0\u6b64skuId:" + skuId + "\u7684\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f");
            }
            skuId = uccSkuAdjustPricePO.getSkuId();
            uccSkuAdjustPricePO.setBeforePride(uccSkuAdjustPricePO.getAfterPrice());
            if (UccConstants.UccAdjustOperType.QUOTA.equals(reqBO.getAdjustOperType())) {
                uccSkuAdjustPricePO.setAdjustQuota(reqBO.getAdjustQuota());
                uccSkuAdjustPricePO.setAfterPrice(Long.valueOf(uccSkuAdjustPricePO.getAfterPrice() + reqBO.getAdjustQuota()));
                BigDecimal ratio = BigDecimal.valueOf(reqBO.getAdjustQuota()).subtract(BigDecimal.valueOf(uccSkuAdjustPricePO.getBeforePride()));
                uccSkuAdjustPricePO.setAdjustRatio(ratio);
            } else if (UccConstants.UccAdjustOperType.RATIO.equals(reqBO.getAdjustOperType())) {
                uccSkuAdjustPricePO.setAdjustRatio(reqBO.getAdjustRatio());
                uccSkuAdjustPricePO.setAfterPrice(Long.valueOf(uccSkuAdjustPricePO.getAfterPrice() + BigDecimal.valueOf(uccSkuAdjustPricePO.getAfterPrice()).multiply(reqBO.getAdjustRatio()).longValue()));
                quota = uccSkuAdjustPricePO.getAfterPrice() - uccSkuAdjustPricePO.getBeforePride();
                uccSkuAdjustPricePO.setAdjustQuota(quota);
            } else {
                uccSkuAdjustPricePO.setAfterPrice(reqBO.getModifyPrice());
                quota = uccSkuAdjustPricePO.getAfterPrice() - uccSkuAdjustPricePO.getBeforePride();
                uccSkuAdjustPricePO.setAdjustQuota(quota);
                BigDecimal ratio = BigDecimal.valueOf(quota).subtract(BigDecimal.valueOf(uccSkuAdjustPricePO.getBeforePride()));
                uccSkuAdjustPricePO.setAdjustRatio(ratio);
            }
            uccSkuAdjustPricePO.setAdjustType(UccConstants.UccAdjustType.MALL_ADJUST);
            uccSkuAdjustPricePO.setAdjustTime(new Date());
            uccSkuAdjustPricePO.setOperName(reqBO.getName());
            uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(skuId);
            uccSkuPricePo.setSupplierShopId(uccSkuAdjustPricePO.getSupplierShopId());
            uccSkuPricePo.setSalePrice(uccSkuAdjustPricePO.getAfterPrice());
            this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
            uccSkuAdjustPricePOList.add(uccSkuAdjustPricePO);
        }
        if (!CollectionUtils.isEmpty(uccSkuAdjustPricePOList)) {
            UccSignBatchAdjustLogAtomServiceReqBO uccSignBatchAdjustLogAtomServiceReqBO = new UccSignBatchAdjustLogAtomServiceReqBO();
            uccSignBatchAdjustLogAtomServiceReqBO.setUccSkuAdjustPricePOList(uccSkuAdjustPricePOList);
            UccSignBatchAdjustLogAtomServiceRspBO uccSignBatchAdjustLogAtomServiceRspBO = this.uccSignBatchAdjustLogAtomService.signBatchAdjustLog(uccSignBatchAdjustLogAtomServiceReqBO);
            if (!"0000".equals(uccSignBatchAdjustLogAtomServiceRspBO.getRespCode())) {
                rspBO.setRespCode(uccSignBatchAdjustLogAtomServiceRspBO.getRespCode());
                rspBO.setRespDesc(uccSignBatchAdjustLogAtomServiceRspBO.getRespDesc());
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6279\u91cf\u8c03\u4ef7\u6210\u529f");
        return rspBO;
    }
}

