/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccCommodityDetailTemplateUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccCommodityDetailTemplateUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCommodityDetailTemplateUpdateBusiRspBO;
import com.tydic.commodity.dao.UccCommodityTemplateMapper;
import com.tydic.commodity.dao.UccTemplateAppMapper;
import com.tydic.commodity.dao.UccTemplateContentMapper;
import com.tydic.commodity.po.UccCommodityTemplatePO;
import com.tydic.commodity.po.UccTemplateAppPO;
import com.tydic.commodity.po.UccTemplateContentPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccCommodityDetailTemplateUpdateBusiServiceImpl
implements UccCommodityDetailTemplateUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityDetailTemplateUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommodityTemplateMapper uccCommodityTemplateMapper;
    @Autowired
    private UccTemplateAppMapper uccTemplateAppMapper;
    @Autowired
    private UccTemplateContentMapper uccTemplateContentMapper;

    @Override
    public UccCommodityDetailTemplateUpdateBusiRspBO updateTempByCommodityDetail(UccCommodityDetailTemplateUpdateBusiReqBO reqBO) {
        if (!ObjectUtils.isEmpty((Object)reqBO.getTemId())) {
            this.updateTemp(reqBO);
        } else {
            this.addTemp(reqBO);
        }
        UccCommodityDetailTemplateUpdateBusiRspBO rspBO = new UccCommodityDetailTemplateUpdateBusiRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    private void updateTemp(UccCommodityDetailTemplateUpdateBusiReqBO reqBO) {
        UccCommodityTemplatePO where = new UccCommodityTemplatePO();
        where.setTemId(reqBO.getTemId());
        UccCommodityTemplatePO set = new UccCommodityTemplatePO();
        set.setUpdateOperId(reqBO.getUserId().toString());
        set.setUpdateOperName(reqBO.getUsername());
        set.setUpdateTime(new Date());
        set.setTemName(reqBO.getTemName());
        UccTemplateContentPO contentWhere = new UccTemplateContentPO();
        contentWhere.setTemId(reqBO.getTemId());
        UccTemplateContentPO contentSet = new UccTemplateContentPO();
        contentSet.setContentStr(reqBO.getContentStr());
        UccTemplateAppPO appSet = new UccTemplateAppPO();
        appSet.setAppCode(reqBO.getCommodityTypeId().toString());
        UccTemplateAppPO appWhere = new UccTemplateAppPO();
        appWhere.setTemId(reqBO.getTemId());
        try {
            this.uccCommodityTemplateMapper.updateBy(set, where);
            this.uccTemplateContentMapper.updateBy(contentSet, contentWhere);
            this.uccTemplateAppMapper.updateBy(appSet, appWhere);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6a21\u677f\u5f02\u5e38\uff01" + e.getMessage());
            throw new BusinessException("8888", "\u66f4\u65b0\u6a21\u677f\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private void addTemp(UccCommodityDetailTemplateUpdateBusiReqBO reqBO) {
        Long temId = Sequence.getInstance().nextId();
        UccCommodityTemplatePO where = new UccCommodityTemplatePO();
        where.setTemId(temId);
        where.setTemName(reqBO.getTemName());
        where.setTemState(UccConstants.Status.VALID);
        where.setTemType(UccConstants.UccCommodityTempType.DETAIL);
        where.setTemCode(temId.toString());
        where.setCreateOperId(reqBO.getUserId().toString());
        where.setCreateOperName(reqBO.getUsername());
        where.setCreateTime(new Date());
        where.setUpdateTime(new Date());
        where.setUpdateOperName(reqBO.getUsername());
        where.setUpdateOperId(reqBO.getUserId().toString());
        UccTemplateContentPO contentWhere = new UccTemplateContentPO();
        contentWhere.setTemId(temId);
        contentWhere.setContentId(Long.valueOf(Sequence.getInstance().nextId()));
        contentWhere.setContentStr(reqBO.getContentStr());
        contentWhere.setCreateOperId(reqBO.getUserId().toString());
        contentWhere.setCreateOperName(reqBO.getUsername());
        contentWhere.setCreateTime(new Date());
        UccTemplateAppPO appWhere = new UccTemplateAppPO();
        appWhere.setTemId(temId);
        appWhere.setAppCode(reqBO.getCommodityTypeId().toString());
        appWhere.setId(Long.valueOf(Sequence.getInstance().nextId()));
        appWhere.setAppState(UccConstants.Status.VALID);
        appWhere.setAppType(Integer.valueOf(0));
        appWhere.setCreateOperId(reqBO.getUserId().toString());
        appWhere.setCreateOperName(reqBO.getUsername());
        appWhere.setCreateTime(new Date());
        try {
            this.uccCommodityTemplateMapper.insert(where);
            this.uccTemplateContentMapper.insert(contentWhere);
            this.uccTemplateAppMapper.insert(appWhere);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6a21\u677f\u5f02\u5e38\uff01" + e.getMessage());
            throw new BusinessException("8888", "\u65b0\u9547\u6a21\u677f\u5f02\u5e38\uff01" + e.getMessage());
        }
    }
}

