/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.common.ability.bo.UccSelfMaterialStockExcelBO;
import com.tydic.commodity.common.busi.api.UccImportBatchModifyStockBusiService;
import com.tydic.commodity.common.busi.api.UccModifyMaterialStockBusiService;
import com.tydic.commodity.common.busi.bo.UccImportBatchModifyStockBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccImportBatchModifyStockBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccModifyMaterialStockBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccModifyMaterialStockBusiRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccImportBatchModifyStockBusiServiceImpl
implements UccImportBatchModifyStockBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccImportBatchModifyStockBusiServiceImpl.class);
    @Autowired
    private UccModifyMaterialStockBusiService uccModifyMaterialStockBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccImportBatchModifyStockBusiRspBO importBatchModifyStock(UccImportBatchModifyStockBusiReqBO reqBO) {
        UccImportBatchModifyStockBusiRspBO rspBO = new UccImportBatchModifyStockBusiRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new ZTBusinessException("url\u4e3a\u7a7a");
        }
        String url = reqBO.getUrl();
        List<UccSelfMaterialStockExcelBO> uccSelfMaterialStockExcelBOList = this.getCommodityBOList(url);
        if (!CollectionUtils.isEmpty(uccSelfMaterialStockExcelBOList)) {
            for (UccSelfMaterialStockExcelBO bo : uccSelfMaterialStockExcelBOList) {
                ArrayList<String> skuCodeList = new ArrayList<String>();
                skuCodeList.add(bo.getSkuCode());
                List uccSkuPoList = this.uccSkuMapper.querySkuByCode(skuCodeList);
                if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                    throw new ZTBusinessException("\u5e8f\u53f7\uff1a" + bo.getSerialNum() + "\u4fee\u6539\u5e93\u5b58\u5931\u8d25\uff0c\u65e0\u6b64sku\u7f16\u7801\u7684\u5355\u54c1\u4fe1\u606f");
                }
                if (uccSkuPoList.size() > 1) {
                    throw new ZTBusinessException("\u5e8f\u53f7\uff1a" + bo.getSerialNum() + "\u4fee\u6539\u5e93\u5b58\u5931\u8d25\uff0c\u6b64sku\u7f16\u7801\u7684\u5355\u54c1\u4fe1\u606f\u4e0d\u552f\u4e00");
                }
                UccModifyMaterialStockBusiReqBO busiReqBO = new UccModifyMaterialStockBusiReqBO();
                busiReqBO.setNum(bo.getNum());
                busiReqBO.setOperType(bo.getOperType());
                busiReqBO.setSkuId(((UccSkuPo)uccSkuPoList.get(0)).getSkuId());
                UccModifyMaterialStockBusiRspBO busiRspBO = this.uccModifyMaterialStockBusiService.modifyMaterialStock(busiReqBO);
                if ("0000".equals(busiRspBO.getRespCode())) continue;
                throw new ZTBusinessException("\u5e8f\u53f7\uff1a" + bo.getSerialNum() + " \u4fee\u6539\u5e93\u5b58\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u5165\u6279\u91cf\u5e93\u5b58\u4fee\u6539\u6210\u529f");
        return rspBO;
    }

    private List<UccSelfMaterialStockExcelBO> getCommodityBOList(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccSelfMaterialStockExcelBO> uccSelfMaterialStockExcelBOList = new ArrayList<UccSelfMaterialStockExcelBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccSelfMaterialStockExcelBO uccSelfMaterialStockExcelBO = new UccSelfMaterialStockExcelBO();
                    int i = 0;
                    String serialNum = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setSerialNum(Integer.valueOf(serialNum));
                    String skuName = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setSkuName(skuName);
                    String skuCode = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setSkuCode(skuCode);
                    String skuFormStr = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setSkuFormStr(skuFormStr);
                    String totalNum = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setTotalNum(Long.valueOf(totalNum));
                    String saledNum = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setSaledNum(Long.valueOf(saledNum));
                    String cancelNum = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setCancelNum(Long.valueOf(cancelNum));
                    String operType = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setOperType(Integer.valueOf(operType));
                    String num = (String)list.get(i++);
                    uccSelfMaterialStockExcelBO.setNum(Long.valueOf(num));
                    uccSelfMaterialStockExcelBOList.add(uccSelfMaterialStockExcelBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return uccSelfMaterialStockExcelBOList;
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u5904\u7406Excel\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

