/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.enumType.CommodityPropGrpEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.bo.UccModifyPropGrpReqBO;
import com.tydic.commodity.common.ability.bo.UccModifyPropGrpRspBO;
import com.tydic.commodity.common.busi.api.UccModifyPropGroupBusiService;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.po.UccSpuSpecPo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccModifyPropGroupBusiServiceImpl
implements UccModifyPropGroupBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccModifyPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;

    @Override
    public UccModifyPropGrpRspBO modifyGroup(UccModifyPropGrpReqBO reqBO) {
        UccModifyPropGrpRspBO rspBO = new UccModifyPropGrpRspBO();
        if (reqBO.getCommodityPropGrpId() == null || reqBO.getCommodityPropGrpId() == 0L) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4ID \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccCommodityPropGrpPo po = this.uccCommodityPropGrpMapper.queryGroupByGrpId(reqBO.getCommodityPropGrpId());
        if (po == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5c5e\u6027\u7ec4ID");
            return rspBO;
        }
        if (!this.isChange(po, reqBO)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6570\u636e\u65e0\u66f4\u6539\uff0c\u65e0\u9700\u66f4\u65b0");
            return rspBO;
        }
        String errMsg = this.enumVerify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccSpuSpecPo uccSpuSpecPo = new UccSpuSpecPo();
        uccSpuSpecPo.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
        List uccSpuSpecPoList = this.uccSpuSpecMapper.querySpec(uccSpuSpecPo);
        if (uccSpuSpecPoList != null && !uccSpuSpecPoList.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u5df2\u88ab\u5546\u54c1\u5b9e\u4f8b\u5316\uff0c\u4e0d\u80fd\u4fee\u6539");
            return rspBO;
        }
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
        List uccSkuSpecPoList = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
        if (uccSkuSpecPoList != null && !uccSkuSpecPoList.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u5df2\u88ab\u5355\u54c1\u5b9e\u4f8b\u5316\uff0c\u4e0d\u80fd\u4fee\u6539");
            return rspBO;
        }
        po = new UccCommodityPropGrpPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setUpdateOperId(reqBO.getUsername());
        try {
            this.uccCommodityPropGrpMapper.modifyGroup(po);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5c5e\u6027\u7ec4\u5931\u8d25" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u66f4\u65b0\u5c5e\u6027\u7ec4\u5931\u8d25" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }

    private boolean isChange(UccCommodityPropGrpPo po, UccModifyPropGrpReqBO reqBO) {
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpCode()) && !reqBO.getCommodityPropGrpCode().equals(po.getCommodityPropGrpCode())) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpName()) && !reqBO.getCommodityPropGrpName().equals(po.getCommodityPropGrpName())) {
            return true;
        }
        if (reqBO.getPropGrpStatus() != null && reqBO.getPropGrpStatus().compareTo(po.getPropGrpStatus()) != 0) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getRemark()) && !reqBO.getRemark().equals(po.getRemark())) {
            return true;
        }
        if (reqBO.getCommodityPropGrpType() != null && !reqBO.getCommodityPropGrpType().equals(po.getCommodityPropGrpType())) {
            return true;
        }
        return !StringUtils.isEmpty((CharSequence)reqBO.getUpdateOperId()) && !reqBO.getUpdateOperId().equals(po.getUpdateOperId());
    }

    private String enumVerify(UccModifyPropGrpReqBO reqBO) {
        String errMsg = "";
        Map map = null;
        if (reqBO.getPropGrpStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_STATUS.toString())).containsKey(reqBO.getPropGrpStatus().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        return errMsg;
    }
}

