/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccQuantityTemplateUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccQuantityTemplateUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccQuantityTemplateUpdateBusiRspBO;
import com.tydic.commodity.dao.UccCommodityTemplateMapper;
import com.tydic.commodity.dao.UccTemplateAppMapper;
import com.tydic.commodity.dao.UccTemplateFieldMapper;
import com.tydic.commodity.po.UccCommodityTemplatePO;
import com.tydic.commodity.po.UccTemplateAppPO;
import com.tydic.commodity.po.UccTemplateFieldPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccQuantityTemplateUpdateBusiServiceImpl
implements UccQuantityTemplateUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccQuantityTemplateUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommodityTemplateMapper uccCommodityTemplateMapper;
    @Autowired
    private UccTemplateFieldMapper uccTemplateFieldMapper;
    @Autowired
    private UccTemplateAppMapper uccTemplateAppMapper;

    @Override
    public UccQuantityTemplateUpdateBusiRspBO updateOrAddTemplate(UccQuantityTemplateUpdateBusiReqBO reqBO) {
        if (!ObjectUtils.isEmpty((Object)reqBO.getTemId())) {
            this.update(reqBO);
        } else {
            this.add(reqBO);
        }
        UccQuantityTemplateUpdateBusiRspBO rspBO = new UccQuantityTemplateUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void add(UccQuantityTemplateUpdateBusiReqBO reqBO) {
        UccCommodityTemplatePO insertPo = new UccCommodityTemplatePO();
        Long temId = Sequence.getInstance().nextId();
        insertPo.setTemId(temId);
        insertPo.setTemName(reqBO.getTemName());
        insertPo.setTemState(UccConstants.Status.VALID);
        insertPo.setTemCode(temId.toString());
        insertPo.setTemType(reqBO.getTemType());
        insertPo.setCreateOperId(reqBO.getUserId().toString());
        insertPo.setCreateTime(new Date());
        insertPo.setCreateOperName(reqBO.getUsername());
        insertPo.setUpdateTime(new Date());
        insertPo.setUpdateOperId(reqBO.getUserId().toString());
        insertPo.setUpdateOperName(reqBO.getUsername());
        UccTemplateAppPO appPO = new UccTemplateAppPO();
        Long appId = Sequence.getInstance().nextId();
        appPO.setTemId(temId);
        appPO.setId(appId);
        appPO.setAppCode(appId.toString());
        appPO.setCreateTime(new Date());
        appPO.setCreateOperId(reqBO.getUserId().toString());
        appPO.setCreateOperName(reqBO.getUsername());
        appPO.setAppState(UccConstants.Status.VALID);
        ArrayList batchList = new ArrayList();
        reqBO.getFieldList().stream().map(e -> {
            UccTemplateFieldPO uccTemplateFieldPO = (UccTemplateFieldPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccTemplateFieldPO.class);
            uccTemplateFieldPO.setCreateOperId(reqBO.getUserId().toString());
            uccTemplateFieldPO.setCreateOperName(reqBO.getUsername());
            uccTemplateFieldPO.setCreateTime(new Date());
            uccTemplateFieldPO.setTemFieldId(Long.valueOf(Sequence.getInstance().nextId()));
            return uccTemplateFieldPO;
        }).collect(Collectors.toList());
        try {
            this.uccCommodityTemplateMapper.insert(insertPo);
            this.uccTemplateAppMapper.insert(appPO);
            this.uccTemplateFieldMapper.insertBatch(batchList);
        }
        catch (Exception e2) {
            log.error("\u65b0\u589e\u5f02\u5e38\uff1a" + e2.getMessage());
            throw new BusinessException("8888", "\u65b0\u589e\u5f02\u5e38\uff1a" + e2.getMessage());
        }
    }

    private void update(UccQuantityTemplateUpdateBusiReqBO reqBO) {
        UccCommodityTemplatePO temSet = new UccCommodityTemplatePO();
        UccCommodityTemplatePO temWhere = new UccCommodityTemplatePO();
        List<Object> fieldSetList = new ArrayList();
        UccTemplateFieldPO fieldDelPo = new UccTemplateFieldPO();
        UccTemplateAppPO appSet = new UccTemplateAppPO();
        UccTemplateAppPO appWhere = new UccTemplateAppPO();
        temSet.setTemName(reqBO.getTemName());
        temSet.setUpdateOperId(reqBO.getUserId().toString());
        temSet.setUpdateOperName(reqBO.getUsername());
        temSet.setUpdateTime(new Date());
        temWhere.setTemId(reqBO.getTemId());
        fieldDelPo.setTemId(reqBO.getTemId());
        fieldSetList = reqBO.getFieldList().stream().map(o -> {
            UccTemplateFieldPO uccTemplateFieldPO = (UccTemplateFieldPO)JSONObject.parseObject((String)JSON.toJSONString((Object)o), UccTemplateFieldPO.class);
            uccTemplateFieldPO.setTemId(Long.valueOf(Sequence.getInstance().nextId()));
            uccTemplateFieldPO.setCreateOperId(reqBO.getUserId().toString());
            uccTemplateFieldPO.setCreateOperName(reqBO.getUsername());
            uccTemplateFieldPO.setCreateTime(new Date());
            return uccTemplateFieldPO;
        }).collect(Collectors.toList());
        appSet.setAppCode(reqBO.getCommodityTypeId().toString());
        appWhere.setTemId(reqBO.getTemId());
        try {
            this.uccCommodityTemplateMapper.updateBy(temSet, temWhere);
            this.uccTemplateFieldMapper.deleteBy(fieldDelPo);
            this.uccTemplateFieldMapper.insertBatch(fieldSetList);
            this.uccTemplateAppMapper.updateBy(appSet, appWhere);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6a21\u677f\u5b57\u6bb5\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fee\u6539\u6a21\u677f\u5b57\u6bb5\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

