/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccRetroactiveRestrictionUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccRetroactiveRestrictionUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccRetroactiveRestrictionUpdateBusiRspBO;
import com.tydic.commodity.dao.UccSourceLimitConfigMapper;
import com.tydic.commodity.dao.UccSourceLimitExamMapper;
import com.tydic.commodity.po.UccSourceLimitConfigPO;
import com.tydic.commodity.po.UccSourceLimitExamPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccRetroactiveRestrictionUpdateBusiServiceImpl
implements UccRetroactiveRestrictionUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccRetroactiveRestrictionUpdateBusiServiceImpl.class);
    @Autowired
    private UccSourceLimitConfigMapper uccSourceLimitConfigMapper;
    @Autowired
    private UccSourceLimitExamMapper uccSourceLimitExamMapper;

    @Override
    public UccRetroactiveRestrictionUpdateBusiRspBO updateRetroactiveRestriction(UccRetroactiveRestrictionUpdateBusiReqBO reqBO) {
        UccRetroactiveRestrictionUpdateBusiRspBO rspBO = new UccRetroactiveRestrictionUpdateBusiRspBO();
        if (UccConstants.IsOption.ADD.equals(reqBO.getOption())) {
            this.addUccSourceLimitConfig(reqBO);
        } else if (UccConstants.IsOption.UPDATE.equals(reqBO.getOption())) {
            this.updateUccSourceLimitConfig(reqBO);
        } else if (UccConstants.IsOption.DELETE.equals(reqBO.getOption())) {
            this.deleteUccSourceLimitConfig(reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void deleteUccSourceLimitConfig(UccRetroactiveRestrictionUpdateBusiReqBO reqBO) {
        try {
            UccSourceLimitConfigPO uccSourceLimitConfigPO = new UccSourceLimitConfigPO();
            uccSourceLimitConfigPO.setDeleteIdList(reqBO.getDeleteIdList());
            int isDelete = this.uccSourceLimitConfigMapper.deleteByCondition(uccSourceLimitConfigPO);
            if (isDelete != reqBO.getDeleteIdList().size()) {
                throw new BusinessException("\u5931\u8d25", "\u5220\u9664\u8ffd\u6eaf\u4fe1\u606f\u5931\u8d25\uff01");
            }
            UccSourceLimitExamPO deleteData = new UccSourceLimitExamPO();
            deleteData.setDeleteIdList(reqBO.getDeleteIdList());
            this.uccSourceLimitExamMapper.deleteByCondition(deleteData);
        }
        catch (Exception e) {
            throw new BusinessException("\u5931\u8d25", "\u5220\u9664\u8ffd\u6eaf\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void updateUccSourceLimitConfig(UccRetroactiveRestrictionUpdateBusiReqBO reqBO) {
        UccSourceLimitConfigPO uccSourceLimitConfigPO = this.uccSourceLimitConfigMapper.queryById(reqBO.getSourceLimitId());
        if (uccSourceLimitConfigPO == null) {
            throw new BusinessException("\u5931\u8d25", "\u8be5\u8ffd\u6eaf\u4fe1\u606f\u5728\u8868\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        UccSourceLimitConfigPO updateData = new UccSourceLimitConfigPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateData);
        updateData.setSourceLimitId(reqBO.getSourceLimitId());
        updateData.setUpdateId(reqBO.getUserId());
        updateData.setUpdateName(reqBO.getUserName());
        updateData.setUpdateTime(new Date());
        int isUpdate = this.uccSourceLimitConfigMapper.update(updateData);
        if (isUpdate < 1) {
            throw new BusinessException("\u5931\u8d25", "\u4fee\u6539\u8ffd\u6eaf\u4fe1\u606f\u9650\u5236\u914d\u7f6e\u5931\u8d25\uff01");
        }
        try {
            UccSourceLimitExamPO deleteData = new UccSourceLimitExamPO();
            deleteData.setSourceLimitId(reqBO.getSourceLimitId());
            this.uccSourceLimitExamMapper.deleteByCondition(deleteData);
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u5220\u9664\u5b50\u8868\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u5931\u8d25", "\u4fee\u6539\u8ffd\u6eaf\u4fe1\u606f\u9650\u5236\u914d\u7f6e\u5931\u8d25\uff01");
        }
        this.addUccSourceLimitExamPO(reqBO, reqBO.getSourceLimitId());
    }

    private void addUccSourceLimitConfig(UccRetroactiveRestrictionUpdateBusiReqBO reqBO) {
        UccSourceLimitConfigPO uccSourceLimitConfigPO = new UccSourceLimitConfigPO();
        Long sourceLimitId = Sequence.getInstance().nextId();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccSourceLimitConfigPO);
        uccSourceLimitConfigPO.setSourceLimitId(sourceLimitId);
        uccSourceLimitConfigPO.setCreateId(reqBO.getUserId());
        uccSourceLimitConfigPO.setCreateName(reqBO.getUserName());
        uccSourceLimitConfigPO.setCreateTime(new Date());
        int isInsert = this.uccSourceLimitConfigMapper.insert(uccSourceLimitConfigPO);
        if (isInsert < 1) {
            throw new BusinessException("\u5931\u8d25", "\u65b0\u589e\u8ffd\u6eaf\u4fe1\u606f\u9650\u5236\u914d\u7f6e\u5931\u8d25\uff01");
        }
        this.addUccSourceLimitExamPO(reqBO, sourceLimitId);
    }

    private void addUccSourceLimitExamPO(UccRetroactiveRestrictionUpdateBusiReqBO reqBO, Long sourceLimitId) {
        ArrayList uccSourceLimitExamPOS = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getRetroactiveRetrictionBos())) {
            reqBO.getRetroactiveRetrictionBos().forEach(each -> {
                UccSourceLimitExamPO uccSourceLimitExamPO = new UccSourceLimitExamPO();
                Long id = Sequence.getInstance().nextId();
                uccSourceLimitExamPO.setId(id);
                uccSourceLimitExamPO.setSourceLimitId(sourceLimitId);
                uccSourceLimitExamPO.setTargetCode(each);
                uccSourceLimitExamPOS.add(uccSourceLimitExamPO);
            });
            int isInsertBatch = this.uccSourceLimitExamMapper.insertBatch(uccSourceLimitExamPOS);
            if (isInsertBatch != uccSourceLimitExamPOS.size()) {
                throw new BusinessException("\u5931\u8d25", "\u65b0\u589e\u8ffd\u6eaf\u4fe1\u606f\u9650\u5236\u914d\u7f6e\u5931\u8d25\uff01");
            }
        }
    }
}

