/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.bo.UccBulkPricingExcelBO;
import com.tydic.commodity.common.busi.api.UccBatchAdjustBusiService;
import com.tydic.commodity.common.busi.api.UccSupplierImportBatchAdjustBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchAdjustBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchAdjustBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccSupplierImportBatchAdjustBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSupplierImportBatchAdjustBusiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccSupplierImportBatchAdjustBusiServiceImpl
implements UccSupplierImportBatchAdjustBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSupplierImportBatchAdjustBusiServiceImpl.class);
    @Autowired
    private UccBatchAdjustBusiService uccBatchAdjustBusiService;

    @Override
    public UccSupplierImportBatchAdjustBusiRspBO importSupplierBatchAdjust(UccSupplierImportBatchAdjustBusiReqBO reqBO) {
        UccSupplierImportBatchAdjustBusiRspBO rspBO = new UccSupplierImportBatchAdjustBusiRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new ZTBusinessException("url\u4e3a\u7a7a");
        }
        String url = reqBO.getUrl();
        List<UccBulkPricingExcelBO> uccBulkPricingExcelBOList = this.getCommodityBOList(url);
        if (!CollectionUtils.isEmpty(uccBulkPricingExcelBOList)) {
            for (UccBulkPricingExcelBO bo : uccBulkPricingExcelBOList) {
                UccBatchAdjustBusiReqBO busiReqBO = new UccBatchAdjustBusiReqBO();
                Long modifyPrice = new BigDecimal(bo.getAfterPrice()).multiply(new BigDecimal("10000")).longValue();
                busiReqBO.setModifyPrice(modifyPrice);
                busiReqBO.setAdjustOperType(UccConstants.UccAdjustOperType.MODIFY_PRICE);
                ArrayList<String> skuCodeList = new ArrayList<String>();
                skuCodeList.add(bo.getSkuCode());
                busiReqBO.setSkuCodeList(skuCodeList);
                busiReqBO.setIsFirst(false);
                UccBatchAdjustBusiRspBO busiRspBO = this.uccBatchAdjustBusiService.batchAdjust(busiReqBO);
                if ("0000".equals(busiRspBO.getRespCode())) continue;
                throw new ZTBusinessException("\u5e8f\u53f7\uff1a" + bo.getSerialNum() + " \u8c03\u4ef7\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u5165\u8c03\u4ef7\u6210\u529f");
        return rspBO;
    }

    private List<UccBulkPricingExcelBO> getCommodityBOList(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccBulkPricingExcelBO> uccBulkPricingExcelBOList = new ArrayList<UccBulkPricingExcelBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccBulkPricingExcelBO uccBulkPricingExcelBO = new UccBulkPricingExcelBO();
                    int i = 0;
                    String serialNum = (String)list.get(i++);
                    uccBulkPricingExcelBO.setSerialNum(Integer.valueOf(serialNum));
                    String skuName = (String)list.get(i++);
                    uccBulkPricingExcelBO.setSkuName(skuName);
                    String skuCode = (String)list.get(i++);
                    uccBulkPricingExcelBO.setSkuCode(skuCode);
                    String erpSkuShape = (String)list.get(i++);
                    uccBulkPricingExcelBO.setErpSkuShapeStr(erpSkuShape);
                    String afterPriceString = (String)list.get(i++);
                    uccBulkPricingExcelBO.setAfterPrice(afterPriceString);
                    String commodityTypeStr = (String)list.get(i++);
                    uccBulkPricingExcelBO.setCommodityTypeStr(commodityTypeStr);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return uccBulkPricingExcelBOList;
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u5904\u7406Excel\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

