/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccChannelAddReqBO;
import com.tydic.commodity.common.ability.bo.UccChannelAddRspBO;
import com.tydic.commodity.common.atom.api.UccGetSortSeqAtomService;
import com.tydic.commodity.common.atom.bo.UccGetSortSeqAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccGetSortSeqAtomRspBO;
import com.tydic.commodity.common.busi.api.UccUccChannelAddBusiService;
import com.tydic.commodity.dao.UccChannelAppTypeMapper;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.po.UccChannelAppTypePO;
import com.tydic.commodity.po.UccChannelPO;
import java.util.ArrayList;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccUccChannelAddBusiServiceImpl
implements UccUccChannelAddBusiService {
    @Autowired
    private UccGetSortSeqAtomService uccGetSortSeqAtomService;
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Autowired
    private UccChannelAppTypeMapper uccChannelAppTypeMapper;
    private Sequence uccChannelSequence = Sequence.getInstance();

    @Override
    public UccChannelAddRspBO addChannel(UccChannelAddReqBO reqBO) {
        UccChannelAddRspBO rspBO = new UccChannelAddRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getChannelName())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9891\u9053\u540d\u79f0\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            Integer count = this.uccChannelMapper.selectCountByCodeName(reqBO.getChannelName(), reqBO.getChannelCode());
            if (count > 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u9891\u9053\u7f16\u7801\u6216\u540d\u79f0\u5df2\u5b58\u5728");
                return rspBO;
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        int result = 0;
        UccChannelPO uccChannelPO = this.createUccChannelPO(reqBO);
        UccGetSortSeqAtomReqBO GetSortSeqAtomReqBO = new UccGetSortSeqAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)GetSortSeqAtomReqBO);
        GetSortSeqAtomReqBO.setObjType(1);
        GetSortSeqAtomReqBO.setSeqId(reqBO.getViewOrder());
        UccGetSortSeqAtomRspBO uccGetSortSeqAtomRspBO = null;
        try {
            uccGetSortSeqAtomRspBO = this.uccGetSortSeqAtomService.getSeq(GetSortSeqAtomReqBO);
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
        }
        uccChannelPO.setViewOrder(uccGetSortSeqAtomRspBO.getSeqId());
        try {
            result = this.uccChannelMapper.insert(uccChannelPO);
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
        }
        ArrayList<UccChannelAppTypePO> uccChannelAppTypePOs = new ArrayList<UccChannelAppTypePO>();
        for (Integer sceneId : reqBO.getSceneIds()) {
            UccChannelAppTypePO uccChannelAppTypePO = new UccChannelAppTypePO();
            uccChannelAppTypePO.setChannelId(uccChannelPO.getChannelId());
            uccChannelAppTypePO.setAppTypes(sceneId);
            uccChannelAppTypePOs.add(uccChannelAppTypePO);
        }
        try {
            result = this.uccChannelAppTypeMapper.batchInsert(uccChannelAppTypePOs);
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SYSTEM_EXCEPTION.code(), e.getMessage());
        }
        rspBO.setChannelId(uccChannelPO.getChannelId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccChannelPO createUccChannelPO(UccChannelAddReqBO reqBO) {
        UccChannelPO uccChannelPO = new UccChannelPO();
        uccChannelPO.setChannelId(Long.valueOf(this.uccChannelSequence.nextId()));
        uccChannelPO.setChannelCode(reqBO.getChannelCode());
        uccChannelPO.setChannelName(reqBO.getChannelName());
        uccChannelPO.setChannelStatus(reqBO.getChannelStatus());
        uccChannelPO.setCreateOperId(reqBO.getCreateOperId());
        uccChannelPO.setRemark(reqBO.getRemark());
        uccChannelPO.setType(reqBO.getType());
        uccChannelPO.setRelatedType(reqBO.getRelatedType());
        uccChannelPO.setCreateOperId(reqBO.getUsername());
        return uccChannelPO;
    }
}

