/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.DaYaoUccCommodityTypeListAbilityService;
import com.tydic.commodity.common.ability.bo.DaYaoUccCommodityTypeListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.DaYaoUccCommodityTypeListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeBO;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.umc.supplier.ability.api.DycUmcSupplierGetSignedItemCatAbilityService;
import com.tydic.umc.supplier.ability.bo.DycUmcSupplierGetSignedItemCatAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.DycUmcSupplierGetSignedItemCatAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.DaYaoUccCommodityTypeListAbilityService"})
public class DaYaoUccCommodityTypeListAbilityServiceImpl
implements DaYaoUccCommodityTypeListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DaYaoUccCommodityTypeListAbilityServiceImpl.class);
    @Autowired
    private DycUmcSupplierGetSignedItemCatAbilityService dycUmcSupplierGetSignedItemCatAbilityService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"commodityTypeList"})
    public DaYaoUccCommodityTypeListAbilityRspBO commodityTypeList(@RequestBody DaYaoUccCommodityTypeListAbilityReqBO reqBO) {
        this.validate(reqBO);
        DaYaoUccCommodityTypeListAbilityRspBO rspBO = new DaYaoUccCommodityTypeListAbilityRspBO();
        rspBO.setRespCode("0000");
        DycUmcSupplierGetSignedItemCatAbilityReqBO umcSupplierGetSignedItemCatAbilityReqBO = new DycUmcSupplierGetSignedItemCatAbilityReqBO();
        umcSupplierGetSignedItemCatAbilityReqBO.setOrgIdWeb(reqBO.getSupplierId());
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3dycUmcSupplierGetSignedItemCatAbilityService\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcSupplierGetSignedItemCatAbilityReqBO));
        DycUmcSupplierGetSignedItemCatAbilityRspBO signedItemList = this.dycUmcSupplierGetSignedItemCatAbilityService.getSignedItemList(umcSupplierGetSignedItemCatAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3dycUmcSupplierGetSignedItemCatAbilityService\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)signedItemList));
        if (CollectionUtils.isEmpty((Collection)signedItemList.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u4f1a\u5458\u7b7e\u7ea6\u5355\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List collectCommodityIds = signedItemList.getRows().stream().map(e -> e.getItemCatId()).collect(Collectors.toList());
        List commodityTypePOS = this.uccCommodityTypeMapper.qryByCatalogId(reqBO.getGuideCatalogId());
        if (CollectionUtils.isEmpty((Collection)commodityTypePOS)) {
            rspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u7a7a\uff01");
            return rspBO;
        }
        ArrayList uccCommodityTypeBOS = new ArrayList();
        commodityTypePOS.forEach(e -> {
            if (collectCommodityIds.contains(e.getCommodityTypeId())) {
                UccCommodityTypeBO uccCommodityTypeBO = (UccCommodityTypeBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCommodityTypeBO.class);
                uccCommodityTypeBOS.add(uccCommodityTypeBO);
            }
        });
        if (CollectionUtils.isEmpty(uccCommodityTypeBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546id\u4e3a" + reqBO.getSupplierId() + ",\u4e09\u7ea7\u7c7b\u76ee\u4e3a" + reqBO.getGuideCatalogId() + "\u7684\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        rspBO.setUccCommodityTypeBOS(uccCommodityTypeBOS);
        return rspBO;
    }

    private void validate(DaYaoUccCommodityTypeListAbilityReqBO reqBO) {
        if (reqBO.getGuideCatalogId() == null) {
            throw new BusinessException("8888", "\u53c2\u6570 guideCatalogId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new BusinessException("8888", "\u53c2\u6570 supplierId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

