/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCommodityTemplateListAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommodityTemplateListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCommodityTemplateListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccCommodityTemplateListBo;
import com.tydic.commodity.dao.UccCommodityTemplateMapper;
import com.tydic.commodity.po.UccCommodityTemplatePO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityTemplateListAbilityService"})
public class UccCommodityTemplateListAbilityServiceImpl
implements UccCommodityTemplateListAbilityService {
    @Autowired
    private UccCommodityTemplateMapper uccCommodityTemplateMapper;

    @PostMapping(value={"commodityTemplateList"})
    public UccCommodityTemplateListAbilityRspBO commodityTemplateList(@RequestBody UccCommodityTemplateListAbilityReqBO reqBO) {
        UccCommodityTemplateListAbilityRspBO rspBO = new UccCommodityTemplateListAbilityRspBO();
        this.validate(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCommodityTemplatePO selectPO = new UccCommodityTemplatePO();
        selectPO.setTemType(reqBO.getTemplateOption());
        selectPO.setTemState(UccConstants.Status.VALID);
        List listPage = this.uccCommodityTemplateMapper.getListJoinDetailPage(selectPO, page);
        if (!CollectionUtils.isEmpty((Collection)listPage)) {
            List collect = listPage.stream().map(o -> {
                UccCommodityTemplateListBo uccCommodityTemplateListBo = (UccCommodityTemplateListBo)JSONObject.parseObject((String)JSON.toJSONString((Object)o), UccCommodityTemplateListBo.class);
                uccCommodityTemplateListBo.setAppTypeCode(o.getAppCode());
                return uccCommodityTemplateListBo;
            }).collect(Collectors.toList());
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setRows(collect);
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void validate(UccCommodityTemplateListAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getTemplateOption())) {
            throw new BusinessException("8888", "\u53c2\u6570 templateOption \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

