/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccSkuPoolRelDataQryListAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityRspBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityOrderPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolRelDataQryListAbilityService"})
public class UccSkuPoolRelDataQryListAbilityServiceImpl
implements UccSkuPoolRelDataQryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolRelDataQryListAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"qrySkuPoolRelDataList"})
    public UccSkuPoolRelDataQryListAbilityRspBo qrySkuPoolRelDataList(@RequestBody UccSkuPoolRelDataQryListAbilityReqBo reqBo) {
        UccSkuPoolRelDataQryListAbilityRspBo rspBo = new UccSkuPoolRelDataQryListAbilityRspBo();
        if (reqBo.getPoolId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u8f93\u5165\u5546\u54c1\u6c60ID");
            return rspBo;
        }
        UccCommodityPoolPO uccCommodityPoolPO = this.uccCommodityPoolMapper.selectByPrimaryKey(reqBo.getPoolId());
        if (uccCommodityPoolPO != null) {
            rspBo.setRelSkuType(uccCommodityPoolPO.getPoolRelated());
        }
        UccRelPoolCommodityOrderPo uccRelPoolCommodityOrderPo = new UccRelPoolCommodityOrderPo();
        uccRelPoolCommodityOrderPo.setPoolId(reqBo.getPoolId());
        uccRelPoolCommodityOrderPo.setPoolRelated(uccCommodityPoolPO.getPoolRelated());
        uccRelPoolCommodityOrderPo.setCommodityCode(reqBo.getCommodityCode());
        uccRelPoolCommodityOrderPo.setCommodityName(reqBo.getCommodityName());
        uccRelPoolCommodityOrderPo.setCommodityTypeId(reqBo.getCommodityTypeId());
        uccRelPoolCommodityOrderPo.setSupplierShopId(reqBo.getSupplierShopId());
        uccRelPoolCommodityOrderPo.setFreeLocation(reqBo.getFreeLocation());
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List rspPo = new ArrayList();
        if (uccCommodityPoolPO.getPoolRelated() != null && uccCommodityPoolPO.getPoolRelated() == 1) {
            rspPo = this.uccRelPoolCommodityMapper.queryPoolRelCommodityByType(uccRelPoolCommodityOrderPo, page);
        }
        if (uccCommodityPoolPO.getPoolRelated() != null && uccCommodityPoolPO.getPoolRelated() == 5) {
            if (reqBo.getCommodityFrom() != null && reqBo.getCommodityFrom() > 3) {
                uccRelPoolCommodityOrderPo.setSkuFrom(Integer.valueOf(reqBo.getCommodityFrom() - 4));
                uccRelPoolCommodityOrderPo.setSkuClass(Integer.valueOf(1));
            } else if (reqBo.getCommodityFrom() != null && reqBo.getCommodityFrom() <= 3) {
                uccRelPoolCommodityOrderPo.setSkuFrom(reqBo.getCommodityFrom());
                uccRelPoolCommodityOrderPo.setSkuClass(Integer.valueOf(0));
            }
            rspPo = this.uccRelPoolCommodityMapper.queryPoolRelCommodityByComm(uccRelPoolCommodityOrderPo, page);
        }
        if (uccCommodityPoolPO.getPoolRelated() != null && uccCommodityPoolPO.getPoolRelated() == 6) {
            rspPo = this.uccRelPoolCommodityMapper.queryPoolRelCommodityBySup(uccRelPoolCommodityOrderPo, page);
        }
        if (CollectionUtils.isEmpty(rspPo)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        Map<String, String> skuFormPoolMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_SKU_FORM_POOL");
        ArrayList<UccSkuPoolRelDataQryListAbilityBo> rows = new ArrayList<UccSkuPoolRelDataQryListAbilityBo>();
        if (!CollectionUtils.isEmpty(rspPo)) {
            for (UccRelPoolCommodityOrderPo po : rspPo) {
                UccSkuPoolRelDataQryListAbilityBo bo = new UccSkuPoolRelDataQryListAbilityBo();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bo.setSupplierShopName(po.getShopName());
                System.out.println(po.getCommodityFrom());
                if (!StringUtils.isEmpty((Object)po.getCommodityFrom())) {
                    StringBuilder commodityFrom = new StringBuilder();
                    for (int i = 0; i < po.getCommodityFrom().length(); ++i) {
                        int skuForm = Integer.parseInt(String.valueOf(po.getCommodityFrom().charAt(i)));
                        if (po.getSkuClass() != null && po.getSkuClass() == 1) {
                            skuForm += 4;
                        }
                        if (!skuFormPoolMap.containsKey(String.valueOf(skuForm))) continue;
                        commodityFrom.append(skuFormPoolMap.get(String.valueOf(skuForm)) + "/");
                    }
                    System.out.println(commodityFrom);
                    String substring = commodityFrom.substring(0, commodityFrom.length() - 1);
                    bo.setCommodityFrom(substring);
                }
                bo.setCouldDelete(Integer.valueOf(1));
                if (po.getPoolRelated() != null && po.getPoolRelated().equals(rspBo.getRelSkuType())) {
                    bo.setCouldDelete(Integer.valueOf(0));
                }
                rows.add(bo);
            }
        }
        rspBo.setPoolId(reqBo.getPoolId());
        rspBo.setRows(rows);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

