/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.common.ability.api.UccSpuhasBeenapprovalListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccSpuhasbeenapprovalListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuhasbeenapprovalListQryAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccSpuHasBeenApprovalQryPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuhasBeenapprovalListQryAbilityService"})
public class UccSpuhasBeenapprovalListQryAbilityServiceImpl
implements UccSpuhasBeenapprovalListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuhasBeenapprovalListQryAbilityServiceImpl.class);
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"gethasBeenapprovalListQry"})
    public UccSpuhasbeenapprovalListQryAbilityRspBO gethasBeenapprovalListQry(@RequestBody UccSpuhasbeenapprovalListQryAbilityReqBO reqBO) {
        UccSpuhasbeenapprovalListQryAbilityRspBO rspBO = new UccSpuhasbeenapprovalListQryAbilityRspBO();
        List<Object> brands = new ArrayList();
        if (!StringUtils.isEmpty((Object)reqBO.getBrandName())) {
            List brandDealPOS = this.uccBrandDealMapper.querySpuBrandByName(reqBO.getBrandName());
            if (!CollectionUtils.isEmpty((Collection)brandDealPOS)) {
                brands = brandDealPOS.stream().map(UccBrandDealPO::getBrandId).collect(Collectors.toList());
            } else {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccSpuHasBeenApprovalQryPO uccSpuHasBeenApprovalQryPO = new UccSpuHasBeenApprovalQryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSpuHasBeenApprovalQryPO);
        uccSpuHasBeenApprovalQryPO.setCommoditySource(reqBO.getIsSelf());
        uccSpuHasBeenApprovalQryPO.setCommodityClass(reqBO.getCommodityClass());
        if (!ObjectUtils.isEmpty((Object)reqBO.getSubmitTimeEnd())) {
            uccSpuHasBeenApprovalQryPO.setUpdateTimeEnd(reqBO.getSubmitTimeEnd());
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getSubmitTimeStart())) {
            uccSpuHasBeenApprovalQryPO.setUpdateTimeStart(reqBO.getSubmitTimeStart());
        }
        List uccSpuManagementPOList = this.uccCommodityMapper.queryHasBeenApprovalSpu(uccSpuHasBeenApprovalQryPO, brands, page);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(reqBO.getPageNo());
        if (!CollectionUtils.isEmpty((Collection)uccSpuManagementPOList)) {
            List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccSpuManagementPOList), UccSpuManagementListQryBO.class);
            HashSet brandList = new HashSet();
            rows.stream().filter(a -> brandList.add(a.getBrandId()));
            Map<Long, List<UccMallBrandRelPO>> goupBrand = null;
            if (!CollectionUtils.isEmpty(brandList)) {
                List getRelByBrandList = this.uccMallBrandRelMapper.getRelByBrandList(new ArrayList(brandList));
                goupBrand = getRelByBrandList.stream().collect(Collectors.groupingBy(UccMallBrandRelPO::getBrandId));
            }
            DicDictionaryPo dicDictionaryPo = null;
            for (UccSpuManagementListQryBO each : rows) {
                if (each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getApprovalStatus().toString(), CommodityEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                    each.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getCommodityStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
                    each.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                }
                if (goupBrand == null || goupBrand.isEmpty() || !goupBrand.containsKey(each.getBrandId())) continue;
                each.setBrandId(goupBrand.get(each.getBrandId()).get(0).getMallBrandId());
                each.setBrandName(goupBrand.get(each.getBrandId()).get(0).getMallBrandName());
            }
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

