/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.UccBatchAddServicePhoneConfigDropAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchAddServicePhoneConfigDropAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccServicePhoneConfigCommodityBO;
import com.tydic.commodity.common.busi.api.UccBatchAddServicePhoneConfigDropBusiService;
import com.tydic.commodity.dao.UccServicePhoneConfParamMapper;
import com.tydic.commodity.po.UccServicePhoneConfParamPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccBatchAddServicePhoneConfigDropBusiServiceImpl
implements UccBatchAddServicePhoneConfigDropBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchAddServicePhoneConfigDropBusiServiceImpl.class);
    @Autowired
    private UccServicePhoneConfParamMapper uccServicePhoneConfParamMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccBatchAddServicePhoneConfigDropAbilityRspBO batchAddServicePhoneConf(UccBatchAddServicePhoneConfigDropAbilityReqBO reqBO) {
        UccBatchAddServicePhoneConfigDropAbilityRspBO rspBO = new UccBatchAddServicePhoneConfigDropAbilityRspBO();
        String verify = this.verify(reqBO);
        if (!StringUtils.isEmpty((Object)verify)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(verify);
            return rspBO;
        }
        if (reqBO.getOptionType() == 1) {
            return this.insertData(reqBO);
        }
        if (reqBO.getOptionType() == 2) {
            return this.updateData(reqBO);
        }
        return rspBO;
    }

    private UccBatchAddServicePhoneConfigDropAbilityRspBO updateData(UccBatchAddServicePhoneConfigDropAbilityReqBO reqBO) {
        UccBatchAddServicePhoneConfigDropAbilityRspBO rspBO1 = new UccBatchAddServicePhoneConfigDropAbilityRspBO();
        List codes = reqBO.getServicePhoneList().stream().map(e -> e.getCatagoryCode()).collect(Collectors.toList());
        List ignoreIds = reqBO.getServicePhoneList().stream().map(e -> e.getPhoneConfParamId()).collect(Collectors.toList());
        List rspPos = this.uccServicePhoneConfParamMapper.queryByCondition(reqBO.getCatagoryType(), codes, ignoreIds);
        if (!CollectionUtils.isEmpty((Collection)rspPos)) {
            rspBO1.setRespDesc("\u7c7b\u578bCode\u5df2\u7ecf\u914d\u7f6e\uff0c\u8bf7\u66f4\u6362\u7c7b\u578bCode");
            rspBO1.setRespCode("8888");
            return rspBO1;
        }
        for (UccServicePhoneConfigCommodityBO bo : reqBO.getServicePhoneList()) {
            UccServicePhoneConfParamPO queryPo = this.uccServicePhoneConfParamMapper.queryById(bo.getPhoneConfParamId());
            if (queryPo == null) {
                rspBO1.setRespDesc("\u6570\u636e\u5e93\u672a\u627e\u5230\u6570\u636e");
                rspBO1.setRespCode("8888");
                return rspBO1;
            }
            queryPo.setCatagoryType(reqBO.getCatagoryType());
            queryPo.setCatagoryCode(bo.getCatagoryCode());
            queryPo.setServicePhone(bo.getServicePhone());
            queryPo.setUpdateNo(reqBO.getUserId());
            queryPo.setUpdateName(reqBO.getUsername());
            queryPo.setUpdateTime(new Date());
            Integer i = this.uccServicePhoneConfParamMapper.updateOne(queryPo);
            if (i >= 1) continue;
            rspBO1.setRespDesc("\u4fee\u6539\u6570\u636e\u5931\u8d25");
            rspBO1.setRespCode("8888");
            return rspBO1;
        }
        rspBO1.setRespDesc("\u6210\u529f");
        rspBO1.setRespCode("0000");
        return rspBO1;
    }

    private UccBatchAddServicePhoneConfigDropAbilityRspBO insertData(UccBatchAddServicePhoneConfigDropAbilityReqBO reqBO) {
        UccBatchAddServicePhoneConfigDropAbilityRspBO rspBO1 = new UccBatchAddServicePhoneConfigDropAbilityRspBO();
        List codes = reqBO.getServicePhoneList().stream().map(e -> e.getCatagoryCode()).collect(Collectors.toList());
        List rspPos = this.uccServicePhoneConfParamMapper.queryByCondition(reqBO.getCatagoryType(), codes, null);
        if (!CollectionUtils.isEmpty((Collection)rspPos)) {
            rspBO1.setRespDesc("\u7c7b\u578bCode\u5df2\u7ecf\u914d\u7f6e\uff0c\u8bf7\u66f4\u6362\u7c7b\u578bCode");
            rspBO1.setRespCode("8888");
            return rspBO1;
        }
        List insertPos = reqBO.getServicePhoneList().stream().map(e -> {
            UccServicePhoneConfParamPO reqPo = new UccServicePhoneConfParamPO();
            reqPo.setCatagoryType(reqBO.getCatagoryType());
            reqPo.setCatagoryCode(e.getCatagoryCode());
            reqPo.setServicePhone(e.getServicePhone());
            reqPo.setPhoneConfParamId(Long.valueOf(this.sequence.nextId()));
            reqPo.setCreateNo(reqBO.getUserId());
            reqPo.setCreateName(reqBO.getUsername());
            reqPo.setCreateTime(new Date());
            reqPo.setUpdateNo(reqBO.getUserId());
            reqPo.setUpdateName(reqBO.getUsername());
            reqPo.setUpdateTime(new Date());
            reqPo.setRule(Integer.valueOf(2));
            return reqPo;
        }).collect(Collectors.toList());
        Integer i = this.uccServicePhoneConfParamMapper.insertBatch(insertPos);
        if (i < 1) {
            rspBO1.setRespDesc("\u6dfb\u52a0\u6570\u636e\u5931\u8d25");
            rspBO1.setRespCode("8888");
            return rspBO1;
        }
        rspBO1.setRespDesc("\u6210\u529f");
        rspBO1.setRespCode("0000");
        return rspBO1;
    }

    private String verify(UccBatchAddServicePhoneConfigDropAbilityReqBO reqBO) {
        if (reqBO.getOptionType() == null) {
            return "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a";
        }
        if (reqBO.getCatagoryType() == null) {
            return "\u54c1\u7c7b\u7c7b\u578b\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getServicePhoneList())) {
            return "\u914d\u7f6e\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getServicePhoneList())) {
            return "\u914d\u7f6e\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a";
        }
        for (UccServicePhoneConfigCommodityBO bo : reqBO.getServicePhoneList()) {
            if (StringUtils.isEmpty((Object)bo.getServicePhone()) || StringUtils.isEmpty((Object)bo.getCatagoryCode())) {
                return "\u914d\u7f6e\u4fe1\u606f\u4e0d\u5168";
            }
            if (reqBO.getOptionType() != 2 || bo.getPhoneConfParamId() != null) continue;
            return "\u914d\u7f6e\u4fe1\u606fid\u4e3a\u7a7a";
        }
        return null;
    }
}

