/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.atom.api.UccSignBatchAdjustLogAtomService;
import com.tydic.commodity.common.atom.bo.UccSignBatchAdjustLogAtomServiceReqBO;
import com.tydic.commodity.common.atom.bo.UccSignBatchAdjustLogAtomServiceRspBO;
import com.tydic.commodity.common.busi.api.UccBatchAdjustBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchAdjustBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchAdjustBusiRspBO;
import com.tydic.commodity.dao.ErpSkuPriceChangeMapper;
import com.tydic.commodity.dao.UccSkuAdjustPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.ErpSkuPriceChangePO;
import com.tydic.commodity.po.UccSkuAdjustPricePO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccBatchAdjustBusiServiceImpl
implements UccBatchAdjustBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchAdjustBusiServiceImpl.class);
    @Autowired
    private UccSkuAdjustPriceMapper uccSkuAdjustPriceMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSignBatchAdjustLogAtomService uccSignBatchAdjustLogAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ErpSkuPriceChangeMapper erpSkuPriceChangeMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Override
    public UccBatchAdjustBusiRspBO batchAdjust(UccBatchAdjustBusiReqBO reqBO) {
        Boolean isFirstAdjust = reqBO.getIsFirst();
        Long skuId = null;
        Long supplierId = null;
        UccBatchAdjustBusiRspBO rspBO = new UccBatchAdjustBusiRspBO();
        ArrayList<UccSkuAdjustPricePO> uccSkuAdjustPricePOList = new ArrayList<UccSkuAdjustPricePO>();
        for (String skuCode : reqBO.getSkuCodeList()) {
            Long afterPrice;
            if (isFirstAdjust.booleanValue()) {
                this.check(reqBO);
                skuId = reqBO.getSkuId();
                UccSkuAdjustPricePO insertUccSkuAdjustPricePO = new UccSkuAdjustPricePO();
                insertUccSkuAdjustPricePO.setSkuId(skuId);
                insertUccSkuAdjustPricePO.setSkuCode(skuCode);
                insertUccSkuAdjustPricePO.setCommodityId(reqBO.getCommodityId());
                insertUccSkuAdjustPricePO.setSupplierShopId(reqBO.getSupplierShopId());
                insertUccSkuAdjustPricePO.setBeforePride(Long.valueOf(reqBO.getBeforePride().multiply(new BigDecimal("10000")).longValue()));
                if (!UccConstants.UccAdjustOperType.MODIFY_PRICE.equals(reqBO.getAdjustOperType())) {
                    throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[adjustOperType]\u9519\u8bef\u5165\u53c2\uff01");
                }
                insertUccSkuAdjustPricePO.setAfterPrice(Long.valueOf(reqBO.getAfterPrice().multiply(new BigDecimal("10000")).longValue()));
                long quota = insertUccSkuAdjustPricePO.getAfterPrice() - insertUccSkuAdjustPricePO.getBeforePride();
                insertUccSkuAdjustPricePO.setAdjustQuota(Long.valueOf(quota));
                BigDecimal ratio = BigDecimal.valueOf(quota).divide(BigDecimal.valueOf(insertUccSkuAdjustPricePO.getBeforePride()), 2, 4);
                insertUccSkuAdjustPricePO.setAdjustRatio(ratio);
                insertUccSkuAdjustPricePO.setAdjustType(UccConstants.UccAdjustType.MALL_ADJUST);
                insertUccSkuAdjustPricePO.setAdjustTime(new Date());
                insertUccSkuAdjustPricePO.setOperName(reqBO.getName());
                int i = this.uccSkuAdjustPriceMapper.insert(insertUccSkuAdjustPricePO);
                if (i != 1) {
                    throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u63d2\u5165\u6b64skuId:" + skuId + "\u7684\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f\u5931\u8d25");
                }
                if (UccConstants.CommoditySourceEnum.SELF.getKey().equals(reqBO.getSkuSource())) {
                    ErpSkuPriceChangePO erpSkuPriceChangePO = new ErpSkuPriceChangePO();
                    erpSkuPriceChangePO.setSkuId(reqBO.getSkuId());
                    erpSkuPriceChangePO.setSkuCode(skuCode);
                    erpSkuPriceChangePO.setErpSkuCode(reqBO.getErpSkuCode());
                    erpSkuPriceChangePO.setErpSkuShape(reqBO.getSkuForm().toString());
                    erpSkuPriceChangePO.setProductLevel(reqBO.getProductLevel());
                    erpSkuPriceChangePO.setErpQuota(insertUccSkuAdjustPricePO.getAdjustQuota());
                    erpSkuPriceChangePO.setMarketPrice(insertUccSkuAdjustPricePO.getBeforePride());
                    erpSkuPriceChangePO.setChangeTime(new Date());
                    int j = this.erpSkuPriceChangeMapper.insert(erpSkuPriceChangePO);
                    if (j != 1) {
                        throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u63d2\u5165\u6b64skuId:" + skuId + "\u7684erp\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f\u5931\u8d25");
                    }
                }
                uccSkuAdjustPricePOList.add(insertUccSkuAdjustPricePO);
                continue;
            }
            UccSkuAdjustPricePO modelPO = new UccSkuAdjustPricePO();
            modelPO.setSkuCode(skuCode);
            UccSkuAdjustPricePO uccSkuAdjustPricePO = this.uccSkuAdjustPriceMapper.getModelBy(modelPO);
            if (uccSkuAdjustPricePO == null) {
                throw new ZTBusinessException("\u5546\u57ce\u6279\u91cf\u8c03\u4ef7\u5f02\u5e38\uff0c\u65e0\u6b64skuId:" + skuId + "\u7684\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f");
            }
            skuId = uccSkuAdjustPricePO.getSkuId();
            supplierId = uccSkuAdjustPricePO.getSupplierShopId();
            uccSkuAdjustPricePO.setBeforePride(uccSkuAdjustPricePO.getAfterPrice());
            if (UccConstants.UccAdjustOperType.QUOTA.equals(reqBO.getAdjustOperType())) {
                long adjustQuota = reqBO.getAdjustQuota().multiply(new BigDecimal("10000")).longValue();
                uccSkuAdjustPricePO.setAdjustQuota(Long.valueOf(adjustQuota));
                uccSkuAdjustPricePO.setAfterPrice(Long.valueOf(uccSkuAdjustPricePO.getAfterPrice() + adjustQuota));
                BigDecimal ratio = BigDecimal.valueOf(adjustQuota).divide(BigDecimal.valueOf(uccSkuAdjustPricePO.getBeforePride()), 2, 4);
                uccSkuAdjustPricePO.setAdjustRatio(ratio);
            } else if (UccConstants.UccAdjustOperType.RATIO.equals(reqBO.getAdjustOperType())) {
                uccSkuAdjustPricePO.setAdjustRatio(reqBO.getAdjustRatio());
                afterPrice = uccSkuAdjustPricePO.getAfterPrice() + BigDecimal.valueOf(uccSkuAdjustPricePO.getAfterPrice()).multiply(reqBO.getAdjustRatio()).longValue();
                uccSkuAdjustPricePO.setAfterPrice(afterPrice);
                Long quota = uccSkuAdjustPricePO.getAfterPrice() - uccSkuAdjustPricePO.getBeforePride();
                uccSkuAdjustPricePO.setAdjustQuota(quota);
            } else {
                afterPrice = reqBO.getAfterPrice().multiply(new BigDecimal("10000")).longValue();
                uccSkuAdjustPricePO.setAfterPrice(afterPrice);
                long quota = uccSkuAdjustPricePO.getAfterPrice() - uccSkuAdjustPricePO.getBeforePride();
                uccSkuAdjustPricePO.setAdjustQuota(Long.valueOf(quota));
                BigDecimal ratio = BigDecimal.valueOf(quota).divide(BigDecimal.valueOf(uccSkuAdjustPricePO.getBeforePride()), 2, 4);
                uccSkuAdjustPricePO.setAdjustRatio(ratio);
            }
            uccSkuAdjustPricePO.setAdjustType(UccConstants.UccAdjustType.MALL_ADJUST);
            uccSkuAdjustPricePO.setAdjustTime(new Date());
            uccSkuAdjustPricePO.setOperName(reqBO.getName());
            int i = this.uccSkuAdjustPriceMapper.updateById(uccSkuAdjustPricePO);
            if (i < 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u6b64skuId:" + skuId + "\u7684\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f\u8868\u9519\u8bef");
            }
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(skuId);
            uccSkuPricePo.setSupplierShopId(uccSkuAdjustPricePO.getSupplierShopId());
            uccSkuPricePo.setSalePrice(uccSkuAdjustPricePO.getAfterPrice());
            this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
            uccSkuAdjustPricePOList.add(uccSkuAdjustPricePO);
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSupplierId(supplierId);
            syncSceneCommodityToEsReqBO.setSkuIds(Arrays.asList(skuId));
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(uccSkuAdjustPricePOList)) {
            UccSignBatchAdjustLogAtomServiceReqBO uccSignBatchAdjustLogAtomServiceReqBO = new UccSignBatchAdjustLogAtomServiceReqBO();
            uccSignBatchAdjustLogAtomServiceReqBO.setUccSkuAdjustPricePOList(uccSkuAdjustPricePOList);
            UccSignBatchAdjustLogAtomServiceRspBO uccSignBatchAdjustLogAtomServiceRspBO = this.uccSignBatchAdjustLogAtomService.signBatchAdjustLog(uccSignBatchAdjustLogAtomServiceReqBO);
            if (!"0000".equals(uccSignBatchAdjustLogAtomServiceRspBO.getRespCode())) {
                throw new ZTBusinessException(uccSignBatchAdjustLogAtomServiceRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6279\u91cf\u8c03\u4ef7\u6210\u529f");
        return rspBO;
    }

    private void check(UccBatchAdjustBusiReqBO reqBO) {
        if (reqBO.getSkuSource() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[skuSource]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getBeforePride() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[beforePride]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAfterPrice() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[afterPrice]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProductLevel() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[productLevel]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSkuClass() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[skuClass]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSkuForm() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[skuForm]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSkuId() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[skuId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCommodityId() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[commodityId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[supplierShopId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getErpSkuCode())) {
            throw new ZTBusinessException("\u9996\u6b21\u8c03\u4ef7 busi\u5165\u53c2[erpSkuCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

