/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccExcelImportBO;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.common.ability.bo.UccErpAdjustListBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccExportErpAdjustTemplateBusiService;
import com.tydic.commodity.common.busi.bo.UccExportErpAdjustTemplateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccExportErpAdjustTemplateBusiRspBO;
import com.tydic.commodity.dao.ErpSkuPriceChangeMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuAdjustPriceMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSkuErpAdjustPriceQryListPO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccExportErpAdjustTemplateBusiServiceImpl
implements UccExportErpAdjustTemplateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccExportErpAdjustTemplateBusiServiceImpl.class);
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private UccSkuAdjustPriceMapper uccSkuAdjustPriceMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private ErpSkuPriceChangeMapper erpSkuPriceChangeMapper;

    @Override
    public UccExportErpAdjustTemplateBusiRspBO exportErpAdjustTemplate(UccExportErpAdjustTemplateBusiReqBO reqBO) {
        UccExportErpAdjustTemplateBusiRspBO rspBO = new UccExportErpAdjustTemplateBusiRspBO();
        List<UccErpAdjustListBO> uccErpAdjustListBOList = this.getSkuAdjustInfoList(reqBO.getSkuIds());
        ArrayList<UccExcelImportBO> ApplyForSaleTemplateList = new ArrayList<UccExcelImportBO>();
        UccExcelImportBO spuTemplate = new UccExcelImportBO();
        spuTemplate.setSheet("\u7533\u8bf7\u4e0a\u67b6\u5546\u54c1\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
        ArrayList<String> spuTitle = new ArrayList<String>();
        spuTitle.add("\u5e8f\u53f7");
        spuTitle.add("\u5355\u54c1\u540d\u79f0");
        spuTitle.add("\u5355\u54c1\u7f16\u7801");
        spuTitle.add("\u5546\u5bb6\u8d27\u53f7");
        spuTitle.add("\u5546\u54c1\u5f62\u6001");
        spuTitle.add("\u6210\u54c1\u7b49\u7ea7");
        spuTitle.add("\u9500\u552e\u6307\u5bfc\u4ef7");
        spuTitle.add("\u5546\u57ce\u4ef7\u683c\u5dee\u989d");
        spuTitle.add("\u5546\u57ce\u9500\u552e\u4ef7");
        spuTitle.add("\u5546\u54c1\u72b6\u6001");
        spuTemplate.setTitle(spuTitle);
        ApplyForSaleTemplateList.add(spuTemplate);
        String url = this.dealImportTempToXmls(ApplyForSaleTemplateList, uccErpAdjustListBOList);
        rspBO.setUrl(url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public String dealImportTempToXmls(List<UccExcelImportBO> importBOs, List<UccErpAdjustListBO> data) {
        log.info("\u5bfc\u5165\u6570\u636e\uff1a" + JSONObject.toJSONString(importBOs));
        long timeMillis = System.currentTimeMillis();
        String fileUrl = "";
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle bodyStyle = wb.createCellStyle();
        HSSFCellStyle linkCellStyle = wb.createCellStyle();
        HSSFCellStyle backGroundcellStyle = wb.createCellStyle();
        for (int j = 0; j < importBOs.size(); ++j) {
            HSSFFont font;
            HSSFSheet sheet = wb.createSheet(importBOs.get(j).getSheet());
            HSSFRow row1 = sheet.createRow(0);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
            row1.setHeightInPoints(140.0f);
            bodyStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
            bodyStyle.setAlignment(HorizontalAlignment.LEFT);
            bodyStyle.setWrapText(true);
            bodyStyle.setBorderBottom(BorderStyle.THIN);
            bodyStyle.setBorderLeft(BorderStyle.THIN);
            bodyStyle.setBorderTop(BorderStyle.THIN);
            bodyStyle.setBorderRight(BorderStyle.THIN);
            HSSFFont fontStyle = wb.createFont();
            fontStyle.setFontName("\u5b8b\u4f53");
            fontStyle.setFontHeightInPoints((short)11);
            bodyStyle.setFont(fontStyle);
            HSSFCell cell = row1.createCell(0);
            cell.setCellStyle(bodyStyle);
            String text = "\u586b\u5199\u8bf4\u660e\uff1a\r\n1\u3001\u4ec5\u9ec4\u8272\u5b57\u6bb5\u6570\u636e\u5141\u8bb8\u7528\u6237\u4fee\u6539\uff0c\u5141\u8bb8\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\r\n2\u3001\u5141\u8bb8\u7528\u6237\u4e00\u6b21\u6027\u5bfc\u5165\u4e0d\u8d85\u8fc73000\u6761\u6570\u636e";
            cell.setCellValue((RichTextString)new HSSFRichTextString(text));
            HSSFRow row = sheet.createRow(1);
            HSSFCell cellHead = null;
            for (int i = 0; i < importBOs.get(j).getTitle().size(); ++i) {
                HSSFCellStyle cellStyle;
                cellHead = row.createCell(i);
                cellHead.setCellValue((String)importBOs.get(j).getTitle().get(i));
                row.setHeightInPoints(13.5f);
                if (i < 9) {
                    if (((String)importBOs.get(j).getTitle().get(i)).startsWith("***")) {
                        cellHead.setCellValue(((String)importBOs.get(j).getTitle().get(i)).substring(3));
                    }
                    font = wb.createFont();
                    font.setColor((short)10);
                    font.setFontName("\u9ed1\u4f53");
                    font.setFontHeightInPoints((short)11);
                    cellStyle = wb.createCellStyle();
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setFont((Font)font);
                    cellStyle.setWrapText(true);
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                    cellHead.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                font = wb.createFont();
                font.setFontName("\u9ed1\u4f53");
                font.setFontHeightInPoints((short)11);
                cellStyle = wb.createCellStyle();
                cellStyle.setBorderBottom(BorderStyle.THIN);
                cellStyle.setBorderLeft(BorderStyle.THIN);
                cellStyle.setBorderTop(BorderStyle.THIN);
                cellStyle.setBorderRight(BorderStyle.THIN);
                cellStyle.setFont((Font)font);
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                cellHead.setCellStyle((CellStyle)cellStyle);
            }
            for (int begin = 0; begin < importBOs.get(j).getTitle().size(); ++begin) {
                sheet.setColumnWidth(begin, (int)((double)row.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)row.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 : 3072.0));
            }
            HSSFCellStyle backGroundcellStyle1 = wb.createCellStyle();
            backGroundcellStyle1.setFillBackgroundColor((short)1);
            backGroundcellStyle1.setLocked(true);
            backGroundcellStyle1.setWrapText(true);
            backGroundcellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            backGroundcellStyle1.setAlignment(HorizontalAlignment.CENTER);
            backGroundcellStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            backGroundcellStyle1.setFillForegroundColor(IndexedColors.GOLD.getIndex());
            font = wb.createFont();
            font.setFontName("\u9ed1\u4f53");
            font.setFontHeightInPoints((short)11);
            backGroundcellStyle1.setFont((Font)font);
            int spuDataRowsBegin = 3;
            for (int i = 0; i < data.size(); ++i) {
                row1 = sheet.createRow(spuDataRowsBegin + i);
                row1.setHeightInPoints(13.5f);
                cell = row1.createCell(0);
                cell.setCellValue((double)(i + 1));
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(1);
                cell.setCellValue(data.get(i).getSkuName());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(2);
                cell.setCellValue(data.get(i).getSkuCode());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(3);
                cell.setCellValue(data.get(i).getFreeLocation());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(4);
                cell.setCellValue(data.get(i).getSkuFormStr());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(5);
                cell.setCellValue(data.get(i).getProductLevelStr());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(6);
                cell.setCellValue(data.get(i).getMarketPrice().toString());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(7);
                cell.setCellValue(data.get(i).getErpQuota().toString());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(8);
                cell.setCellValue(data.get(i).getSalePrice().toString());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                cell = row1.createCell(9);
                cell.setCellValue(data.get(i).getSkuStatusStr());
                cell.setCellStyle((CellStyle)backGroundcellStyle);
                for (int begin = 0; begin < importBOs.get(j).getTitle().size(); ++begin) {
                    sheet.setColumnWidth(begin, (int)((double)row.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)row.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 : 3072.0));
                }
            }
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outputStream);
            byte[] b = outputStream.toByteArray();
            fileUrl = this.fileUpLoad.upload("\u7533\u8bf7\u4e0a\u67b6\u5bfc\u5165\u6a21\u677f-" + timeMillis, b, ".xls");
            outputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5bfc\u51faExcel\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex.getMessage());
        }
        return fileUrl;
    }

    List<UccErpAdjustListBO> getSkuAdjustInfoList(List<Long> skuIds) {
        List uccSkuErpAdjustPriceQryListPOList = this.erpSkuPriceChangeMapper.getSkuErpAdjustList(skuIds);
        ArrayList<UccErpAdjustListBO> uccErpAdjustListBOList = new ArrayList<UccErpAdjustListBO>();
        if (!CollectionUtils.isEmpty((Collection)uccSkuErpAdjustPriceQryListPOList)) {
            Map<String, String> skuProductLevelMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_SKU_PRODUCT_LEVEL");
            Map<String, String> skuFormMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_SKU_FORM_MATERIAL");
            Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
            for (UccSkuErpAdjustPriceQryListPO po : uccSkuErpAdjustPriceQryListPOList) {
                UccErpAdjustListBO bo = new UccErpAdjustListBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bo.setProductLevelStr(skuProductLevelMap.get(po.getProductLevel().toString()));
                bo.setSkuFormStr(skuFormMap.get(po.getSkuForm().toString()));
                bo.setSkuStatusStr(skuStatusMap.get(po.getSkuStatus().toString()));
                UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(po.getCommodityTypeId());
                if (uccCommodityTypePo != null) {
                    bo.setCommodityTypeStr(uccCommodityTypePo.getCommodityTypeName());
                }
                uccErpAdjustListBOList.add(bo);
            }
        }
        return uccErpAdjustListBOList;
    }
}

