/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.common.ability.bo.UccErpAdjustListExcelBO;
import com.tydic.commodity.common.busi.api.UccImportErpAdjustBusiService;
import com.tydic.commodity.common.busi.api.UccSetErpAdjustQuotaBusiService;
import com.tydic.commodity.common.busi.bo.UccImportErpAdjustBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccImportErpAdjustBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccSetErpAdjustQuotaBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSetErpAdjustQuotaBusiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccImportErpAdjustBusiServiceImpl
implements UccImportErpAdjustBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccImportErpAdjustBusiServiceImpl.class);
    @Autowired
    private UccSetErpAdjustQuotaBusiService uccSetErpAdjustQuotaBusiService;

    @Override
    public UccImportErpAdjustBusiRspBO importErpAdjust(UccImportErpAdjustBusiReqBO reqBO) {
        UccImportErpAdjustBusiRspBO rspBO = new UccImportErpAdjustBusiRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new ZTBusinessException("url\u4e3a\u7a7a");
        }
        String url = reqBO.getUrl();
        List<UccErpAdjustListExcelBO> uccBulkPricingExcelBOList = this.getCommodityBOList(url);
        if (!CollectionUtils.isEmpty(uccBulkPricingExcelBOList)) {
            for (UccErpAdjustListExcelBO bo : uccBulkPricingExcelBOList) {
                UccSetErpAdjustQuotaBusiReqBO busiReqBO = new UccSetErpAdjustQuotaBusiReqBO();
                BigDecimal adjustQuota = BigDecimal.valueOf(bo.getErpQuota()).divide(new BigDecimal("10000"), 2, 4);
                busiReqBO.setAdjustQuota(adjustQuota);
                ArrayList<String> skuCodeList = new ArrayList<String>();
                skuCodeList.add(bo.getSkuCode());
                busiReqBO.setSkuCodeList(skuCodeList);
                UccSetErpAdjustQuotaBusiRspBO busiRspBO = this.uccSetErpAdjustQuotaBusiService.setErpAdjustQuota(busiReqBO);
                if ("0000".equals(busiRspBO.getRespCode())) continue;
                throw new ZTBusinessException("\u5e8f\u53f7\uff1a" + bo.getSerialNum() + "\u884c \u8c03\u4ef7\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u5165erp\u8c03\u4ef7\u6210\u529f");
        return rspBO;
    }

    private List<UccErpAdjustListExcelBO> getCommodityBOList(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccErpAdjustListExcelBO> uccErpAdjustListExcelBOList = new ArrayList<UccErpAdjustListExcelBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccErpAdjustListExcelBO uccErpAdjustListExcelBO = new UccErpAdjustListExcelBO();
                    int i = 0;
                    if (!head.contains("\u5408\u540c\u540d\u79f0") || !head.contains("\u5408\u540c\u7f16\u53f7")) continue;
                    String serialNum = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setSerialNum(Integer.valueOf(serialNum));
                    String skuName = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setSkuName(skuName);
                    String skuCode = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setSkuCode(skuCode);
                    String freeLocation = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setFreeLocation(freeLocation);
                    String skuFormStr = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setSkuFormStr(skuFormStr);
                    String productLevel = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setProductLevelStr(productLevel);
                    String marketPrice = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setMarketPrice(Long.valueOf(marketPrice));
                    String erpQuota = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setErpQuota(Long.valueOf(erpQuota));
                    String salePrice = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setSalePrice(Long.valueOf(salePrice));
                    String skuStatusStr = (String)list.get(i++);
                    uccErpAdjustListExcelBO.setSkuStatusStr(skuStatusStr);
                    uccErpAdjustListExcelBOList.add(uccErpAdjustListExcelBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return uccErpAdjustListExcelBOList;
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u5904\u7406Excel\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

