/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.bo.UccQryAdjustLogBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccQryAdjustLogListBusiService;
import com.tydic.commodity.common.busi.bo.UccQryAdjustLogListBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccQryAdjustLogListBusiRspBO;
import com.tydic.commodity.dao.UccSkuAdjustPriceLogMapper;
import com.tydic.commodity.po.UccSkuAdjustPriceLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccQryAdjustLogListBusiServiceImpl
implements UccQryAdjustLogListBusiService {
    @Autowired
    private UccSkuAdjustPriceLogMapper uccSkuAdjustPriceLogMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccQryAdjustLogListBusiRspBO qryAdjustLogList(UccQryAdjustLogListBusiReqBO reqBO) {
        UccQryAdjustLogListBusiRspBO rspBO = new UccQryAdjustLogListBusiRspBO();
        UccSkuAdjustPriceLogPO uccSkuAdjustPriceLogPO = new UccSkuAdjustPriceLogPO();
        uccSkuAdjustPriceLogPO.setSkuId(reqBO.getSkuId());
        uccSkuAdjustPriceLogPO.setAdjustTimeStart(reqBO.getAdjustTimeStart());
        uccSkuAdjustPriceLogPO.setAdjustTimeEnd(reqBO.getAdjustTimeEnd());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List uccSkuAdjustPriceLogPOList = this.uccSkuAdjustPriceLogMapper.getListPage(uccSkuAdjustPriceLogPO, page);
        List<Object> uccQryAdjustLogBOList = new ArrayList();
        Map<String, String> adjustTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_ADJUST_TYPE");
        if (CollectionUtils.isEmpty(adjustTypeMap)) {
            throw new ZTBusinessException("\u8c03\u4ef7\u9014\u5f84 \u5b57\u5178\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)uccSkuAdjustPriceLogPOList)) {
            uccQryAdjustLogBOList = uccSkuAdjustPriceLogPOList.stream().map(po -> {
                UccQryAdjustLogBO bo = new UccQryAdjustLogBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                BigDecimal beforePrice = BigDecimal.valueOf(po.getBeforePride()).divide(new BigDecimal("10000"), 2, 4);
                BigDecimal afterPrice = BigDecimal.valueOf(po.getAfterPrice()).divide(new BigDecimal("10000"), 2, 4);
                BigDecimal adjustQuota = BigDecimal.valueOf(po.getAdjustQuota()).divide(new BigDecimal("10000"), 2, 4);
                bo.setAdjustQuota(adjustQuota);
                bo.setBeforePride(beforePrice);
                bo.setAfterPrice(afterPrice);
                bo.setAdjustTypeStr((String)adjustTypeMap.get(po.getAdjustType().toString()));
                return bo;
            }).collect(Collectors.toList());
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(uccQryAdjustLogBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u770b\u8c03\u4ef7\u8bb0\u5f55\u6210\u529f");
        return rspBO;
    }
}

