/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.bo.UccSelfMaterialStockBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccQrySelfMaterialStockListBusiService;
import com.tydic.commodity.common.busi.bo.UccQrySelfMaterialStockListBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccQrySelfMaterialStockListBusiRspBO;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSmcsdkSkuStockInfoMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSmcsdkSkuStockInfoQryPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccQrySelfMaterialStockListBusiServiceImpl
implements UccQrySelfMaterialStockListBusiService {
    @Autowired
    private UccSmcsdkSkuStockInfoMapper uccSmcsdkSkuStockInfoMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @Override
    public UccQrySelfMaterialStockListBusiRspBO qrySelfMaterialStockList(UccQrySelfMaterialStockListBusiReqBO reqBO) {
        UccQrySelfMaterialStockListBusiRspBO rspBO = new UccQrySelfMaterialStockListBusiRspBO();
        ArrayList<UccSelfMaterialStockBO> uccSelfMaterialStockBOList = new ArrayList<UccSelfMaterialStockBO>();
        UccSmcsdkSkuStockInfoQryPO uccSmcsdkSkuStockInfoQryPO = new UccSmcsdkSkuStockInfoQryPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccSmcsdkSkuStockInfoQryPO);
        uccSmcsdkSkuStockInfoQryPO.setSkuSource(UccConstants.CommoditySourceEnum.SELF.getKey());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List uccSmcsdkSkuStockInfoQryPOList = this.uccSmcsdkSkuStockInfoMapper.getListPageForStockManage(uccSmcsdkSkuStockInfoQryPO, page);
        if (!CollectionUtils.isEmpty((Collection)uccSmcsdkSkuStockInfoQryPOList)) {
            for (UccSmcsdkSkuStockInfoQryPO po : uccSmcsdkSkuStockInfoQryPOList) {
                UccSelfMaterialStockBO bo = new UccSelfMaterialStockBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
                Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
                Map<String, String> skuApprovalStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_SKU_APPROVAL_STATUS");
                Map<String, String> skuFormMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_SKU_FORM_MATERIAL");
                bo.setCommodityTypeStr(uccCommodityTypePo.getCommodityTypeName());
                bo.setShopUnsaleNum(po.getUnsaleNum());
                bo.setSkuStatusStr(skuStatusMap.get(po.getSkuStatus().toString()));
                bo.setApprovalStatusStr(skuApprovalStatusMap.get(po.getApprovalStatus().toString()));
                bo.setSkuFormStr(skuFormMap.get(po.getSkuForm().toString()));
                if (UccConstants.SkuMaterialFormEnum.CASH_COMMODITY.getFormId().equals(po.getSkuSource()) || UccConstants.SkuMaterialFormEnum.SAMPLE_CARD.getFormId().equals(po.getSkuSource())) {
                    // empty if block
                }
                uccSelfMaterialStockBOList.add(bo);
            }
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(uccSelfMaterialStockBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

