/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.atom.api.UccSignBatchAdjustLogAtomService;
import com.tydic.commodity.common.atom.bo.UccSignBatchAdjustLogAtomServiceReqBO;
import com.tydic.commodity.common.atom.bo.UccSignBatchAdjustLogAtomServiceRspBO;
import com.tydic.commodity.common.busi.api.UccSetErpAdjustQuotaBusiService;
import com.tydic.commodity.common.busi.bo.UccSetErpAdjustQuotaBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSetErpAdjustQuotaBusiRspBO;
import com.tydic.commodity.dao.ErpSkuPriceChangeMapper;
import com.tydic.commodity.dao.UccSkuAdjustPriceMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.ErpSkuPriceChangePO;
import com.tydic.commodity.po.UccSkuAdjustPricePO;
import com.tydic.commodity.po.UccSkuPricePo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSetErpAdjustQuotaBusiServiceImpl
implements UccSetErpAdjustQuotaBusiService {
    @Autowired
    private ErpSkuPriceChangeMapper erpSkuPriceChangeMapper;
    @Autowired
    private UccSkuAdjustPriceMapper uccSkuAdjustPriceMapper;
    @Autowired
    private UccSignBatchAdjustLogAtomService uccSignBatchAdjustLogAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @Override
    public UccSetErpAdjustQuotaBusiRspBO setErpAdjustQuota(UccSetErpAdjustQuotaBusiReqBO reqBO) {
        UccSetErpAdjustQuotaBusiRspBO rspBO = new UccSetErpAdjustQuotaBusiRspBO();
        ArrayList<UccSkuAdjustPricePO> uccSkuAdjustPricePOList = new ArrayList<UccSkuAdjustPricePO>();
        List erpSkuPriceChangePOList = this.erpSkuPriceChangeMapper.getListBySkuCodes(reqBO.getSkuCodeList());
        for (ErpSkuPriceChangePO po : erpSkuPriceChangePOList) {
            Long erpQuota = reqBO.getAdjustQuota().multiply(new BigDecimal("10000")).longValue();
            ErpSkuPriceChangePO erpSkuPriceChangePO = new ErpSkuPriceChangePO();
            erpSkuPriceChangePO.setSkuId(po.getSkuId());
            erpSkuPriceChangePO.setErpQuota(erpQuota);
            erpSkuPriceChangePO.setChangeTime(new Date());
            int i = this.erpSkuPriceChangeMapper.updateById(erpSkuPriceChangePO);
            if (i != 1) {
                throw new ZTBusinessException("ERP\u8c03\u4ef7\u57fa\u6570\u4ef7\u5dee\u6279\u91cf\u8bbe\u7f6e \u66f4\u65b0erp\u8c03\u4ef7\u8868\u5931\u8d25\uff01");
            }
            UccSkuAdjustPricePO modelReqPO = new UccSkuAdjustPricePO();
            modelReqPO.setSkuId(po.getSkuId());
            UccSkuAdjustPricePO uccSkuAdjustPricePO = this.uccSkuAdjustPriceMapper.getModelBy(modelReqPO);
            if (uccSkuAdjustPricePO == null) {
                throw new ZTBusinessException("ERP\u8c03\u4ef7\u57fa\u6570\u4ef7\u5dee\u6279\u91cf\u8bbe\u7f6e\uff0c\u67e5\u8be2\u4ef7\u683c\u8c03\u6574\u8868\u5f02\u5e38\u3002\u65e0\u6b64id:" + po.getSkuId() + "\u7684\u5355\u54c1\u8c03\u4ef7\u4fe1\u606f");
            }
            uccSkuAdjustPricePO.setBeforePride(uccSkuAdjustPricePO.getAfterPrice());
            uccSkuAdjustPricePO.setAfterPrice(Long.valueOf(po.getMarketPrice() + erpQuota));
            Long adjustQuota = uccSkuAdjustPricePO.getAfterPrice() - uccSkuAdjustPricePO.getBeforePride();
            uccSkuAdjustPricePO.setAdjustQuota(adjustQuota);
            uccSkuAdjustPricePO.setAdjustRatio(BigDecimal.valueOf(adjustQuota).divide(BigDecimal.valueOf(uccSkuAdjustPricePO.getBeforePride()), 2, 4));
            uccSkuAdjustPricePO.setAdjustType(UccConstants.UccAdjustType.ERP_ADJUST);
            uccSkuAdjustPricePO.setAdjustTime(new Date());
            uccSkuAdjustPricePO.setOperName(reqBO.getName());
            int j = this.uccSkuAdjustPriceMapper.updateById(uccSkuAdjustPricePO);
            if (j != 1) {
                throw new ZTBusinessException("ERP\u8c03\u4ef7\u57fa\u6570\u4ef7\u5dee\u6279\u91cf\u8bbe\u7f6e \u66f4\u65b0\u4ef7\u683c\u8c03\u6574\u8868\u5931\u8d25\uff01");
            }
            uccSkuAdjustPricePOList.add(uccSkuAdjustPricePO);
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(po.getSkuId());
            uccSkuPricePo.setSupplierShopId(uccSkuAdjustPricePO.getSupplierShopId());
            uccSkuPricePo.setSalePrice(uccSkuAdjustPricePO.getAfterPrice());
            this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
        }
        if (!CollectionUtils.isEmpty(uccSkuAdjustPricePOList)) {
            UccSignBatchAdjustLogAtomServiceReqBO uccSignBatchAdjustLogAtomServiceReqBO = new UccSignBatchAdjustLogAtomServiceReqBO();
            uccSignBatchAdjustLogAtomServiceReqBO.setUccSkuAdjustPricePOList(uccSkuAdjustPricePOList);
            UccSignBatchAdjustLogAtomServiceRspBO uccSignBatchAdjustLogAtomServiceRspBO = this.uccSignBatchAdjustLogAtomService.signBatchAdjustLog(uccSignBatchAdjustLogAtomServiceReqBO);
            if (!"0000".equals(uccSignBatchAdjustLogAtomServiceRspBO.getRespCode())) {
                throw new ZTBusinessException(uccSignBatchAdjustLogAtomServiceRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("ERP\u8c03\u4ef7\u57fa\u6570\u4ef7\u5dee\u6279\u91cf\u8bbe\u7f6e\u6210\u529f");
        return rspBO;
    }
}

