/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.filter.ParameterRequestWrapper;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umc.security.utils.RegexUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class UmcTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTokenAuthenticationFilter.class);
    private static final String AUTH_TOKEN = "auth-token";
    private static final String RESP_CODE = "respCode";
    private static final String RESP_DESC = "respDesc";
    private static final String DATA = "data";
    private static final ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Value(value="${static.resources}")
    private String staticResources;
    @Autowired
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        Cookie[] cookies;
        String token = request.getHeader(AUTH_TOKEN);
        if (StringUtils.isEmpty((CharSequence)token) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!AUTH_TOKEN.equals(cookie.getName())) continue;
                token = cookie.getValue();
            }
        }
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject dataJsonObject = new com.alibaba.fastjson.JSONObject();
        LOGGER.debug("\u83b7\u53d6\u5f53\u524dtoken" + token);
        if (StringUtils.isBlank((CharSequence)token)) {
            dataJsonObject.put(RESP_CODE, (Object)"AE401");
            dataJsonObject.put(RESP_DESC, (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            jsonObject.put(DATA, (Object)dataJsonObject);
        } else {
            UmcLoginExpTimeAbilityReqBO reqBO = new UmcLoginExpTimeAbilityReqBO();
            reqBO.setToken(token);
            UmcLoginExpTimeAbilityRspBO rspBO = this.umcLoginAbilityService.getLoginExpTime(reqBO);
            Long loginExpTime = 0L;
            LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)rspBO));
            if ("0000".equals(rspBO.getRespCode())) {
                loginExpTime = rspBO.getExpTime();
                LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
            }
            Map<String, Object> resultMap = UmcJwt.validToken(token, loginExpTime);
            UmcTokenState state = UmcTokenState.getTokenState((String)resultMap.get("state"));
            switch (state) {
                case VALID: {
                    UmcUserDetails user;
                    JSONObject data = (JSONObject)resultMap.get(DATA);
                    request.setAttribute(DATA, (Object)data);
                    String appCode = data.getAsString("appCode");
                    reqBO.setUserId((Long)data.get((Object)"userId"));
                    reqBO.setLoginSource((String)data.get((Object)"loginSource"));
                    this.umcLoginAbilityService.updateLoginExpTime(reqBO);
                    Long orgId = 0L;
                    if (data.get((Object)"orgId") != null) {
                        orgId = (Long)data.get((Object)"orgId");
                    }
                    if ("0000".equals((user = this.getUserInfoByTokenService.getUserInfoByUserId((Long)data.get((Object)"userId"), orgId, token, appCode, request.getRequestURI())).getRespCode())) {
                        return new UsernamePasswordAuthenticationToken((Object)user.getUserDetails(), (Object)user.getUserDetails().getPassword(), user.getUserDetails().getAuthorities());
                    }
                    dataJsonObject.put(RESP_CODE, (Object)user.getRespCode());
                    dataJsonObject.put(RESP_DESC, (Object)user.getRespDesc());
                    jsonObject.put(DATA, (Object)dataJsonObject);
                    LOGGER.info(user.getRespCode());
                    break;
                }
                case EXPIRED: {
                    dataJsonObject.put(RESP_CODE, (Object)"AE401");
                    dataJsonObject.put(RESP_DESC, (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put(DATA, (Object)dataJsonObject);
                    break;
                }
                default: {
                    dataJsonObject.put(RESP_CODE, (Object)"AE401");
                    dataJsonObject.put(RESP_DESC, (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put(DATA, (Object)dataJsonObject);
                }
            }
        }
        if ("AE403".equals(dataJsonObject.getString(RESP_CODE))) {
            response.setStatus(403);
        } else {
            response.setStatus(401);
        }
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        allowSessionCreation.set(true);
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        boolean needTokenFlag = this.isNeedToken(request.getRequestURI());
        boolean needUserInfo = false;
        if (needTokenFlag) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            needUserInfo = true;
        }
        ServletRequest requestWrapper = this.parameterRequest(request, needUserInfo);
        chain.doFilter(requestWrapper, (ServletResponse)response);
    }

    private boolean isNeedToken(String url) {
        boolean needToken = true;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        return needToken;
    }

    private ServletRequest parameterRequest(HttpServletRequest request, Boolean needUserInfo) {
        LOGGER.debug("UmcUserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
        ParameterRequestWrapper requestWrapper = new ParameterRequestWrapper(request, needUserInfo);
        LOGGER.debug("UmcUserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }
}

