/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(ParameterRequestWrapper.class);
    private final Map<String, String[]> params = Maps.newHashMapWithExpectedSize((int)16);
    private String requestBody;

    ParameterRequestWrapper(HttpServletRequest request, Boolean needUserInfo) {
        super(request);
        UmcMemInfoBO userInfo;
        this.params.putAll(request.getParameterMap());
        if (needUserInfo.booleanValue() && (userInfo = UmcMemInfoHelper.getCurrentUser()) != null) {
            for (Map.Entry<String, Object> entry : ParameterRequestWrapper.transBean2Map(userInfo).entrySet()) {
                if (this.params.get(entry.getKey()) != null) continue;
                this.addParameter(entry.getKey(), entry.getValue());
            }
        }
        if (request.getContentType() != null && request.getContentType().contains("application/json")) {
            StringBuilder stringBuilder;
            block19: {
                stringBuilder = new StringBuilder();
                try (ServletInputStream inputStream = request.getInputStream();){
                    if (inputStream == null) break block19;
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                        int bytesRead;
                        char[] charBuffer = new char[128];
                        while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                            stringBuilder.append(charBuffer, 0, bytesRead);
                        }
                    }
                }
                catch (IOException e) {
                    log.error("\u83b7\u53d6\u5165\u53c2\u8f93\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            String s = stringBuilder.toString();
            if (StringUtils.isNotBlank((CharSequence)s)) {
                JSONObject requestBodyJsonObject = JSON.parseObject((String)s);
                for (Map.Entry requestBodyEntry : requestBodyJsonObject.entrySet()) {
                    String requestBodyStr;
                    String trim;
                    Object requestBodyValue = requestBodyEntry.getValue();
                    if (!(requestBodyValue instanceof String) || (trim = (requestBodyStr = (String)requestBodyValue).trim()).length() >= requestBodyStr.length()) continue;
                    requestBodyEntry.setValue(trim);
                }
                s = JSON.toJSONString((Object)requestBodyJsonObject);
            }
            this.requestBody = s;
        }
    }

    private static Map<String, Object> transBean2Map(Object obj) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                String key = property.getName();
                if ("class".equals(key) || (getter = property.getReadMethod()) == null) continue;
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
            map.remove("menus");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u8f6cmap\u5931\u8d25 ", (Throwable)e);
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestBody == null) {
            return super.getInputStream();
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)this.requestBody);
        }
        catch (Exception e) {
            log.error("\u5165\u53c2\u4e0d\u662fJSON\u683c\u5f0f\uff0c\u4e0d\u5305\u88c5\u7528\u6237\u4fe1\u606f");
        }
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        if (jsonObject != null && userInfo != null) {
            JSONObject userJson = (JSONObject)JSON.toJSON(ParameterRequestWrapper.transBean2Map(userInfo));
            userJson.putAll((Map)jsonObject);
            userJson.put("userId", (Object)userInfo.getUserId());
            userJson.put("memIdIn", (Object)userInfo.getMemIdIn());
            userJson.put("memIdExt", (Object)userInfo.getMemIdExt());
            userJson.put("orgId", (Object)userInfo.getOrgId());
            userJson.put("orgPath", (Object)userInfo.getOrgPath());
            this.requestBody = userJson.toJSONString();
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.requestBody.getBytes());
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.params.put(name, (String[])value);
            } else if (value instanceof String) {
                this.params.put(name, new String[]{(String)value});
            } else {
                this.params.put(name, new String[]{String.valueOf(value)});
            }
        }
    }
}

