/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.self.abiility.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateAbilityReqBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateAbilityRspBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateAddressBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateItemBo;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.self.ability.api.UocDaYaoNonPointOrderCreateAbilityService;
import com.tydic.uoc.self.comb.api.UocDaYaoNonPointOrderCreateCombService;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocDaYaoNonPointOrderCreateAbilityServiceImpl
implements UocDaYaoNonPointOrderCreateAbilityService {
    @Autowired
    private UocDaYaoNonPointOrderCreateCombService uocDaYaoNonPointOrderCreateCombService;

    public UocDaYaoOrderCreateAbilityRspBo createNonPointOrder(UocDaYaoOrderCreateAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        return this.uocDaYaoNonPointOrderCreateCombService.createNonPointOrder(reqBo);
    }

    private void validateArg(UocDaYaoOrderCreateAbilityReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPurNo() || 0L == reqBo.getPurNo()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5ba2\u6237\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5ba2\u6237\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurPlaceOrderId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u4ebaUserId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurPlaceOrderName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u4eba\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurMobile())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getDeliveryMethod()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u914d\u9001\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayType()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocConstant.DaYaoPayType.OFFLINE_PAYMENTS.equals(reqBo.getPayType())) {
            if (null == reqBo.getPayMod()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!UocConstant.PayMod.BANK_TRANSFER.equals(reqBo.getPayMod()) && !UocConstant.PayMod.ACCEPTANCE_BILL.equals(reqBo.getPayMod())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5408\u6cd5");
            }
        } else {
            reqBo.setPayMod(null);
        }
        if (null == reqBo.getOrderType()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getItemBos())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPointOrder()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u662f\u5426\u79ef\u5206\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getInvoiceBo()) {
            if (null == reqBo.getInvoiceBo().getOutInvoiceId() || 0L == reqBo.getInvoiceBo().getOutInvoiceId()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f\u4f1a\u5458\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceBo().getBuyerName())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceBo().getInvoiceNo())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBo.getInvoiceBo().getInvoiceType()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBo.getInvoiceBo().getDepositBank()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBo.getInvoiceBo().getBankAccount()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f\u5f00\u6237\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.validateArgAddress(reqBo.getInvoiceBo().getAddressBo(), "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fe1\u606f");
        }
        this.validateArgAddress(reqBo.getAddressBo(), "\u6536\u8d27\u4fe1\u606f");
        for (UocDaYaoOrderCreateItemBo itemBo : reqBo.getItemBos()) {
            if (null == itemBo) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuClass()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5355\u54c1\u5927\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuForm()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5355\u54c1\u5f62\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSpuId() || 0L == itemBo.getSpuId()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuId() || 0L == itemBo.getSkuId()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuSource()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5355\u54c1\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getPurchaseCount() || itemBo.getPurchaseCount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u91c7\u8d2d\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            if (null == itemBo.getSupNo() || 0L == itemBo.getSupNo()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != itemBo.getSupplierShopId() && 0L != itemBo.getSupplierShopId()) continue;
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgAddress(UocDaYaoOrderCreateAddressBo addressBo, String desc) {
        if (null == addressBo) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverProvinceId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u7701\u4efd\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverProvinceName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverCityId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u5730\u5e02\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverCityName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u5730\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverCountyId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverCountyName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverAddress())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverCompany())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverMobileNumber())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressBo.getReceiverManufacturerName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2" + desc + "\u6536\u8d27\u5382\u5bb6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

