/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.self.abiility.impl;

import com.tydic.order.ability.bo.UocDaYaoOrderCreateAbilityReqBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateAbilityRspBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateItemBo;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.self.ability.api.UocDaYaoPointOrderCreateAbilityService;
import com.tydic.uoc.self.comb.api.UocDaYaoPointOrderCreateCombService;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocDaYaoPointOrderCreateAbilityServiceImpl
implements UocDaYaoPointOrderCreateAbilityService {
    @Autowired
    private UocDaYaoPointOrderCreateCombService uocDaYaoPointOrderCreateCombService;

    public UocDaYaoOrderCreateAbilityRspBo createPointOrder(UocDaYaoOrderCreateAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        return this.uocDaYaoPointOrderCreateCombService.createPointOrder(reqBo);
    }

    private void validateArg(UocDaYaoOrderCreateAbilityReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPurNo() || 0L == reqBo.getPurNo()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5ba2\u6237\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5ba2\u6237\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurPlaceOrderId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u4ebaUserId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurPlaceOrderName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u4eba\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPurMobile())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.setDeliveryMethod(UocConstant.DeliveryMethod.EXPRESS_DELIVERY);
        reqBo.setPayType(UocConstant.DaYaoPayType.REDEEM);
        reqBo.setPayMod(null);
        if (null == reqBo.getOrderType()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u4e0b\u5355\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAddressBo()) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverProvinceId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u7701\u4efd\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverProvinceName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverCityId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u5730\u5e02\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverCityName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u5730\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverCountyId())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverCountyName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverAddress())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverCompany())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverMobileNumber())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAddressBo().getReceiverManufacturerName())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u6536\u8d27\u4fe1\u606f\u6536\u8d27\u5382\u5bb6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getItemBos())) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocDaYaoOrderCreateItemBo itemBo : reqBo.getItemBos()) {
            boolean purchaseCountInt;
            if (null == itemBo) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSpuId() || 0L == itemBo.getSpuId()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuId() || 0L == itemBo.getSkuId()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuSource()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5355\u54c1\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getPurchaseCount() || itemBo.getPurchaseCount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u91c7\u8d2d\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            try {
                itemBo.getPurchaseCount().intValueExact();
                purchaseCountInt = true;
            }
            catch (ArithmeticException exception) {
                purchaseCountInt = false;
            }
            if (!purchaseCountInt) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u91c7\u8d2d\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            if (null == itemBo.getSupNo() || 0L == itemBo.getSupNo()) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != itemBo.getSupplierShopId() && 0L != itemBo.getSupplierShopId()) continue;
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

