/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.self.comb.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.ability.api.UccMallScoreSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallScoreSpuBO;
import com.tydic.commodity.mall.ability.bo.UccMallScoreSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallScoreSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallScoreSpuReqBO;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateAbilityReqBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateAbilityRspBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateInfoBo;
import com.tydic.order.ability.bo.UocDaYaoOrderCreateItemBo;
import com.tydic.umc.general.ability.api.UmcQryPurInfoBusiInfoByPurIdAbilityService;
import com.tydic.umc.general.ability.bo.UmcOperLinkManInfoBO;
import com.tydic.umc.general.ability.bo.UmcQryPurInfoBusiInfoByPurIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryPurInfoBusiInfoByPurIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcSupplierInfoErpBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DaYaoMoneyUtil;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.self.busi.api.UocDaYaoPointOrderCreateBusiService;
import com.tydic.uoc.self.busi.bo.UocDaYaoOrderCreateBusiItemBo;
import com.tydic.uoc.self.busi.bo.UocDaYaoOrderCreateBusiReqBo;
import com.tydic.uoc.self.busi.bo.UocDaYaoOrderCreateBusiRspBo;
import com.tydic.uoc.self.busi.bo.UocDaYaoOrderCreateBusiStakeholderBo;
import com.tydic.uoc.self.comb.api.UocDaYaoPointOrderCreateCombService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocDaYaoPointOrderCreateCombServiceImpl
implements UocDaYaoPointOrderCreateCombService {
    private static final Logger log = LoggerFactory.getLogger(UocDaYaoPointOrderCreateCombServiceImpl.class);
    @Autowired
    private UccMallScoreSpuOrderListQueryAbilityService uccMallScoreSpuOrderListQueryAbilityService;
    @Autowired
    private UmcQryPurInfoBusiInfoByPurIdAbilityService umcQryPurInfoBusiInfoByPurIdAbilityService;
    @Autowired
    private UocDaYaoPointOrderCreateBusiService uocDaYaoPointOrderCreateBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @Override
    public UocDaYaoOrderCreateAbilityRspBo createPointOrder(UocDaYaoOrderCreateAbilityReqBo reqBo) {
        HashMap<Long, UocDaYaoOrderCreateBusiStakeholderBo> stakeholderBoMap = new HashMap<Long, UocDaYaoOrderCreateBusiStakeholderBo>(reqBo.getItemBos().size());
        LinkedHashMap<String, UocDaYaoOrderCreateBusiItemBo> skuAreaItemMap = new LinkedHashMap<String, UocDaYaoOrderCreateBusiItemBo>(reqBo.getItemBos().size());
        UccMallScoreSpuOrderListQueryAbilityReqBO uccMallReqBo = this.getSpuOrderInfo(reqBo, stakeholderBoMap, skuAreaItemMap);
        UmcQryPurInfoBusiInfoByPurIdAbilityRspBO infoByPurIdAbilityRspBO = this.getTripartiteInfo(reqBo, stakeholderBoMap);
        this.assembleTripartiteInfo(reqBo, stakeholderBoMap, infoByPurIdAbilityRspBO);
        UccMallScoreSpuOrderListQueryAbilityRspBO uccMallRspBo = this.uccMallScoreSpuOrderListQueryAbilityService.qryScoreSpuInfo(uccMallReqBo);
        if (!"0000".equals(uccMallRspBo.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + uccMallRspBo.getRespDesc());
        }
        for (UccMallScoreSpuBO uccMallScoreSpuBO : uccMallRspBo.getUccMallScoreSpuBOS()) {
            UocDaYaoOrderCreateBusiItemBo itemBo = (UocDaYaoOrderCreateBusiItemBo)skuAreaItemMap.get(String.valueOf(uccMallScoreSpuBO.getSkuId()));
            if (null == itemBo) {
                throw new UocProBusinessException("100001", "\u5546\u54c1\u4e2d\u5fc3\u51fa\u53c2\u548c\u5165\u53c2\u4e0d\u5339\u914d");
            }
            this.setPrice(uccMallScoreSpuBO, itemBo);
            if (itemBo.getPurchaseCount().compareTo(uccMallScoreSpuBO.getStockNum()) > 0) {
                throw new UocProBusinessException("100001", "\u5546\u54c1\u3010" + itemBo.getSkuName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
            }
            itemBo.setSkuCode(uccMallScoreSpuBO.getCommodityCode());
            itemBo.setSkuName(uccMallScoreSpuBO.getCommodityName());
            itemBo.setSpuId(uccMallScoreSpuBO.getCommodityId());
        }
        UocDaYaoOrderCreateBusiReqBo uocDaYaoOrderCreateBusiReqBo = this.assembleUocDaYaoOrderCreateBusiReqBo(reqBo, stakeholderBoMap, skuAreaItemMap);
        UocDaYaoOrderCreateAbilityRspBo rspBo = new UocDaYaoOrderCreateAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.saveOrderInfo(uocDaYaoOrderCreateBusiReqBo, rspBo);
        return rspBo;
    }

    private UocDaYaoOrderCreateBusiReqBo assembleUocDaYaoOrderCreateBusiReqBo(UocDaYaoOrderCreateAbilityReqBo reqBo, Map<Long, UocDaYaoOrderCreateBusiStakeholderBo> stakeholderBoMap, Map<String, UocDaYaoOrderCreateBusiItemBo> skuAreaItemMap) {
        UocDaYaoOrderCreateBusiReqBo busiReqBo = (UocDaYaoOrderCreateBusiReqBo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UocDaYaoOrderCreateBusiReqBo.class));
        busiReqBo.setModelSettle(UocCoreConstant.ModelSettle.MATCH_UP);
        busiReqBo.setOrderCategories(UocConstant.OrderCategories.POINTS_ORDER);
        busiReqBo.setItemBos(new ArrayList<UocDaYaoOrderCreateBusiItemBo>(skuAreaItemMap.size()));
        Long totalUsedIntegral = 0L;
        for (Map.Entry<String, UocDaYaoOrderCreateBusiItemBo> createItemBoEntry : skuAreaItemMap.entrySet()) {
            UocDaYaoOrderCreateBusiItemBo itemBoEntryValue = createItemBoEntry.getValue();
            if (null == busiReqBo.getStakeholderBo()) {
                busiReqBo.setStakeholderBo(stakeholderBoMap.get(itemBoEntryValue.getSupNo()));
            }
            if (null == busiReqBo.getOrderDesc()) {
                busiReqBo.setOrderDesc(itemBoEntryValue.getOrderDesc());
            }
            Long totalSaleFee = DaYaoMoneyUtil.bigDecimal2Long((BigDecimal)DaYaoMoneyUtil.long2BigDecimal((Long)itemBoEntryValue.getSkuSalePrice()).multiply(itemBoEntryValue.getPurchaseCount()));
            itemBoEntryValue.setTotalSaleFee(totalSaleFee);
            itemBoEntryValue.setTotalPurchaseFee(totalSaleFee);
            totalUsedIntegral = totalUsedIntegral + totalSaleFee;
            busiReqBo.getItemBos().add(itemBoEntryValue);
        }
        busiReqBo.setTotalSaleFee(totalUsedIntegral);
        busiReqBo.setSaleFee(totalUsedIntegral);
        busiReqBo.setTotalPurchaseFee(totalUsedIntegral);
        busiReqBo.setPurchaseFee(totalUsedIntegral);
        busiReqBo.setTotalUsedIntegral(totalUsedIntegral);
        return busiReqBo;
    }

    private void setPrice(UccMallScoreSpuBO uccMallScoreSpuBO, UocDaYaoOrderCreateBusiItemBo itemBo) {
        if (null == uccMallScoreSpuBO.getPrice() || uccMallScoreSpuBO.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new UocProBusinessException("100001", "\u5546\u54c1\u3010" + itemBo.getSkuName() + "\u3011\u4ef7\u683c\u4e0d\u5408\u6cd5\uff1a" + uccMallScoreSpuBO.getPrice());
        }
        itemBo.setSkuSalePrice(DaYaoMoneyUtil.bigDecimal2Long((BigDecimal)uccMallScoreSpuBO.getPrice()));
        itemBo.setSkuAgreementPrice(itemBo.getSkuSalePrice());
        itemBo.setSalePrice(itemBo.getSkuSalePrice());
        itemBo.setPurchasePrice(itemBo.getSkuSalePrice());
    }

    private void saveOrderInfo(UocDaYaoOrderCreateBusiReqBo busiReqBo, UocDaYaoOrderCreateAbilityRspBo rspBo) {
        UocDaYaoOrderCreateBusiRspBo busiRspBo = this.uocDaYaoPointOrderCreateBusiService.createPointOrder(busiReqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new UocProBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
        rspBo.setSuccessOrderIds(new ArrayList(1));
        rspBo.getSuccessOrderIds().add(JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBo)), UocDaYaoOrderCreateInfoBo.class));
        this.syncSaleInfo(busiRspBo);
    }

    private void assembleTripartiteInfo(UocDaYaoOrderCreateAbilityReqBo reqBo, Map<Long, UocDaYaoOrderCreateBusiStakeholderBo> stakeholderBoMap, UmcQryPurInfoBusiInfoByPurIdAbilityRspBO infoByPurIdAbilityRspBO) {
        for (UmcSupplierInfoErpBO supplierInfoErpBO : infoByPurIdAbilityRspBO.getSupplierInfoErpBOS()) {
            UocDaYaoOrderCreateBusiStakeholderBo stakeholderBo = new UocDaYaoOrderCreateBusiStakeholderBo();
            stakeholderBo.setPurNo(infoByPurIdAbilityRspBO.getPurInfoBO().getOrgId());
            stakeholderBo.setPurName(infoByPurIdAbilityRspBO.getPurInfoBO().getOrgName());
            stakeholderBo.setPurAccount(infoByPurIdAbilityRspBO.getPurInfoBO().getOrgId());
            stakeholderBo.setPurAccountName(infoByPurIdAbilityRspBO.getPurInfoBO().getOrgName());
            stakeholderBo.setPurPlaceOrderId(reqBo.getPurPlaceOrderId());
            stakeholderBo.setPurPlaceOrderName(reqBo.getPurPlaceOrderName());
            stakeholderBo.setPurOrgPath(infoByPurIdAbilityRspBO.getPurInfoBO().getOrgPath());
            stakeholderBo.setPurRelaName(String.valueOf(infoByPurIdAbilityRspBO.getPurInfoBO().getPurOrgLinkManName()));
            stakeholderBo.setPurRelaMobile(infoByPurIdAbilityRspBO.getPurInfoBO().getPurOrgLinkManTel());
            stakeholderBo.setCompanyId(infoByPurIdAbilityRspBO.getPurInfoBO().getCompanyId());
            stakeholderBo.setCompanyName(infoByPurIdAbilityRspBO.getPurInfoBO().getCompanyName());
            stakeholderBo.setPurLogName(reqBo.getPurLogName());
            stakeholderBo.setPurAccountOwnName(reqBo.getUsername());
            stakeholderBo.setPurAccountOwnId(reqBo.getOfficePhone());
            stakeholderBo.setPurMobile(infoByPurIdAbilityRspBO.getPurInfoBO().getDownOrderTel());
            stakeholderBo.setExtField3(infoByPurIdAbilityRspBO.getPurInfoBO().getPurErpOrgCode());
            stakeholderBo.setProNo(String.valueOf(infoByPurIdAbilityRspBO.getOperInfoBO().getOrgId()));
            stakeholderBo.setProName(infoByPurIdAbilityRspBO.getOperInfoBO().getOrgName());
            stakeholderBo.setProAccount(infoByPurIdAbilityRspBO.getOperInfoBO().getOrgPath());
            if (null != infoByPurIdAbilityRspBO.getOperInfoBO().getLinkManInfoList() && infoByPurIdAbilityRspBO.getOperInfoBO().getLinkManInfoList().size() == 1) {
                UmcOperLinkManInfoBO linkManInfoBO = (UmcOperLinkManInfoBO)infoByPurIdAbilityRspBO.getOperInfoBO().getLinkManInfoList().get(0);
                stakeholderBo.setProDeliveryId(String.valueOf(linkManInfoBO.getLinkManId()));
                stakeholderBo.setProDeliveryName(linkManInfoBO.getLinkManName());
                stakeholderBo.setExtField2(linkManInfoBO.getLinkManErpCode());
            }
            stakeholderBo.setSupNo(String.valueOf(supplierInfoErpBO.getSupplierOrgId()));
            stakeholderBo.setSupName(supplierInfoErpBO.getSupplierOrgName());
            stakeholderBo.setSupRelaName(String.valueOf(supplierInfoErpBO.getSupplierLinkManName()));
            stakeholderBo.setSupRelaMobile(supplierInfoErpBO.getSupplierLinkManTel());
            if (!UocConstant.SupType.THIRD_PART.equals(supplierInfoErpBO.getSupType()) && !UocConstant.SupType.DA_YAO_SELF.equals(supplierInfoErpBO.getSupType())) {
                throw new UocProBusinessException("103029", "\u4f9b\u5e94\u5546\u7c7b\u578b\u6807\u8bc6\u4e0d\u5408\u6cd5\uff1a" + supplierInfoErpBO.getSupType());
            }
            stakeholderBo.setExtField1(String.valueOf(supplierInfoErpBO.getSupType()));
            stakeholderBoMap.put(supplierInfoErpBO.getSupplierOrgId(), stakeholderBo);
        }
    }

    private UccMallScoreSpuOrderListQueryAbilityReqBO getSpuOrderInfo(UocDaYaoOrderCreateAbilityReqBo reqBo, Map<Long, UocDaYaoOrderCreateBusiStakeholderBo> stakeholderBoMap, Map<String, UocDaYaoOrderCreateBusiItemBo> skuAreaItemMap) {
        UccMallScoreSpuOrderListQueryAbilityReqBO uccMallReqBo = (UccMallScoreSpuOrderListQueryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UccMallScoreSpuOrderListQueryAbilityReqBO.class);
        uccMallReqBo.setOrgIdIn(reqBo.getPurNo());
        uccMallReqBo.setCompanyId(reqBo.getPurNo());
        ArrayList<UccMallScoreSpuReqBO> skuOrderList = new ArrayList<UccMallScoreSpuReqBO>(reqBo.getItemBos().size());
        for (UocDaYaoOrderCreateItemBo itemBo : reqBo.getItemBos()) {
            UccMallScoreSpuReqBO uccMallSkuOrderQryReqBO = new UccMallScoreSpuReqBO();
            uccMallSkuOrderQryReqBO.setCommodityId(itemBo.getSpuId());
            uccMallSkuOrderQryReqBO.setSkuId(itemBo.getSkuId());
            uccMallSkuOrderQryReqBO.setNum(Integer.valueOf(itemBo.getPurchaseCount().intValue()));
            uccMallSkuOrderQryReqBO.setValidateStock(Integer.valueOf(0));
            skuOrderList.add(uccMallSkuOrderQryReqBO);
            if (!stakeholderBoMap.containsKey(itemBo.getSupNo())) {
                stakeholderBoMap.put(itemBo.getSupNo(), null);
            }
            skuAreaItemMap.put(String.valueOf(itemBo.getSkuId()), (UocDaYaoOrderCreateBusiItemBo)JSON.parseObject((String)JSON.toJSONString((Object)itemBo), UocDaYaoOrderCreateBusiItemBo.class));
        }
        uccMallReqBo.setUccMallScoreSpuReqBOList(skuOrderList);
        return uccMallReqBo;
    }

    private UmcQryPurInfoBusiInfoByPurIdAbilityRspBO getTripartiteInfo(UocDaYaoOrderCreateAbilityReqBo reqBo, Map<Long, UocDaYaoOrderCreateBusiStakeholderBo> stakeholderBoMap) {
        UmcQryPurInfoBusiInfoByPurIdAbilityReqBO infoByPurIdAbilityReqBO = new UmcQryPurInfoBusiInfoByPurIdAbilityReqBO();
        infoByPurIdAbilityReqBO.setPurchaseId(reqBo.getPurNo());
        infoByPurIdAbilityReqBO.setSupplierIdList(new ArrayList<Long>(stakeholderBoMap.keySet()));
        infoByPurIdAbilityReqBO.setDownOrderMemId(Long.valueOf(reqBo.getPurPlaceOrderId()));
        UmcQryPurInfoBusiInfoByPurIdAbilityRspBO infoByPurIdAbilityRspBO = this.umcQryPurInfoBusiInfoByPurIdAbilityService.qryPurInfoBusiInfoByPurId(infoByPurIdAbilityReqBO);
        if (!"0000".equals(infoByPurIdAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException("103029", "\u67e5\u8be2\u91c7\u8d2d\u3001\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + infoByPurIdAbilityRspBO.getRespDesc());
        }
        return infoByPurIdAbilityRspBO;
    }

    private void syncSaleInfo(UocDaYaoOrderCreateBusiRspBo rspBo) {
        UocPebOrdIdxSyncReqBO reqBo = new UocPebOrdIdxSyncReqBO();
        reqBo.setOrderId(rspBo.getOrderId());
        reqBo.setIsStatistics(Boolean.valueOf(false));
        reqBo.setObjId(rspBo.getSaleVoucherId());
        reqBo.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBo)));
    }
}

