/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.self.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DaYaoMoneyUtil;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocDaYaoHttpUtilsRspBo;
import com.tydic.uoc.common.atom.bo.UocDaYaoSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocDaYaoSaveOutInterfaceLogAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocDaYaoSaveOutInterfaceLogBusiService;
import com.tydic.uoc.common.busi.bo.UocDaYaoHuanSiErpBaseRspBo;
import com.tydic.uoc.common.busi.bo.UocDaYaoHuanSiErpOrderCreateItemBo;
import com.tydic.uoc.common.busi.bo.UocDaYaoHuanSiErpOrderCreateReqBo;
import com.tydic.uoc.common.busi.bo.UocDaYaoHuanSiErpOrderCreateRspBo;
import com.tydic.uoc.common.utils.UocDaYaoHttpUtils;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.self.busi.api.UocDaYaoHuanSiErpOrderCreateBusiService;
import com.tydic.uoc.self.busi.bo.UocDaYaoHuanSiErpOrderCreateBusiReqBo;
import com.tydic.uoc.self.busi.bo.UocDaYaoHuanSiErpOrderCreateBusiRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UocDaYaoHuanSiErpOrderCreateBusiServiceImpl
implements UocDaYaoHuanSiErpOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocDaYaoHuanSiErpOrderCreateBusiServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocDaYaoSaveOutInterfaceLogBusiService uocDaYaoSaveOutInterfaceLogBusiService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    @Override
    public UocDaYaoHuanSiErpOrderCreateBusiRspBo createHuanSiErpOrder(UocDaYaoHuanSiErpOrderCreateBusiReqBo reqBo) {
        UocDaYaoHuanSiErpOrderCreateBusiRspBo rspBo = new UocDaYaoHuanSiErpOrderCreateBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealErpLogic(UocDaYaoHuanSiErpOrderCreateBusiReqBo reqBo, UocDaYaoHuanSiErpOrderCreateBusiRspBo rspBo) {
        OrderPO orderPO = this.orderMapper.getModelById(reqBo.getOrderId().longValue());
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBo.getOrderId().longValue());
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBo.getOrderId());
        salePO.setSaleVoucherId(reqBo.getSaleVoucherId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdLogisticsRelaPO logisticsRelaPO = new OrdLogisticsRelaPO();
        logisticsRelaPO.setOrderId(reqBo.getOrderId());
        logisticsRelaPO.setContactId(salePO.getContactId());
        logisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(logisticsRelaPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBo.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        UocDaYaoHuanSiErpOrderCreateReqBo erpOrderCreateReqBo = new UocDaYaoHuanSiErpOrderCreateReqBo();
        erpOrderCreateReqBo.setBatchShipment(Integer.valueOf(0));
        erpOrderCreateReqBo.setBillDate(DateUtils.dateToStrLong((Date)orderPO.getCreateTime()));
        erpOrderCreateReqBo.setCheckItemId(stakeholderPO.getSupNo());
        if (UocConstant.DaYaoPayType.OFFLINE_PAYMENTS.equals(salePO.getPayType())) {
            if (UocConstant.PayMod.BANK_TRANSFER.equals(salePO.getPayMod())) {
                erpOrderCreateReqBo.setPaymentMethod("4");
            } else {
                erpOrderCreateReqBo.setPaymentMethod("5");
            }
        } else if (UocConstant.DaYaoPayType.PRE_DEPOSIT.equals(salePO.getPayType())) {
            erpOrderCreateReqBo.setPaymentMethod("7");
        }
        if (UocConstant.DaYaoPayType.BILLING_PERIOD.equals(salePO.getPayType())) {
            erpOrderCreateReqBo.setSettlementMethod("2");
        } else {
            erpOrderCreateReqBo.setSettlementMethod("1");
        }
        erpOrderCreateReqBo.setReceiveAddress(logisticsRelaPO.getContactAddress());
        erpOrderCreateReqBo.setReceiveDistrict(logisticsRelaPO.getContactCityName() + logisticsRelaPO.getContactCountyName() + logisticsRelaPO.getContactTown());
        erpOrderCreateReqBo.setReceiveProvince(logisticsRelaPO.getContactProvinceName());
        erpOrderCreateReqBo.setReceiver(logisticsRelaPO.getContactName());
        erpOrderCreateReqBo.setReceiverContact(logisticsRelaPO.getContactMobile());
        erpOrderCreateReqBo.setContacts(stakeholderPO.getPurPlaceOrderId());
        erpOrderCreateReqBo.setSalesPerson(salePO.getBusinessManId());
        if (UocConstant.OrderCategories.MATERIAL_ORDER.equals(salePO.getOrderCategories())) {
            erpOrderCreateReqBo.setSalesType("SpotSales");
        } else {
            erpOrderCreateReqBo.setSalesType("ServiceOrder");
        }
        if (UocConstant.DeliveryMethod.SELF_MENTION.equals(salePO.getDeliveryMethod())) {
            erpOrderCreateReqBo.setShipType("1");
        } else if (UocConstant.DeliveryMethod.DA_YAO_LOGISTICS.equals(salePO.getDeliveryMethod())) {
            erpOrderCreateReqBo.setShipType("2");
        } else {
            erpOrderCreateReqBo.setShipType("5");
        }
        if (UocConstant.SingleDiscussion.YES.equals(salePO.getSingleDiscussion())) {
            erpOrderCreateReqBo.setSingleBargaining(Integer.valueOf(1));
        } else {
            erpOrderCreateReqBo.setSingleBargaining(Integer.valueOf(0));
        }
        erpOrderCreateReqBo.setSourceBillNo(salePO.getSaleVoucherNo());
        erpOrderCreateReqBo.setTotalAmount(DaYaoMoneyUtil.long2BigDecimalKeep((Long)salePO.getSaleFee()));
        erpOrderCreateReqBo.setOrderDetailList(new ArrayList(itemPOS.size()));
        for (OrdItemPO itemPO : itemPOS) {
            UocDaYaoHuanSiErpOrderCreateItemBo createItemBo = new UocDaYaoHuanSiErpOrderCreateItemBo();
            createItemBo.setDiscountRate(BigDecimal.ZERO);
            createItemBo.setMaterialId(itemPO.getExtField3());
            createItemBo.setOverflowRate(BigDecimal.ZERO);
            createItemBo.setPurchaser(itemPO.getExtField1());
            createItemBo.setQty(itemPO.getPurchaseCount());
            createItemBo.setShortageRate(BigDecimal.ZERO);
            createItemBo.setSku(itemPO.getSkuId());
            createItemBo.setTaxIncludePrice(DaYaoMoneyUtil.long2BigDecimal((Long)itemPO.getSalePrice()));
            createItemBo.setDetailId(String.valueOf(itemPO.getOrdItemId()));
            erpOrderCreateReqBo.getOrderDetailList().add(createItemBo);
        }
        String body = JSON.toJSONString((Object)erpOrderCreateReqBo);
        Date callTime = new Date();
        UocDaYaoHttpUtilsRspBo httpUtilsRspBo = UocDaYaoHttpUtils.doPost((Integer)UocConstant.UrlName.ORDER_CREATE_URL, (String)body, null);
        ((UocDaYaoHuanSiErpOrderCreateBusiServiceImpl)AopContext.currentProxy()).saveOutInterfaceLog(reqBo, body, httpUtilsRspBo, callTime);
        if (!"0000".equals(httpUtilsRspBo.getRespCode())) {
            throw new UocProBusinessException(httpUtilsRspBo.getRespCode(), httpUtilsRspBo.getRespDesc());
        }
        UocDaYaoHuanSiErpBaseRspBo erpOrderCreateRspBo = (UocDaYaoHuanSiErpBaseRspBo)JSON.parseObject((String)httpUtilsRspBo.getContent(), (TypeReference)new TypeReference<UocDaYaoHuanSiErpBaseRspBo<UocDaYaoHuanSiErpOrderCreateRspBo>>(){}, (Feature[])new Feature[0]);
        if (!UocConstant.ErpCode.SUCCESS.equals(erpOrderCreateRspBo.getCode())) {
            orderPO = new OrderPO();
            orderPO.setOrderId(reqBo.getOrderId());
            orderPO.setCancelTime(new Date());
            orderPO.setCancelDesc("ERP\u65b9\u5931\u8d25\u539f\u56e0\uff1a" + erpOrderCreateRspBo.getMsg());
            this.orderMapper.updateById(orderPO);
            rspBo.setRespCode("102210");
            rspBo.setRespDesc(orderPO.getOrderDesc());
            rspBo.setSaleState(Integer.valueOf(this.run(reqBo)));
            this.dicSaleState(rspBo);
        } else if (StringUtils.isNotBlank((CharSequence)((UocDaYaoHuanSiErpOrderCreateRspBo)erpOrderCreateRspBo.getData()).getId())) {
            ((UocDaYaoHuanSiErpOrderCreateBusiServiceImpl)AopContext.currentProxy()).saveOutId(((UocDaYaoHuanSiErpOrderCreateRspBo)erpOrderCreateRspBo.getData()).getId(), salePO);
        }
    }

    @Async(value="uocDaYaoTaskExecutor")
    void saveOutId(String id, OrdSalePO salePO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleVoucherId(salePO.getSaleVoucherId());
        ordSalePO.setOrderId(salePO.getOrderId());
        ordSalePO.setOutOrderId(id);
        this.ordSaleMapper.updateById(ordSalePO);
    }

    private void dicSaleState(UocDaYaoHuanSiErpOrderCreateBusiRspBo rspBo) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(String.valueOf(rspBo.getSaleState()));
        dictReqBO.setPcode("SALE_STATUS");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            rspBo.setSaleStateStr(dictRspBO.getDicDictionarys().getDescrip());
        }
    }

    private String run(UocDaYaoHuanSiErpOrderCreateBusiReqBo reqBo) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setObjId(reqBo.getSaleVoucherId());
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBo.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBo.getUserId()));
        processRunReqBO.setOperName(reqBo.getUsername());
        HashMap<String, Integer> variables = new HashMap<String, Integer>(1);
        variables.put("confirmFlag", 2);
        processRunReqBO.setVariables(variables);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u6d41\u8f6c\u72b6\u6001\u5931\u8d25\uff1a" + uocProcessRunRspBO.getRespDesc());
        }
        return uocProcessRunRspBO.getStepId();
    }

    @Async(value="uocDaYaoTaskExecutor")
    void saveOutInterfaceLog(UocDaYaoHuanSiErpOrderCreateBusiReqBo reqBo, String body, UocDaYaoHttpUtilsRspBo httpUtilsRspBo, Date callTime) {
        UocDaYaoSaveOutInterfaceLogAtomReqBo logAtomReqBo = new UocDaYaoSaveOutInterfaceLogAtomReqBo();
        logAtomReqBo.setObjId(reqBo.getSaleVoucherId());
        logAtomReqBo.setObjType(UocConstant.OBJ_TYPE.SALE);
        logAtomReqBo.setOrderId(reqBo.getOrderId());
        logAtomReqBo.setInterSn("ERP JK18\u7535\u5546\u8ba2\u5355\u65b0\u589e");
        logAtomReqBo.setInterCode("ACTION19");
        logAtomReqBo.setFlowFlag(UocConstant.FLOW_FLAG.POSITIVE);
        logAtomReqBo.setInContent(body);
        logAtomReqBo.setOutContent(JSON.toJSONString((Object)httpUtilsRspBo));
        logAtomReqBo.setCallTime(callTime);
        logAtomReqBo.setRetTime(new Date());
        UocDaYaoSaveOutInterfaceLogAtomRspBo logAtomRspBo = this.uocDaYaoSaveOutInterfaceLogBusiService.keepOutInterfaceLog(logAtomReqBo);
        if (!"0000".equals(logAtomRspBo.getRespCode())) {
            log.info("\u4fdd\u5b58\u5916\u90e8\u63a5\u53e3\u65e5\u5fd7\u5931\u8d25\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)logAtomRspBo));
        }
    }
}

