/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.desensitize.codec.encypt.interceptor;

import com.tydic.desensitize.codec.encypt.SensitiveData;
import com.tydic.desensitize.codec.encypt.util.DecryptImpl;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ResultSetInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object resultObject = invocation.proceed();
        if (Objects.isNull(resultObject)) {
            return null;
        }
        if (resultObject instanceof ArrayList) {
            ArrayList resultList = (ArrayList)resultObject;
            if (!CollectionUtils.isEmpty((Collection)resultList) && this.needToDecrypt(resultList.get(0))) {
                for (Object result : resultList) {
                    DecryptImpl.decrypt(result);
                }
            }
        } else if (this.needToDecrypt(resultObject)) {
            DecryptImpl.decrypt(resultObject);
        }
        return resultObject;
    }

    private boolean needToDecrypt(Object object) {
        Class<?> objectClass = object.getClass();
        SensitiveData sensitiveData = (SensitiveData)AnnotationUtils.findAnnotation(objectClass, SensitiveData.class);
        return Objects.nonNull(sensitiveData);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

