/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.desensitize.codec.encypt.interceptor;

import com.baomidou.mybatisplus.core.MybatisParameterHandler;
import com.tydic.desensitize.codec.encypt.SensitiveData;
import com.tydic.desensitize.codec.encypt.SensitiveField;
import com.tydic.desensitize.codec.encypt.util.AesUtil;
import com.tydic.desensitize.codec.encypt.util.EncryptImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class ParameterInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ParameterInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        DefaultParameterHandler parameterHandler = null;
        if (DefaultParameterHandler.class.isInstance(invocation.getTarget())) {
            parameterHandler = (DefaultParameterHandler)invocation.getTarget();
        } else if (MybatisParameterHandler.class.isInstance(invocation.getTarget())) {
            parameterHandler = (MybatisParameterHandler)invocation.getTarget();
        }
        Field parameterField = parameterHandler.getClass().getDeclaredField("parameterObject");
        parameterField.setAccessible(true);
        Object parameterObject = parameterField.get(parameterHandler);
        List<String> paramNames = this.searchParamAnnotation((ParameterHandler)parameterHandler);
        if (parameterObject != null) {
            Class<?> parameterObjectClass = parameterObject.getClass();
            SensitiveData sensitiveData = (SensitiveData)AnnotationUtils.findAnnotation(parameterObjectClass, SensitiveData.class);
            if (Objects.nonNull(sensitiveData)) {
                Field[] declaredFields = parameterObjectClass.getDeclaredFields();
                EncryptImpl.encrypt(declaredFields, parameterObject);
            }
            this.processListParam(parameterObject);
            if (!CollectionUtils.isEmpty(paramNames)) {
                Field boundSqlField = parameterHandler.getClass().getDeclaredField("boundSql");
                boundSqlField.setAccessible(true);
                BoundSql boundSql = (BoundSql)boundSqlField.get(parameterHandler);
                PreparedStatement ps = (PreparedStatement)invocation.getArgs()[0];
                this.processParam(parameterObject, paramNames);
                parameterField.set(parameterHandler, parameterObject);
                parameterHandler.setParameters(ps);
            }
        }
        return invocation.proceed();
    }

    private void processListParam(Object parameterObject) throws IllegalAccessException {
        if (parameterObject instanceof Map) {
            Object element;
            Class<?> elementClass;
            SensitiveData tempSensitiveData;
            ArrayList list;
            Object param1;
            Map map;
            if (((Map)parameterObject).containsKey("list")) {
                Object element2;
                Class<?> elementClass2;
                SensitiveData tempSensitiveData2;
                map = (Map)parameterObject;
                ArrayList list2 = (ArrayList)map.get("list");
                if (!(list2 instanceof ArrayList)) {
                    list2 = new ArrayList(list2);
                }
                if (list2.size() > 0 && Objects.nonNull(tempSensitiveData2 = (SensitiveData)AnnotationUtils.findAnnotation(elementClass2 = (element2 = list2.get(0)).getClass(), SensitiveData.class))) {
                    for (Object elementObject : list2) {
                        Field[] declaredFields = elementClass2.getDeclaredFields();
                        EncryptImpl.encrypt(declaredFields, elementObject);
                    }
                }
            }
            if (((Map)parameterObject).containsKey("param1") && (param1 = (map = (Map)parameterObject).get("param1")) instanceof ArrayList && (list = (ArrayList)param1).size() > 0 && Objects.nonNull(tempSensitiveData = (SensitiveData)AnnotationUtils.findAnnotation(elementClass = (element = list.get(0)).getClass(), SensitiveData.class))) {
                for (Object elementObject : list) {
                    Field[] declaredFields = elementClass.getDeclaredFields();
                    EncryptImpl.encrypt(declaredFields, elementObject);
                }
            }
        }
    }

    private void processParam(Object parameterObject, List<String> params) throws Exception {
        if (parameterObject instanceof Map) {
            Map map = (Map)parameterObject;
            Iterator<String> iterator = params.iterator();
            while (iterator.hasNext()) {
                String param;
                String value = (String)map.get(param = iterator.next());
                map.put(param, value == null ? null : AesUtil.encrypt(value));
            }
        }
    }

    private List<String> searchParamAnnotation(ParameterHandler parameterHandler) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        Field mappedStatementFiled = null;
        if (MybatisParameterHandler.class.isInstance(parameterHandler)) {
            Class<MybatisParameterHandler> handlerClass = MybatisParameterHandler.class;
            mappedStatementFiled = handlerClass.getDeclaredField("mappedStatement");
        } else if (DefaultParameterHandler.class.isInstance(parameterHandler)) {
            Class<DefaultParameterHandler> defaultHandlerClass = DefaultParameterHandler.class;
            mappedStatementFiled = defaultHandlerClass.getDeclaredField("mappedStatement");
        }
        mappedStatementFiled.setAccessible(true);
        MappedStatement mappedStatement = (MappedStatement)mappedStatementFiled.get(parameterHandler);
        String methodName = mappedStatement.getId();
        Class<?> mapperClass = Class.forName(methodName.substring(0, methodName.lastIndexOf(46)));
        methodName = methodName.substring(methodName.lastIndexOf(46) + 1);
        Method[] methods = mapperClass.getDeclaredMethods();
        Method method = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        ArrayList<String> paramNames = null;
        if (method != null) {
            Annotation[][] pa = method.getParameterAnnotations();
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < pa.length; ++i) {
                for (Annotation annotation : pa[i]) {
                    if (!(annotation instanceof SensitiveField)) continue;
                    if (paramNames == null) {
                        paramNames = new ArrayList<String>();
                    }
                    paramNames.add(parameters[i].getName());
                }
            }
        }
        return paramNames;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

