/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.desensitize.codec.tm;

import com.tydic.desensitize.codec.tm.SecretColumn;
import com.tydic.desensitize.codec.tm.SecretStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class DesensitizeValueFilter {
    private static final Map<String, SecretStrategy> CACHE = new ConcurrentHashMap<String, SecretStrategy>();

    public static Object process(Object object, String name, Object value) {
        if (object == null || !(value instanceof String)) {
            return value;
        }
        try {
            String flag;
            RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
            if (attrs != null && Objects.equals(flag = (String)attrs.getAttribute("isDesensitized", 0), "1")) {
                return value;
            }
        }
        catch (Exception e) {
            return value;
        }
        SecretStrategy strategy = DesensitizeValueFilter.resolveStrategy(object.getClass(), name);
        if (strategy == null) {
            return value;
        }
        return strategy.getDesensitizer().apply((String)value);
    }

    private static SecretStrategy resolveStrategy(Class<?> clazz, String name) {
        String key = clazz.getName() + "#" + name;
        SecretStrategy cached = CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        SecretStrategy strategy = DesensitizeValueFilter.findOnFieldOrGetter(clazz, name);
        if (strategy != null) {
            CACHE.put(key, strategy);
        }
        return strategy;
    }

    private static SecretStrategy findOnFieldOrGetter(Class<?> clazz, String name) {
        String[] candidates;
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(name);
                SecretColumn ann = f.getAnnotation(SecretColumn.class);
                if (ann == null) continue;
                return ann.strategy();
            }
            catch (NoSuchFieldException f) {
                // empty catch block
            }
        }
        String suffix = name.substring(0, 1).toUpperCase() + name.substring(1);
        for (String mName : candidates = new String[]{"get" + suffix, "is" + suffix}) {
            for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
                try {
                    Method m = c.getDeclaredMethod(mName, new Class[0]);
                    SecretColumn ann = m.getAnnotation(SecretColumn.class);
                    if (ann == null) continue;
                    return ann.strategy();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

