/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.bo.RspUccPageBo;
import com.tydic.commodity.bo.busi.DelAccessoryTemplateReqBO;
import com.tydic.commodity.busi.api.UccAccessoryTemplateService;
import com.tydic.order.pec.ability.es.order.UocPebAccessoryTemplateAbilityService;
import com.tydic.order.pec.busi.es.order.bo.UocPebAccessoryTemplateBusiReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebAddAccessoryTemplateBusiReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebAddAccessoryTemplateBusiRspBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebDelAccessoryTemplateBusiReqBO;
import com.tydic.order.pec.busi.es.order.bo.UocPebDelAccessoryTemplateBusiRspBO;
import com.tydic.order.uoc.bo.common.CustomRspPageBO;
import com.tydic.pesapp.common.ability.ComPesTemplateOperateService;
import com.tydic.pesapp.common.ability.bo.ComPesRspPageBO;
import com.tydic.pesapp.common.ability.bo.ComPesTemplateConfigBO;
import com.tydic.pesapp.common.ability.bo.ComPesTemplateOperateReqBO;
import com.tydic.pesapp.common.ability.bo.ComPesTemplateOperateRspBO;
import com.tydic.pesapp.common.ability.bo.ComPesTemplateQueryReqBO;
import com.tydic.pesapp.common.ability.bo.ComPesTemplateQueryRspBO;
import com.tydic.pfscext.api.busi.AccessoryTemplateService;
import com.tydic.pfscext.api.busi.bo.AddAccessoryTemplateRspBO;
import com.tydic.pfscext.api.busi.bo.DelAccessoryTemplateRspBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.umc.ability.UmcAccessoryTemplateAbilityService;
import com.tydic.umc.base.bo.UmcRspBaseBO;
import com.tydic.umc.base.bo.UmcRspPageBO;
import com.tydic.umc.common.AccessoryTemplateReqBO;
import com.tydic.umc.common.AddAccessoryTemplateReqBO;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ComPesTemplateOperateServiceImpl
implements ComPesTemplateOperateService {
    public static final String PEB_CODE = "PEB";
    public static final String UMC_CODE = "UMC";
    public static final String UCC_CODE = "UCC";
    public static final String FSC_CODE = "FSC";
    public static final Integer OPERATE_TYPE_QUERY = 0;
    public static final Integer OPERATE_TYPE_INSERT = 1;
    public static final Integer OPERATE_TYPE_UPDATE = 2;
    public static final Integer OPERATE_TYPE_DELETE = 3;
    private static Map<String, BiFunction<Integer, ComPesTemplateConfigBO, ComPesRspPageBO>> dicActionMap = Maps.newHashMapWithExpectedSize((int)4);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private AccessoryTemplateService accessoryTemplateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_TEST")
    private UocPebAccessoryTemplateAbilityService ucPebAccessoryTemplateAbilityService;
    @HSFConsumer(serviceVersion="1.0.1", serviceGroup="UCC_GROUP_TEST")
    private UccAccessoryTemplateService uccAccessoryTemplateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcAccessoryTemplateAbilityService umcAccessoryTemplateAbilityService;

    public ComPesTemplateOperateServiceImpl() {
        dicActionMap.put(FSC_CODE, this::callFscTemplateService);
        dicActionMap.put(PEB_CODE, this::callPebTemplateService);
        dicActionMap.put(UMC_CODE, this::callUmcTemplateService);
        dicActionMap.put(UCC_CODE, this::callUccTemplateService);
    }

    public ComPesTemplateQueryRspBO queryTemplateList(ComPesTemplateQueryReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        ComPesTemplateConfigBO templateConfig = new ComPesTemplateConfigBO();
        templateConfig.setAccessoryCode(reqBO.getAccessoryCode());
        templateConfig.setAccessoryName(reqBO.getAccessoryName());
        ComPesRspPageBO qryRspBO = dicActionMap.get(reqBO.getCenter()).apply(OPERATE_TYPE_QUERY, templateConfig);
        ComPesTemplateQueryRspBO rspBO = new ComPesTemplateQueryRspBO();
        BeanUtils.copyProperties((Object)qryRspBO, (Object)rspBO);
        return rspBO;
    }

    public ComPesTemplateOperateRspBO dealTemplateOperate(ComPesTemplateOperateReqBO reqBO) {
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u4f20\u5165[operateType]\u4e3a\u7a7a");
        }
        if (!OPERATE_TYPE_INSERT.equals(reqBO.getOperateType()) && !OPERATE_TYPE_DELETE.equals(reqBO.getOperateType())) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[operateType]");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        ComPesTemplateConfigBO templateConfig = new ComPesTemplateConfigBO();
        BeanUtils.copyProperties((Object)reqBO.getTemplateConfig(), (Object)templateConfig);
        templateConfig.setCreateOperId(String.valueOf(reqBO.getMemIdExt()));
        ComPesRspPageBO operateRspBO = dicActionMap.get(reqBO.getCenter()).apply(reqBO.getOperateType(), templateConfig);
        ComPesTemplateOperateRspBO rspBO = new ComPesTemplateOperateRspBO();
        rspBO.setRespCode(operateRspBO.getRespCode());
        rspBO.setRespDesc(operateRspBO.getRespDesc());
        return rspBO;
    }

    private ComPesRspPageBO callPebTemplateService(Integer operateType, ComPesTemplateConfigBO templateConfig) {
        ComPesRspPageBO rspBO = new ComPesRspPageBO();
        if (OPERATE_TYPE_QUERY.equals(operateType)) {
            UocPebAccessoryTemplateBusiReqBO reqBO = new UocPebAccessoryTemplateBusiReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            reqBO.setAccessoryName(templateConfig.getAccessoryName());
            CustomRspPageBO qryRspBO = this.ucPebAccessoryTemplateAbilityService.qryAccessoryTemplateList(reqBO);
            BeanUtils.copyProperties((Object)qryRspBO, (Object)rspBO);
        } else if (OPERATE_TYPE_INSERT.equals(operateType)) {
            UocPebAddAccessoryTemplateBusiReqBO reqBO = new UocPebAddAccessoryTemplateBusiReqBO();
            BeanUtils.copyProperties((Object)templateConfig, (Object)reqBO);
            UocPebAddAccessoryTemplateBusiRspBO addRspBO = this.ucPebAccessoryTemplateAbilityService.addAccessoryTemplate(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (OPERATE_TYPE_DELETE.equals(operateType)) {
            UocPebDelAccessoryTemplateBusiReqBO reqBO = new UocPebDelAccessoryTemplateBusiReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            UocPebDelAccessoryTemplateBusiRspBO delRspBO = this.ucPebAccessoryTemplateAbilityService.deleteAccessoryTemplate(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return rspBO;
    }

    private ComPesRspPageBO callUmcTemplateService(Integer operateType, ComPesTemplateConfigBO templateConfig) {
        ComPesRspPageBO rspBO = new ComPesRspPageBO();
        if (OPERATE_TYPE_QUERY.equals(operateType)) {
            AccessoryTemplateReqBO reqBO = new AccessoryTemplateReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            reqBO.setAccessoryName(templateConfig.getAccessoryName());
            UmcRspPageBO qryRspBO = this.umcAccessoryTemplateAbilityService.qryAccessoryTemplateList(reqBO);
            BeanUtils.copyProperties((Object)qryRspBO, (Object)rspBO);
        } else if (OPERATE_TYPE_INSERT.equals(operateType)) {
            AddAccessoryTemplateReqBO reqBO = new AddAccessoryTemplateReqBO();
            BeanUtils.copyProperties((Object)templateConfig, (Object)reqBO);
            UmcRspBaseBO addRspBO = this.umcAccessoryTemplateAbilityService.addAccessoryTemplate(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (OPERATE_TYPE_DELETE.equals(operateType)) {
            AccessoryTemplateReqBO reqBO = new AccessoryTemplateReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            UmcRspBaseBO delRspBO = this.umcAccessoryTemplateAbilityService.deleteAccessoryTemplate(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return rspBO;
    }

    private ComPesRspPageBO callUccTemplateService(Integer operateType, ComPesTemplateConfigBO templateConfig) {
        ComPesRspPageBO rspBO = new ComPesRspPageBO();
        if (OPERATE_TYPE_QUERY.equals(operateType)) {
            com.tydic.commodity.bo.busi.AccessoryTemplateReqBO reqBO = new com.tydic.commodity.bo.busi.AccessoryTemplateReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            reqBO.setAccessoryName(templateConfig.getAccessoryName());
            RspUccPageBo qryRspBO = this.uccAccessoryTemplateService.qryAccessoryTemplateList(reqBO);
            BeanUtils.copyProperties((Object)qryRspBO, (Object)rspBO);
        } else if (OPERATE_TYPE_INSERT.equals(operateType)) {
            com.tydic.commodity.bo.busi.AddAccessoryTemplateReqBO reqBO = new com.tydic.commodity.bo.busi.AddAccessoryTemplateReqBO();
            BeanUtils.copyProperties((Object)templateConfig, (Object)reqBO);
            com.tydic.commodity.bo.busi.AddAccessoryTemplateRspBO addRspBO = this.uccAccessoryTemplateService.addAccessoryTemplate(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (OPERATE_TYPE_DELETE.equals(operateType)) {
            DelAccessoryTemplateReqBO reqBO = new DelAccessoryTemplateReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            com.tydic.commodity.bo.busi.DelAccessoryTemplateRspBO delRspBO = this.uccAccessoryTemplateService.deleteAccessoryTemplate(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return rspBO;
    }

    private ComPesRspPageBO callFscTemplateService(Integer operateType, ComPesTemplateConfigBO templateConfig) {
        ComPesRspPageBO rspBO = new ComPesRspPageBO();
        if (OPERATE_TYPE_QUERY.equals(operateType)) {
            com.tydic.pfscext.api.busi.bo.AccessoryTemplateReqBO reqBO = new com.tydic.pfscext.api.busi.bo.AccessoryTemplateReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            reqBO.setAccessoryName(templateConfig.getAccessoryName());
            PfscExtRspPageBaseBO qryRspBO = this.accessoryTemplateService.qryAccessoryTemplateList(reqBO);
            BeanUtils.copyProperties((Object)qryRspBO, (Object)rspBO);
        } else if (OPERATE_TYPE_INSERT.equals(operateType)) {
            com.tydic.pfscext.api.busi.bo.AddAccessoryTemplateReqBO reqBO = new com.tydic.pfscext.api.busi.bo.AddAccessoryTemplateReqBO();
            BeanUtils.copyProperties((Object)templateConfig, (Object)reqBO);
            AddAccessoryTemplateRspBO addRspBO = this.accessoryTemplateService.addAccessoryTemplate(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (OPERATE_TYPE_DELETE.equals(operateType)) {
            com.tydic.pfscext.api.busi.bo.DelAccessoryTemplateReqBO reqBO = new com.tydic.pfscext.api.busi.bo.DelAccessoryTemplateReqBO();
            reqBO.setAccessoryCode(templateConfig.getAccessoryCode());
            DelAccessoryTemplateRspBO delRspBO = this.accessoryTemplateService.deleteAccessoryTemplate(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return rspBO;
    }
}

