/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.estore.operator.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.pesapp.base.api.JsonBusiResponseBody;
import com.tydic.pesapp.estore.operator.ability.OpeFscApplyMailImportInvoiceService;
import com.tydic.pesapp.estore.operator.ability.bo.OpeBusiReceiptUploadReqBO;
import com.tydic.pesapp.estore.operator.ability.bo.OpeFscBaseRspBo;
import com.tydic.pesapp.estore.operator.ability.bo.OpeFscFileAppBO;
import com.tydic.pesapp.estore.operator.ability.bo.OperatorReconcilitionDetailImportAddRspBO;
import com.tydic.pesapp.estore.operator.dataimport.OpeFscImportInvoiceInfoService;
import com.tydic.pesapp.estore.operator.dataimport.OpeFscReceiptUploadService;
import com.tydic.pesapp.estore.operator.dataimport.OperatorFscImportReconcilitionInfoService;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/estore/fsc/import"})
public class OperatorFscDataImportController {
    private final OperatorFscImportReconcilitionInfoService fscImportReconcilitionInfoService;
    @Autowired
    private OpeFscApplyMailImportInvoiceService opeFscApplyMailImportInvoiceService;
    private final OpeFscReceiptUploadService opeFscReceiptUploadService;
    private final OpeFscImportInvoiceInfoService opeFscImportInvoiceInfoService;

    @Autowired
    public OperatorFscDataImportController(OperatorFscImportReconcilitionInfoService fscImportReconcilitionInfoService, OpeFscReceiptUploadService opeFscReceiptUploadService, OpeFscImportInvoiceInfoService opeFscImportInvoiceInfoService) {
        this.fscImportReconcilitionInfoService = fscImportReconcilitionInfoService;
        this.opeFscReceiptUploadService = opeFscReceiptUploadService;
        this.opeFscImportInvoiceInfoService = opeFscImportInvoiceInfoService;
    }

    @PostMapping(value={"/reconciliationDetail"})
    @JsonBusiResponseBody
    public Object reconcilitionDetailImportAdd(HttpServletResponse response, @RequestParam(value="file") MultipartFile file) {
        if (file == null) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\u4e3a\u7a7a");
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            OpeFscFileAppBO opeFscFileAppBO = new OpeFscFileAppBO();
            opeFscFileAppBO.setFile(bytes);
            opeFscFileAppBO.setFileName(fileName);
            opeFscFileAppBO.setFileType(suffix);
            UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
            if (userInfo != null) {
                opeFscFileAppBO.setUserId(userInfo.getUserId());
            }
            OperatorReconcilitionDetailImportAddRspBO operatorReconcilitionDetailImportAddRspBO = this.fscImportReconcilitionInfoService.reconcilitionDetailImportAdd(response, opeFscFileAppBO);
            return operatorReconcilitionDetailImportAddRspBO;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
    }

    @PostMapping(value={"/invoiceMailInfo"})
    @JsonBusiResponseBody
    public Object importInvoiceMailInfo(@RequestParam(value="file") MultipartFile file) {
        if (file == null) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\u4e3a\u7a7a");
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            OpeFscFileAppBO opeFscFileAppBO = new OpeFscFileAppBO();
            opeFscFileAppBO.setFile(bytes);
            opeFscFileAppBO.setFileName(fileName);
            opeFscFileAppBO.setFileType(suffix);
            UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
            if (userInfo != null) {
                opeFscFileAppBO.setUserId(userInfo.getUserId());
            }
            OpeFscBaseRspBo opeFscBaseRspBo = this.opeFscApplyMailImportInvoiceService.importInvoice(opeFscFileAppBO);
            return opeFscBaseRspBo;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
    }

    @PostMapping(value={"/receiptUpload"})
    @JsonBusiResponseBody
    public Object importReceiptUpload(HttpServletResponse response, @RequestParam(value="file") MultipartFile file, OpeBusiReceiptUploadReqBO reqBO) {
        if (file == null) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\u4e3a\u7a7a");
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            OpeFscFileAppBO opeFscFileAppBO = new OpeFscFileAppBO();
            opeFscFileAppBO.setFile(bytes);
            opeFscFileAppBO.setFileName(fileName);
            opeFscFileAppBO.setFileType(suffix);
            UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
            if (userInfo != null) {
                opeFscFileAppBO.setUserId(userInfo.getUserId());
            }
            OpeFscBaseRspBo opeFscBaseRspBo = this.opeFscReceiptUploadService.receiptUpload(response, opeFscFileAppBO, reqBO);
            return opeFscBaseRspBo;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
    }

    @PostMapping(value={"/invoiceInfo"})
    @JsonBusiResponseBody
    public Object importInvoiceInfo(@RequestParam(value="file") MultipartFile file) {
        if (file == null) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\u4e3a\u7a7a");
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            OpeFscFileAppBO opeFscFileAppBO = new OpeFscFileAppBO();
            opeFscFileAppBO.setFile(bytes);
            opeFscFileAppBO.setFileName(fileName);
            opeFscFileAppBO.setFileType(suffix);
            UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
            if (userInfo != null) {
                opeFscFileAppBO.setUserId(userInfo.getUserId());
            }
            OpeFscBaseRspBo opeFscBaseRspBo = this.opeFscImportInvoiceInfoService.importData(opeFscFileAppBO);
            return opeFscBaseRspBo;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
    }
}

