/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.estore.operator.util;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class Utils {
    private static final String CAS = "CAS:\\d{1,5}(-\\d{1,3}){2}[,|\\s|\u3002]";
    private static final String CAS_NUMBER = "\\d{1,5}(/\\d{1,3}|-\\d{1,3}){2}";

    public static String get16UUID() {
        byte[] outputByteArray;
        String uuid = UUID.randomUUID().toString();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] inputByteArray = uuid.getBytes();
            messageDigest.update(inputByteArray);
            outputByteArray = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        StringBuffer buf = new StringBuffer("");
        for (int offset = 0; offset < outputByteArray.length; ++offset) {
            int i = outputByteArray[offset];
            if (i < 0) {
                i += 256;
            }
            if (i < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(i));
        }
        return buf.toString().substring(8, 24);
    }

    public static String getFileSuffix(String fileName) {
        int indexSuffix = fileName.lastIndexOf(".");
        if (indexSuffix != -1) {
            return fileName.substring(indexSuffix, fileName.length());
        }
        return fileName;
    }

    public static List<String> checkCAS(String cas) {
        return Utils.getMatchers(CAS, cas);
    }

    public static List<String> getMatchers(String regex, String source) {
        ArrayList matcherStr = Lists.newArrayList();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            matcherStr.add(matcher.group().replaceAll(",", "").replaceAll("CAS:", "").replaceAll("cas:", ""));
        }
        return matcherStr;
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static List<Long> convertArrayToList(String[] arrays) {
        List<Long> ids;
        try {
            List<String> list = Arrays.asList(arrays);
            ids = list.stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570");
        }
        if (CollectionUtils.isEmpty(ids)) {
            throw new ZTBusinessException("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        }
        return ids;
    }
}

